/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.wizards;

import java.io.File;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.internal.ui.SWTUtils;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.wizards.PsfFilenameStore;
import org.eclipse.team.internal.ui.wizards.TeamWizardPage;
import org.eclipse.team.internal.ui.wizards.WorkingSetsDialog;
import org.eclipse.ui.PlatformUI;

public class ImportProjectSetMainPage
extends TeamWizardPage {
    Combo fileCombo;
    String file = "";
    Button browseButton;
    Button addToWorkingSet;
    Text workingSetField;
    private boolean createWorkingSet = false;
    private String workingSetName = "";
    private boolean haveBrowsed;
    private boolean runInBackground = ImportProjectSetMainPage.isRunInBackgroundPreferenceOn();

    public ImportProjectSetMainPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        this.setDescription(TeamUIMessages.ImportProjectSetMainPage_description);
    }

    public void createControl(Composite parent) {
        Composite composite = this.createComposite(parent, 1);
        this.initializeDialogUnits((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.team.ui.import_project_set_page_context");
        Composite inner = new Composite(composite, 0);
        inner.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        inner.setLayout((Layout)layout);
        this.createLabel(inner, TeamUIMessages.ImportProjectSetMainPage_Project_Set_File_Name__2);
        this.fileCombo = this.createDropDownCombo(inner);
        this.file = PsfFilenameStore.getSuggestedDefault();
        this.fileCombo.setItems(PsfFilenameStore.getHistory());
        this.fileCombo.setText(this.file);
        this.fileCombo.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                ImportProjectSetMainPage.this.file = ImportProjectSetMainPage.this.fileCombo.getText();
                ImportProjectSetMainPage.this.updateEnablement();
            }
        });
        this.browseButton = new Button(inner, 8);
        this.browseButton.setText(TeamUIMessages.ImportProjectSetMainPage_Browse_3);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        data.widthHint = Math.max(widthHint, this.browseButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.browseButton.setLayoutData((Object)data);
        this.browseButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FileDialog d = new FileDialog(ImportProjectSetMainPage.this.getShell());
                d.setFilterExtensions(new String[]{"*.psf", "*"});
                d.setFilterNames(new String[]{TeamUIMessages.ImportProjectSetMainPage_Project_Set_Files_2, TeamUIMessages.ImportProjectSetMainPage_allFiles});
                String fileName = ImportProjectSetMainPage.this.getFileName();
                if (fileName != null && fileName.length() > 0) {
                    int separator = fileName.lastIndexOf(System.getProperty("file.separator").charAt(0));
                    if (separator != -1) {
                        fileName = fileName.substring(0, separator);
                    }
                } else {
                    fileName = ResourcesPlugin.getWorkspace().getRoot().getLocation().toString();
                }
                d.setFilterPath(fileName);
                String f = d.open();
                if (f != null) {
                    ImportProjectSetMainPage.this.fileCombo.setText(f);
                    ImportProjectSetMainPage.this.file = f;
                }
            }
        });
        this.addWorkingSetSection(composite);
        Button runInBackgroundCheckbox = SWTUtils.createCheckBox(composite, TeamUIMessages.ImportProjectSetMainPage_runInBackground, 3);
        runInBackgroundCheckbox.setSelection(ImportProjectSetMainPage.isRunInBackgroundPreferenceOn());
        runInBackgroundCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportProjectSetMainPage.this.runInBackground = !ImportProjectSetMainPage.this.runInBackground;
            }
        });
        this.setControl((Control)composite);
        this.updateEnablement();
        Dialog.applyDialogFont((Control)parent);
    }

    private void addWorkingSetSection(Composite composite) {
        this.addToWorkingSet = new Button(composite, 16416);
        this.addToWorkingSet.setText(TeamUIMessages.ImportProjectSetMainPage_AddToWorkingSet);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        this.addToWorkingSet.setLayoutData((Object)data);
        this.addToWorkingSet.setSelection(false);
        this.addToWorkingSet.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportProjectSetMainPage.this.createWorkingSet = !ImportProjectSetMainPage.this.createWorkingSet;
                ImportProjectSetMainPage.this.updateEnablement();
            }
        });
        Composite inner = new Composite(composite, 0);
        inner.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        inner.setLayout((Layout)layout);
        this.workingSetField = this.createTextField(inner);
        this.workingSetField.setEditable(false);
        this.browseButton = new Button(inner, 8);
        this.browseButton.setText(TeamUIMessages.ImportProjectSetMainPage_Browse);
        data = new GridData(256);
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        Point minSize = this.browseButton.computeSize(-1, -1, true);
        data.widthHint = Math.max(widthHint, minSize.x);
        this.browseButton.setLayoutData((Object)data);
        this.haveBrowsed = false;
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkingSetsDialog dialog = new WorkingSetsDialog(ImportProjectSetMainPage.this.getShell());
                ImportProjectSetMainPage.this.haveBrowsed = true;
                if (dialog.open() == 0) {
                    ImportProjectSetMainPage.this.workingSetField.setText(dialog.getSelectedWorkingSet());
                }
                ImportProjectSetMainPage.this.updateEnablement();
            }
        });
        this.updateEnablement();
    }

    private boolean validateWorkingSetName() {
        if (this.addToWorkingSet.getSelection()) {
            this.workingSetName = this.workingSetField.getText();
            if (this.workingSetName.length() == 0) {
                this.setMessage(TeamUIMessages.ImportProjectSetMainPage_workingSetNameEmpty, 3);
                return false;
            }
        }
        this.setMessage(null);
        return true;
    }

    private void updateEnablement() {
        this.setMessage(null);
        this.workingSetField.setEnabled(this.addToWorkingSet.getSelection());
        this.browseButton.setEnabled(this.addToWorkingSet.getSelection());
        if (this.file.length() == 0) {
            this.setPageComplete(false);
            return;
        }
        File f = new File(this.file);
        if (!f.exists()) {
            this.setMessage(TeamUIMessages.ImportProjectSetMainPage_The_specified_file_does_not_exist_4, 3);
            this.setPageComplete(false);
            return;
        }
        if (f.isDirectory()) {
            this.setMessage(TeamUIMessages.ImportProjectSetMainPage_You_have_specified_a_folder_5, 3);
            this.setPageComplete(false);
            return;
        }
        if (this.addToWorkingSet.getSelection() && !this.haveBrowsed) {
            this.setPageComplete(false);
            return;
        }
        boolean complete = this.validateWorkingSetName();
        this.setPageComplete(complete);
    }

    public String getFileName() {
        return this.file;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.fileCombo.setFocus();
        }
    }

    public String getWorkingSetName() {
        if (!this.createWorkingSet) {
            return null;
        }
        return this.workingSetName;
    }

    private static boolean isRunInBackgroundPreferenceOn() {
        return TeamUIPlugin.getPlugin().getPreferenceStore().getBoolean("org.eclipse.team.ui.run_import_in_background_");
    }

    public boolean isRunInBackgroundOn() {
        return this.runInBackground;
    }
}

