/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.pathmapper;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.php.internal.debug.core.pathmapper.PathEntry;
import org.eclipse.php.internal.debug.core.pathmapper.PathMapper;
import org.eclipse.php.internal.debug.ui.pathmapper.PathMapperEntryDialog;
import org.eclipse.php.internal.ui.preferences.ScrolledCompositeImpl;
import org.eclipse.php.internal.ui.util.PHPPluginImages;
import org.eclipse.php.internal.ui.util.PHPUILabelProvider;
import org.eclipse.php.internal.ui.util.PixelConverter;
import org.eclipse.php.internal.ui.wizards.fields.IListAdapter;
import org.eclipse.php.internal.ui.wizards.fields.ListDialogField;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class PathMappingComposite
extends Composite {
    private static final int IDX_ADD = 0;
    private static final int IDX_EDIT = 1;
    private static final int IDX_REMOVE = 2;
    private static final String[] buttonLabels = new String[]{"&Add", "&Edit", "&Remove"};
    private static final String[] columnHeaders = new String[]{"Path on server", "Local path"};
    private static final ColumnLayoutData[] columnLayoutDatas = new ColumnLayoutData[]{new ColumnWeightData(50), new ColumnWeightData(50)};
    private ListDialogField fMapList;

    public PathMappingComposite(Composite composite, int n) {
        super(composite, n);
        this.initializeControls();
    }

    protected void initializeControls() {
        this.fMapList = new ListDialogField((IListAdapter)new ListAdapter(), buttonLabels, (ILabelProvider)new LabelProvider());
        this.fMapList.setRemoveButtonIndex(2);
        this.fMapList.setTableColumns(new ListDialogField.ColumnsDescription(columnLayoutDatas, columnHeaders, true));
        GridLayout gridLayout = new GridLayout();
        this.setLayout((Layout)gridLayout);
        this.setLayoutData(new GridData(1808));
        PixelConverter pixelConverter = new PixelConverter((Control)this);
        ScrolledCompositeImpl scrolledCompositeImpl = new ScrolledCompositeImpl((Composite)this, 768);
        scrolledCompositeImpl.setLayout((Layout)gridLayout);
        scrolledCompositeImpl.setLayoutData((Object)new GridData(1808));
        Composite composite = new Composite((Composite)scrolledCompositeImpl, 0);
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        scrolledCompositeImpl.setContent((Control)composite);
        scrolledCompositeImpl.setFont(this.getFont());
        GridData gridData = new GridData(1808);
        gridData.widthHint = pixelConverter.convertWidthInCharsToPixels(50);
        Control control = this.fMapList.getListControl(composite);
        control.setLayoutData((Object)gridData);
        Composite composite2 = this.fMapList.getButtonBox(composite);
        composite2.setLayoutData((Object)new GridData(258));
        Point point = composite.computeSize(-1, -1);
        scrolledCompositeImpl.setMinSize(point.x, point.y);
        this.updateButtonsEnablement();
    }

    protected void handleAdd() {
        PathMapperEntryDialog pathMapperEntryDialog = new PathMapperEntryDialog(this.getShell());
        if (pathMapperEntryDialog.open() == 0) {
            PathMapper.Mapping mapping = pathMapperEntryDialog.getResult();
            this.fMapList.addElement((Object)mapping);
        }
    }

    protected void handleEdit() {
        List list = this.fMapList.getSelectedElements();
        if (list.size() == 1) {
            PathMapper.Mapping mapping = (PathMapper.Mapping)list.get(0);
            PathMapperEntryDialog pathMapperEntryDialog = new PathMapperEntryDialog(this.getShell(), mapping);
            if (pathMapperEntryDialog.open() == 0) {
                PathMapper.Mapping mapping2 = pathMapperEntryDialog.getResult();
                this.fMapList.replaceElement((Object)mapping, (Object)mapping2);
            }
        }
    }

    protected void handleRemove() {
        this.fMapList.removeElements(this.fMapList.getSelectedElements());
    }

    public void setData(Object object) {
        if (!(object instanceof PathMapper.Mapping[])) {
            throw new IllegalArgumentException("Data must be instance of Mapping[]");
        }
        PathMapper.Mapping[] mappingArray = (PathMapper.Mapping[])object;
        this.fMapList.setElements((Collection)Arrays.asList(mappingArray));
        this.updateButtonsEnablement();
    }

    public PathMapper.Mapping[] getMappings() {
        List list = this.fMapList.getElements();
        return list.toArray(new PathMapper.Mapping[list.size()]);
    }

    protected void updateButtonsEnablement() {
        List list = this.fMapList.getSelectedElements();
        this.fMapList.enableButton(1, list.size() == 1);
        this.fMapList.enableButton(2, list.size() > 0);
    }

    class LabelProvider
    extends org.eclipse.jface.viewers.LabelProvider
    implements ITableLabelProvider {
        private PHPUILabelProvider phpLabelProvider = new PHPUILabelProvider();

        LabelProvider() {
        }

        public Image getColumnImage(Object object, int n) {
            if (n == 1) {
                PathMapper.Mapping mapping = (PathMapper.Mapping)object;
                if (mapping.type == PathEntry.Type.EXTERNAL) {
                    return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
                }
                if (mapping.type == PathEntry.Type.INCLUDE_VAR) {
                    return PHPPluginImages.get((String)"org.eclipse.php.ui.envvar_obj.gif");
                }
                if (mapping.type == PathEntry.Type.INCLUDE_FOLDER) {
                    return PHPPluginImages.get((String)"org.eclipse.php.ui.library_obj.gif");
                }
                IResource iResource = ResourcesPlugin.getWorkspace().getRoot().findMember(mapping.localPath.toString());
                if (iResource != null) {
                    return this.phpLabelProvider.getImage((Object)iResource);
                }
            }
            return null;
        }

        public String getColumnText(Object object, int n) {
            PathMapper.Mapping mapping = (PathMapper.Mapping)object;
            switch (n) {
                case 0: {
                    return mapping.remotePath.toString();
                }
                case 1: {
                    return mapping.localPath.toString();
                }
            }
            return null;
        }
    }

    class ListAdapter
    implements IListAdapter {
        ListAdapter() {
        }

        public void customButtonPressed(ListDialogField listDialogField, int n) {
            switch (n) {
                case 0: {
                    PathMappingComposite.this.handleAdd();
                    break;
                }
                case 1: {
                    PathMappingComposite.this.handleEdit();
                    break;
                }
                case 2: {
                    PathMappingComposite.this.handleRemove();
                }
            }
        }

        public void doubleClicked(ListDialogField listDialogField) {
            PathMappingComposite.this.handleEdit();
        }

        public void selectionChanged(ListDialogField listDialogField) {
            PathMappingComposite.this.updateButtonsEnablement();
        }
    }
}

