/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.xml.details;

import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jpt.core.internal.AccessType;
import org.eclipse.jpt.core.internal.IJpaContentNode;
import org.eclipse.jpt.core.internal.XmlEObject;
import org.eclipse.jpt.core.internal.content.orm.EntityMappings;
import org.eclipse.jpt.core.internal.content.orm.EntityMappingsInternal;
import org.eclipse.jpt.ui.internal.details.BaseJpaDetailsPage;
import org.eclipse.jpt.ui.internal.mappings.details.StringWithDefaultChooser;
import org.eclipse.jpt.ui.internal.xml.JptUiXmlMessages;
import org.eclipse.jpt.ui.internal.xml.details.AccessTypeComboViewer;
import org.eclipse.jpt.ui.internal.xml.details.CommonWidgets;
import org.eclipse.jpt.ui.internal.xml.details.PersistenceUnitMetadataSection;
import org.eclipse.jpt.ui.internal.xml.details.XmlPackageChooser;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class XmlEntityMappingsDetailsPage
extends BaseJpaDetailsPage {
    private EntityMappings entityMappings;
    private XmlPackageChooser xmlPackageChooser;
    private StringWithDefaultChooser xmlSchemaChooser;
    private StringWithDefaultChooser xmlCatalogChooser;
    private AccessTypeComboViewer accessComboViewer;
    private PersistenceUnitMetadataSection persistenceUnitMetadataSection;

    public XmlEntityMappingsDetailsPage(Composite parent, TabbedPropertySheetWidgetFactory widgetFactory) {
        super(parent, (CommandStack)new BasicCommandStack(), widgetFactory);
    }

    protected void initializeLayout(Composite composite) {
        IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 6;
        composite.setLayout((Layout)layout);
        CommonWidgets.buildPackageLabel(composite, this.getWidgetFactory());
        this.xmlPackageChooser = CommonWidgets.buildXmlPackageChooser(composite, this.commandStack, this.getWidgetFactory());
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        gridData.grabExcessHorizontalSpace = true;
        this.xmlPackageChooser.getControl().setLayoutData((Object)gridData);
        helpSystem.setHelp(this.xmlPackageChooser.getControl(), "org.eclipse.jpt.ui.orm_package");
        CommonWidgets.buildSchemaLabel(composite, this.getWidgetFactory());
        this.xmlSchemaChooser = CommonWidgets.buildSchemaChooser(composite, this.commandStack, this.getWidgetFactory());
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        gridData.grabExcessHorizontalSpace = true;
        this.xmlSchemaChooser.getCombo().setLayoutData((Object)gridData);
        helpSystem.setHelp(this.xmlSchemaChooser.getControl(), "org.eclipse.jpt.ui.orm_schema");
        CommonWidgets.buildCatalogLabel(composite, this.getWidgetFactory());
        this.xmlCatalogChooser = CommonWidgets.buildCatalogChooser(composite, this.commandStack, this.getWidgetFactory());
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        gridData.grabExcessHorizontalSpace = true;
        this.xmlCatalogChooser.getCombo().setLayoutData((Object)gridData);
        helpSystem.setHelp(this.xmlCatalogChooser.getControl(), "org.eclipse.jpt.ui.orm_catalog");
        CommonWidgets.buildAccessLabel(composite, this.getWidgetFactory());
        this.accessComboViewer = CommonWidgets.buildAccessTypeComboViewer(composite, this.commandStack, this.getWidgetFactory());
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        gridData.grabExcessHorizontalSpace = true;
        this.accessComboViewer.getControl().setLayoutData((Object)gridData);
        helpSystem.setHelp(this.accessComboViewer.getControl(), "org.eclipse.jpt.ui.orm_access");
        this.persistenceUnitMetadataSection = new PersistenceUnitMetadataSection(composite, this.commandStack, this.getWidgetFactory());
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        this.persistenceUnitMetadataSection.getSection().setLayoutData((Object)gridData);
    }

    protected void doPopulate(IJpaContentNode contentNode) {
        this.entityMappings = (EntityMappings)contentNode;
        this.xmlPackageChooser.populate((EObject)this.entityMappings);
        this.xmlSchemaChooser.populate(new SchemaHolder(this.entityMappings));
        this.xmlCatalogChooser.populate(new CatalogHolder(this.entityMappings));
        this.accessComboViewer.populate(new MyAccessHolder(this.entityMappings));
        if (this.entityMappings != null) {
            this.persistenceUnitMetadataSection.populate((EObject)this.entityMappings.getPersistenceUnitMetadata());
        } else {
            this.persistenceUnitMetadataSection.populate(null);
        }
    }

    protected void doPopulate() {
        this.xmlPackageChooser.populate();
        this.xmlSchemaChooser.populate();
        this.xmlCatalogChooser.populate();
        this.accessComboViewer.populate();
        this.persistenceUnitMetadataSection.populate();
    }

    public void dispose() {
        this.xmlPackageChooser.dispose();
        this.xmlSchemaChooser.dispose();
        this.xmlCatalogChooser.dispose();
        this.accessComboViewer.dispose();
        this.persistenceUnitMetadataSection.dispose();
        super.dispose();
    }

    protected void engageListeners() {
    }

    protected void disengageListeners() {
    }

    private class CatalogHolder
    extends XmlEObject
    implements StringWithDefaultChooser.StringHolder {
        private EntityMappingsInternal entityMappings;

        CatalogHolder(EntityMappings entityMappings) {
            this.entityMappings = (EntityMappingsInternal)entityMappings;
        }

        public Class featureClass() {
            return EntityMappingsInternal.class;
        }

        public int featureId() {
            return 13;
        }

        public boolean supportsDefault() {
            return true;
        }

        public int defaultFeatureId() {
            return 12;
        }

        public String defaultItem() {
            String defaultCatalog = this.entityMappings.getDefaultCatalog();
            if (defaultCatalog != null) {
                return NLS.bind((String)JptUiXmlMessages.XMLEntityMappingsPage_CatalogDefault, (Object)defaultCatalog);
            }
            return JptUiXmlMessages.XMLEntityMappingsPage_CatalogNoDefaultSpecified;
        }

        public String getString() {
            return this.entityMappings.getSpecifiedCatalog();
        }

        public void setString(String newCatalog) {
            this.entityMappings.setSpecifiedCatalog(newCatalog);
        }

        public EObject wrappedObject() {
            return this.entityMappings;
        }
    }

    private class MyAccessHolder
    extends XmlEObject
    implements AccessTypeComboViewer.AccessHolder {
        private EntityMappingsInternal entityMappings;

        MyAccessHolder(EntityMappings entityMappings) {
            this.entityMappings = (EntityMappingsInternal)entityMappings;
        }

        public void setAccess(AccessType accessType) {
            this.entityMappings.setSpecifiedAccess(accessType);
        }

        public AccessType getAccess() {
            return this.entityMappings.getSpecifiedAccess();
        }

        public Class featureClass() {
            return EntityMappingsInternal.class;
        }

        public int featureId() {
            return 16;
        }

        public EObject wrappedObject() {
            return this.entityMappings;
        }
    }

    private class SchemaHolder
    extends XmlEObject
    implements StringWithDefaultChooser.StringHolder {
        private EntityMappingsInternal entityMappings;

        SchemaHolder(EntityMappings entityMappings) {
            this.entityMappings = (EntityMappingsInternal)entityMappings;
        }

        public Class featureClass() {
            return EntityMappingsInternal.class;
        }

        public int featureId() {
            return 10;
        }

        public boolean supportsDefault() {
            return true;
        }

        public int defaultFeatureId() {
            return 9;
        }

        public String defaultItem() {
            String defaultSchema = this.entityMappings.getDefaultSchema();
            if (defaultSchema != null) {
                return NLS.bind((String)JptUiXmlMessages.XMLEntityMappingsPage_SchemaDefault, (Object)defaultSchema);
            }
            return JptUiXmlMessages.XMLEntityMappingsPage_SchemaNoDefaultSpecified;
        }

        public String getString() {
            return this.entityMappings.getSpecifiedSchema();
        }

        public void setString(String newSchema) {
            this.entityMappings.setSpecifiedSchema(newSchema);
        }

        public EObject wrappedObject() {
            return this.entityMappings;
        }
    }
}

