/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.xdebug.breakpoints;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.php.internal.debug.core.model.PHPLineBreakpoint;
import org.eclipse.php.internal.debug.core.model.PHPRunToLineBreakpoint;
import org.eclipse.php.internal.debug.core.preferences.PHPProjectPreferences;
import org.eclipse.php.internal.debug.core.sourcelookup.PHPSourceNotFoundInput;
import org.eclipse.php.internal.debug.core.sourcelookup.containers.PHPCompositeSourceContainer;
import org.eclipse.php.internal.debug.core.xdebug.IDELayer;
import org.eclipse.php.internal.debug.core.xdebug.breakpoints.PdtBreakpoint;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpBreakpoint;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpBreakpointFacade;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpLogger;
import org.eclipse.php.internal.debug.core.zend.debugger.Breakpoint;

public class PdtLayer
implements IDELayer,
DBGpBreakpointFacade {
    public Preferences getPrefs() {
        Preferences preferences = PHPProjectPreferences.getModelPreferences();
        return preferences;
    }

    public String getBreakpointModelID() {
        return "org.eclipse.php.debug.core";
    }

    public Object sourceNotFound(Object object) {
        PHPSourceNotFoundInput pHPSourceNotFoundInput = null;
        if (object instanceof IStackFrame) {
            pHPSourceNotFoundInput = new PHPSourceNotFoundInput((IStackFrame)object);
        }
        return pHPSourceNotFoundInput;
    }

    public ISourceContainer getSourceContainer(IProject iProject, ILaunchConfiguration iLaunchConfiguration) {
        return new PHPCompositeSourceContainer(iProject, iLaunchConfiguration);
    }

    public DBGpBreakpoint createDBGpBreakpoint(IBreakpoint iBreakpoint) {
        return new PdtBreakpoint((PHPLineBreakpoint)iBreakpoint);
    }

    public IBreakpoint findBreakpointHit(String string, int n) {
        IBreakpoint iBreakpoint = null;
        IBreakpoint[] iBreakpointArray = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(this.getBreakpointModelID());
        int n2 = 0;
        while (n2 < iBreakpointArray.length) {
            IBreakpoint iBreakpoint2 = iBreakpointArray[n2];
            if (this.supportsBreakpoint(iBreakpoint2) && iBreakpoint2 instanceof PHPLineBreakpoint) {
                PHPLineBreakpoint pHPLineBreakpoint = (PHPLineBreakpoint)iBreakpoint2;
                Breakpoint breakpoint = pHPLineBreakpoint.getRuntimeBreakpoint();
                String string2 = breakpoint.getFileName();
                int n3 = breakpoint.getLineNumber();
                if (n3 == n && string2.equals(string)) {
                    iBreakpoint = iBreakpoint2;
                    if (DBGpLogger.debugBP()) {
                        DBGpLogger.debug("breakpoint at " + string + "(" + n + ") found");
                    }
                }
                if (iBreakpoint2 instanceof PHPRunToLineBreakpoint) {
                    IBreakpointManager iBreakpointManager = DebugPlugin.getDefault().getBreakpointManager();
                    try {
                        if (DBGpLogger.debugBP()) {
                            DBGpLogger.debug("removing runtoline breakpoint");
                        }
                        iBreakpointManager.removeBreakpoint(iBreakpoint2, true);
                    }
                    catch (CoreException coreException) {
                        DBGpLogger.logException("Exception trying to remove a runtoline breakpoint", this, coreException);
                    }
                }
            }
            ++n2;
        }
        return iBreakpoint;
    }

    public boolean supportsBreakpoint(IBreakpoint iBreakpoint) {
        return iBreakpoint.getModelIdentifier().equals(this.getBreakpointModelID());
    }

    public IBreakpoint createRunToLineBreakpoint(IFile iFile, int n) throws DebugException {
        return new PHPRunToLineBreakpoint(iFile, n);
    }

    public String getSystemDebugProperty() {
        return "org.eclipse.php.debug.ui.activeDebugging";
    }
}

