/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.xdebug.dbgp;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.UUID;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.php.internal.debug.core.xdebug.IDELayer;
import org.eclipse.php.internal.debug.core.xdebug.IDELayerFactory;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpLogger;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.protocol.DBGpResponse;

public class DBGpProxyHandler {
    private boolean registered = false;
    private String currentIdeKey = null;
    private String proxyHost = "";
    private int proxyPort = -1;
    private int idePort = -1;
    private int errorCode = 0;
    private String errorMsg = "";
    private boolean useProxy = false;
    private boolean multisession = false;
    private static final int DEFAULT_PROXY_PORT = 9001;
    public static DBGpProxyHandler instance = new DBGpProxyHandler();

    private DBGpProxyHandler() {
        this.configure();
    }

    public boolean registerWithProxy() {
        DBGpResponse dBGpResponse;
        if (!this.registered && (dBGpResponse = this.sendcmd("proxyinit -p " + this.idePort + " -k " + this.currentIdeKey + " -m " + (this.multisession ? "1" : "0"))) != null) {
            if (dBGpResponse.getType() == 4 && dBGpResponse.getErrorCode() == 0) {
                this.registered = true;
            } else {
                this.errorCode = dBGpResponse.getErrorCode();
                this.errorMsg = dBGpResponse.getErrorMessage();
            }
        }
        return this.registered;
    }

    public void unregister() {
        if (this.registered) {
            DBGpResponse dBGpResponse = this.sendcmd("proxystop -k " + this.currentIdeKey);
            this.registered = false;
            String string = DBGpResponse.getAttribute(dBGpResponse.getParentNode(), "success");
            if (string == null || !string.equals("1")) {
                DBGpLogger.logWarning("Unexpected response from proxystop. ErrorCode=" + dBGpResponse.getErrorCode() + ". msg=" + dBGpResponse.getErrorMessage(), this, null);
            }
        }
    }

    public boolean isRegistered() {
        return this.registered;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void configure() {
        IDELayer iDELayer = IDELayerFactory.getIDELayer();
        Preferences preferences = iDELayer.getPrefs();
        this.useProxy = preferences.getBoolean("org.eclipse.php.debug.core.xdebug_useproxy");
        if (!this.useProxy) {
            this.unregister();
        } else {
            String string;
            int n = preferences.getInt("org.eclipse.php.debug.core.xdebug_port");
            String string2 = preferences.getString("org.eclipse.php.debug.core.xdebug_idekey");
            boolean bl = preferences.getBoolean("org.eclipse.php.debug.core.xdebug_multisession");
            String string3 = string = preferences.getString("org.eclipse.php.debug.core.xdebug_proxy");
            int n2 = -1;
            int n3 = string.indexOf(58);
            if (n3 != -1) {
                string3 = string.substring(0, n3);
                if (n3 + 1 < string.length()) {
                    String string4 = string.substring(n3 + 1);
                    try {
                        n2 = Integer.parseInt(string4);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
            this.setProxyInfo(string3, n2, string2, n, bl);
        }
    }

    private void setProxyInfo(String string, int n, String string2, int n2, boolean bl) {
        if (n < 1) {
            n = 9001;
        }
        if (!string.equalsIgnoreCase(this.proxyHost) || n != this.proxyPort || !string2.equals(this.currentIdeKey) || this.idePort != n2 || this.multisession != bl) {
            this.unregister();
            this.proxyHost = string;
            this.proxyPort = n;
            this.idePort = n2;
            this.currentIdeKey = string2;
            this.multisession = bl;
        }
    }

    public boolean useProxy() {
        return this.useProxy;
    }

    private DBGpResponse sendcmd(String string) {
        DBGpResponse dBGpResponse = null;
        try {
            Socket socket = new Socket(this.proxyHost, this.proxyPort);
            InputStream inputStream = socket.getInputStream();
            OutputStream outputStream = socket.getOutputStream();
            if (DBGpLogger.debugCmd()) {
                DBGpLogger.debug("cmd: " + string);
            }
            outputStream.write(string.getBytes("ASCII"));
            outputStream.flush();
            byte[] byArray = this.readResponse(inputStream);
            dBGpResponse = new DBGpResponse();
            dBGpResponse.parseResponse(byArray);
            socket.shutdownInput();
            socket.shutdownOutput();
            socket.close();
            return dBGpResponse;
        }
        catch (IOException iOException) {
            if (dBGpResponse == null) {
                this.errorCode = 9999;
                if (iOException instanceof EOFException) {
                    this.errorMsg = "invalid response from proxy.";
                } else {
                    this.errorMsg = iOException.getMessage();
                    if (this.errorMsg == null) {
                        this.errorMsg = iOException.getClass().getName();
                    }
                }
            }
            return dBGpResponse;
        }
    }

    private byte[] readResponse(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = inputStream.read()) != -1) {
            byteArrayOutputStream.write(n);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        new String(byArray, "ASCII");
        if (DBGpLogger.debugResp()) {
            DBGpLogger.debug("Response: " + new String(byArray, "ASCII"));
        }
        return byArray;
    }

    public String generateIDEKey() {
        String string = null;
        try {
            string = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            string = UUID.randomUUID().toString();
        }
        return "ECLIPSE_DBGP_" + string;
    }

    public String getCurrentIdeKey() {
        return this.currentIdeKey;
    }
}

