/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.ui.PHPElementLabelProvider;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.actions.ActionUtils;
import org.eclipse.php.internal.ui.actions.SelectionDispatchAction;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.part.ResourceTransfer;

public class CopyToClipboardAction
extends SelectionDispatchAction {
    private final Clipboard fClipboard;
    private SelectionDispatchAction fPasteAction;
    private boolean fAutoRepeatOnFailure = false;

    public CopyToClipboardAction(IWorkbenchSite iWorkbenchSite, Clipboard clipboard, SelectionDispatchAction selectionDispatchAction) {
        super(iWorkbenchSite);
        this.setText(PHPUIMessages.getString("CopyToClipboardAction_text"));
        this.setDescription(PHPUIMessages.getString("CopyToClipboardAction_desc"));
        Assert.isNotNull((Object)clipboard);
        this.fClipboard = clipboard;
        this.fPasteAction = selectionDispatchAction;
        ISharedImages iSharedImages = CopyToClipboardAction.getWorkbenchSharedImages();
        this.setDisabledImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        this.setImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.setHoverImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.update(this.getSelection());
    }

    public void setAutoRepeatOnFailure(boolean bl) {
        this.fAutoRepeatOnFailure = bl;
    }

    private static ISharedImages getWorkbenchSharedImages() {
        return PHPUiPlugin.getDefault().getWorkbench().getSharedImages();
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        List list = iStructuredSelection.toList();
        IResource[] iResourceArray = ActionUtils.getResources(list);
        Object[] objectArray = ActionUtils.getPHPElements(list);
        if (list.size() != iResourceArray.length + objectArray.length) {
            this.setEnabled(false);
        } else {
            this.setEnabled(this.canEnable(iResourceArray, objectArray));
        }
    }

    public void run(IStructuredSelection iStructuredSelection) {
        List list = iStructuredSelection.toList();
        try {
            IResource[] iResourceArray = ActionUtils.getResources(list, true);
            Object[] objectArray = ActionUtils.getPHPElements(list, true);
            if (list.size() == iResourceArray.length + objectArray.length && this.canEnable(iResourceArray, objectArray)) {
                this.doRun(iResourceArray, objectArray);
            }
        }
        catch (CoreException coreException) {
            PHPUiPlugin.log(coreException);
        }
    }

    private void doRun(IResource[] iResourceArray, Object[] objectArray) throws CoreException {
        new ClipboardCopier(iResourceArray, objectArray, this.fClipboard, this.getShell(), this.fAutoRepeatOnFailure).copyToClipboard();
        if (this.fPasteAction != null && this.fPasteAction.getSelection() != null) {
            this.fPasteAction.update(this.fPasteAction.getSelection());
        }
    }

    private boolean canEnable(IResource[] iResourceArray, Object[] objectArray) {
        if (iResourceArray.length + objectArray.length == 0) {
            return false;
        }
        return this.canCopyAllToClipboard(iResourceArray, objectArray);
    }

    private boolean canCopyAllToClipboard(IResource[] iResourceArray, Object[] objectArray) {
        int n = 0;
        while (n < iResourceArray.length) {
            if (!CopyToClipboardAction.canCopyToClipboard(iResourceArray[n])) {
                return false;
            }
            ++n;
        }
        n = 0;
        while (n < objectArray.length) {
            if (!CopyToClipboardAction.canCopyToClipboard(objectArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private static boolean canCopyToClipboard(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof PHPCodeData) && !(object instanceof PHPProjectModel)) {
            return false;
        }
        return object instanceof PHPFileData;
    }

    private static boolean canCopyToClipboard(IResource iResource) {
        return iResource != null && iResource.exists() && !iResource.isPhantom() && iResource.getType() != 8;
    }

    private static class ClipboardCopier {
        private final boolean fAutoRepeatOnFailure;
        private final IResource[] fResources;
        private final Object[] fPHPElements;
        private final Clipboard fClipboard;
        private final Shell fShell;
        private final ILabelProvider fLabelProvider;

        private ClipboardCopier(IResource[] iResourceArray, Object[] objectArray, Clipboard clipboard, Shell shell, boolean bl) {
            this.fResources = iResourceArray;
            this.fPHPElements = objectArray;
            this.fClipboard = clipboard;
            this.fShell = shell;
            this.fLabelProvider = ClipboardCopier.createLabelProvider();
            this.fAutoRepeatOnFailure = bl;
        }

        public void copyToClipboard() throws CoreException {
            HashSet hashSet = new HashSet(this.fResources.length + this.fPHPElements.length);
            StringBuffer stringBuffer = new StringBuffer();
            this.processResources(hashSet, stringBuffer);
            this.processPHPElements(hashSet, stringBuffer);
            String[] stringArray = hashSet.toArray(new String[hashSet.size()]);
            this.copyToClipboard(this.fResources, stringArray, stringBuffer.toString(), this.fPHPElements, 0);
        }

        private void copyToClipboard(IResource[] iResourceArray, String[] stringArray, String string, Object[] objectArray, int n) {
            block6: {
                try {
                    this.fClipboard.setContents(ClipboardCopier.createDataArray(iResourceArray, objectArray, stringArray, string), ClipboardCopier.createDataTypeArray(iResourceArray, objectArray, stringArray));
                }
                catch (SWTError sWTError) {
                    if (sWTError.code != 2002 || n >= 10) {
                        throw sWTError;
                    }
                    if (this.fAutoRepeatOnFailure) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (!this.fAutoRepeatOnFailure && !MessageDialog.openQuestion((Shell)this.fShell, (String)PHPUIMessages.getString("CopyToClipboardAction_4"), (String)PHPUIMessages.getString("CopyToClipboardAction_5"))) break block6;
                    this.copyToClipboard(iResourceArray, stringArray, string, objectArray, n + 1);
                }
            }
        }

        private void processResources(Set set, StringBuffer stringBuffer) {
            int n = 0;
            while (n < this.fResources.length) {
                IResource iResource = this.fResources[n];
                ClipboardCopier.addFileName(set, iResource);
                if (n > 0) {
                    stringBuffer.append('\n');
                }
                stringBuffer.append(this.getName(iResource));
                ++n;
            }
        }

        private void processPHPElements(Set set, StringBuffer stringBuffer) {
            int n = 0;
            while (n < this.fPHPElements.length) {
                if (this.fPHPElements[n] instanceof PHPFileData) {
                    ClipboardCopier.addFileName(set, PHPModelUtil.getResource((Object)this.fPHPElements[n]));
                }
                if (this.fResources.length > 0 || n > 0) {
                    stringBuffer.append('\n');
                }
                stringBuffer.append(this.getName(this.fPHPElements[n]));
                ++n;
            }
        }

        private static Transfer[] createDataTypeArray(IResource[] iResourceArray, Object[] objectArray, String[] stringArray) {
            ArrayList<Object> arrayList = new ArrayList<Object>(4);
            if (iResourceArray.length != 0) {
                arrayList.add(ResourceTransfer.getInstance());
            }
            if (objectArray.length != 0) {
                throw new RuntimeException(PHPUIMessages.getString("CopyToClipboardAction.0"));
            }
            if (stringArray.length != 0) {
                arrayList.add(FileTransfer.getInstance());
            }
            arrayList.add(TextTransfer.getInstance());
            return arrayList.toArray(new Transfer[arrayList.size()]);
        }

        private static Object[] createDataArray(IResource[] iResourceArray, Object[] objectArray, String[] stringArray, String string) {
            ArrayList<Object> arrayList = new ArrayList<Object>(4);
            if (iResourceArray.length != 0) {
                arrayList.add(iResourceArray);
            }
            if (objectArray.length != 0) {
                arrayList.add(objectArray);
            }
            if (stringArray.length != 0) {
                arrayList.add(stringArray);
            }
            arrayList.add(string);
            return arrayList.toArray();
        }

        private static ILabelProvider createLabelProvider() {
            return new PHPElementLabelProvider(546);
        }

        private String getName(IResource iResource) {
            return this.fLabelProvider.getText((Object)iResource);
        }

        private String getName(Object object) {
            return this.fLabelProvider.getText(object);
        }

        private static void addFileNames(Set set, IResource[] iResourceArray) {
            int n = 0;
            while (n < iResourceArray.length) {
                ClipboardCopier.addFileName(set, iResourceArray[n]);
                ++n;
            }
        }

        private static void addFileName(Set set, IResource iResource) {
            if (iResource == null) {
                return;
            }
            IPath iPath = iResource.getLocation();
            if (iPath != null) {
                set.add(iPath.toOSString());
            }
        }
    }
}

