/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.folding;

import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.IProjectionListener;
import org.eclipse.jface.text.source.projection.IProjectionPosition;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.php.internal.core.documentModel.DOMModelForPHP;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPhpScriptRegion;
import org.eclipse.php.internal.core.phpModel.parser.ModelListener;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassVarData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPConstantData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPDocBlock;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileDataUtilities;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.document.DocumentReader;
import org.eclipse.wst.sse.core.internal.provisional.IModelStateListener;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.sse.ui.internal.projection.IStructuredTextFoldingProvider;

@Deprecated
public class DefaultPHPFoldingStructureProvider
implements IProjectionListener,
IStructuredTextFoldingProvider,
ModelListener {
    private static final PHPWorkspaceModelManager workspaceModelManagerInstance = PHPWorkspaceModelManager.getInstance();
    private ProjectionViewer viewer;
    private boolean collapseClasses = false;
    private boolean collapseFunctions = false;
    private boolean collapsePHPDoc = false;
    private boolean allowCollapsing;
    private IModelStateListener modelStateListener;
    private final ArrayList toRemove = new ArrayList();
    private final Map newFolds = new LinkedHashMap();
    private Timer timer;
    private IDocument document;
    private TimerTask timerTask;
    static int failCount;
    static final int MAX_RETRY = 3;
    static final int THREAD_DELAY = 5000;

    public void projectionEnabled() {
        this.projectionDisabled();
        this.initialize();
        if (this.document != null) {
            IStructuredModel iStructuredModel = StructuredModelManager.getModelManager().getExistingModelForRead(this.document);
            if (iStructuredModel == null) {
                TimerTask timerTask = new TimerTask(){

                    public void run() {
                        if (failCount++ < 3) {
                            DefaultPHPFoldingStructureProvider.this.projectionEnabled();
                        }
                    }
                };
                Timer timer = new Timer(false);
                timer.schedule(timerTask, 5000L);
                return;
            }
            this.modelStateListener = new PHPModelStateListener();
            iStructuredModel.addModelStateListener(this.modelStateListener);
            iStructuredModel.releaseFromRead();
            failCount = 0;
            this.timer = new Timer(false);
            this.timerTask = new FoldingTimerTask();
        }
    }

    public void projectionDisabled() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
            this.timerTask = null;
        }
        if (this.document != null) {
            IStructuredModel iStructuredModel = StructuredModelManager.getModelManager().getExistingModelForRead(this.document);
            if (iStructuredModel != null) {
                iStructuredModel.removeModelStateListener(this.modelStateListener);
                iStructuredModel.releaseFromRead();
            }
            this.modelStateListener = null;
            this.document = null;
        }
    }

    public void install(ProjectionViewer projectionViewer) {
        if (this.isInstalled()) {
            this.uninstall();
        }
        this.viewer = projectionViewer;
        projectionViewer.addProjectionListener((IProjectionListener)this);
        workspaceModelManagerInstance.addModelListener((ModelListener)this);
    }

    public void uninstall() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        if (this.isInstalled()) {
            this.projectionDisabled();
            this.viewer.removeProjectionListener((IProjectionListener)this);
            workspaceModelManagerInstance.removeModelListener((ModelListener)this);
            this.viewer = null;
        }
    }

    protected boolean isInstalled() {
        return this.viewer != null;
    }

    public void initialize() {
        if (!this.isInstalled()) {
            return;
        }
        this.initializePreferences();
        if (this.viewer.getProjectionAnnotationModel() != null) {
            this.viewer.getProjectionAnnotationModel().removeAllAnnotations();
        }
        this.document = this.viewer.getDocument();
        this.allowCollapsing = true;
        if (this.document != null) {
            this.updateFolds();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFolds() {
        block18: {
            IStructuredModel iStructuredModel = null;
            PHPFileData pHPFileData = null;
            try {
                iStructuredModel = StructuredModelManager.getModelManager().getExistingModelForRead(this.document);
                if (iStructuredModel == null || !(iStructuredModel instanceof DOMModelForPHP)) break block18;
                DOMModelForPHP dOMModelForPHP = (DOMModelForPHP)iStructuredModel;
                pHPFileData = dOMModelForPHP.getFileData();
                if (dOMModelForPHP.getProjectModel() == null) {
                    return;
                }
                try {
                    IProject iProject;
                    if (pHPFileData == null) {
                        iProject = dOMModelForPHP.getProjectModel().getProject();
                        pHPFileData = PHPFileDataUtilities.getFileData((Reader)new DocumentReader(this.document), (IProject)iProject);
                    }
                    workspaceModelManagerInstance.removeModelListener((ModelListener)this);
                    iProject = this.viewer.getProjectionAnnotationModel();
                    if (iProject == null) break block18;
                    Object object = iProject.getLockObject();
                    synchronized (object) {
                        Map map = this.computeAdditions(pHPFileData);
                        this.toRemove.clear();
                        this.newFolds.clear();
                        Iterator iterator = iProject.getAnnotationIterator();
                        LinkedHashMap<Position, ProjectionAnnotation> linkedHashMap = new LinkedHashMap<Position, ProjectionAnnotation>();
                        while (iterator.hasNext()) {
                            ProjectionAnnotation projectionAnnotation = (ProjectionAnnotation)iterator.next();
                            Position position = iProject.getPosition((Annotation)projectionAnnotation);
                            linkedHashMap.put(position, projectionAnnotation);
                        }
                        for (Position position : map.values()) {
                            if (linkedHashMap.remove(position) != null) continue;
                            this.newFolds.put(position.getAnnotation(), position);
                        }
                        boolean bl = false;
                        for (Map.Entry entry : linkedHashMap.entrySet()) {
                            AnnotatedPosition annotatedPosition = (AnnotatedPosition)((Object)entry.getKey());
                            PHPProjectionAnnotation pHPProjectionAnnotation = (PHPProjectionAnnotation)((Object)entry.getValue());
                            if (bl || !pHPProjectionAnnotation.isCollapsed()) {
                                this.toRemove.add(pHPProjectionAnnotation);
                                continue;
                            }
                            if (!this.shouldRemoveAnnotation(pHPProjectionAnnotation, annotatedPosition.offset)) continue;
                            this.toRemove.add(pHPProjectionAnnotation);
                            bl = true;
                        }
                        if (this.toRemove.size() > 0 || this.newFolds.size() > 0) {
                            iProject.replaceAnnotations(this.toRemove.toArray(new Annotation[this.toRemove.size()]), this.newFolds);
                        }
                    }
                }
                catch (ArrayStoreException arrayStoreException) {
                    arrayStoreException.printStackTrace();
                }
            }
            finally {
                if (iStructuredModel != null) {
                    iStructuredModel.releaseFromRead();
                    if (pHPFileData != null) {
                        this.allowCollapsing = false;
                    }
                }
            }
        }
    }

    private boolean shouldRemoveAnnotation(PHPProjectionAnnotation pHPProjectionAnnotation, int n) {
        if (this.document != null) {
            try {
                return this.isInComment((IStructuredDocument)this.document, n);
            }
            catch (BadLocationException badLocationException) {
                Logger.logException(badLocationException);
            }
        }
        return false;
    }

    private void initializePreferences() {
        IPreferenceStore iPreferenceStore = PHPUiPlugin.getDefault().getPreferenceStore();
        this.collapseClasses = iPreferenceStore.getBoolean("foldClasses");
        this.collapseFunctions = iPreferenceStore.getBoolean("foldFunctions");
        this.collapsePHPDoc = iPreferenceStore.getBoolean("foldPHPDoc");
    }

    protected Map computeAdditions(PHPFileData pHPFileData) {
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        try {
            this.computeClassesAdditions(pHPFileData, linkedHashMap);
            this.computeFunctionsAdditions(pHPFileData, linkedHashMap);
            this.computePHPDocAdditions(pHPFileData, linkedHashMap);
        }
        catch (Exception exception) {}
        return linkedHashMap;
    }

    private void computePHPDocAdditions(PHPFileData pHPFileData, Map map) {
        PHPClassData[] pHPClassDataArray;
        PHPConstantData pHPConstantData;
        PHPConstantData[] pHPConstantDataArray;
        ArrayList<PHPDocBlock> arrayList = new ArrayList<PHPDocBlock>();
        PHPDocBlock pHPDocBlock = pHPFileData.getDocBlock();
        arrayList.add(pHPDocBlock);
        PHPConstantData[] pHPConstantDataArray2 = pHPConstantDataArray = pHPFileData.getConstants();
        int n = pHPConstantDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            pHPConstantData = pHPConstantDataArray2[n2];
            arrayList.add(pHPConstantData.getDocBlock());
            ++n2;
        }
        PHPConstantData pHPConstantData2 = pHPConstantData = pHPFileData.getFunctions();
        int n3 = ((PHPConstantData)pHPConstantData2).length;
        n = 0;
        while (n < n3) {
            PHPConstantData pHPConstantData3 = pHPConstantData2[n];
            arrayList.add(pHPConstantData3.getDocBlock());
            ++n;
        }
        PHPClassData[] pHPClassDataArray2 = pHPClassDataArray = pHPFileData.getClasses();
        int n4 = pHPClassDataArray.length;
        n3 = 0;
        while (n3 < n4) {
            PHPClassVarData[] pHPClassVarDataArray;
            PHPFunctionData pHPFunctionData;
            PHPFunctionData[] pHPFunctionDataArray;
            PHPClassData pHPClassData = pHPClassDataArray2[n3];
            arrayList.add(pHPClassData.getDocBlock());
            PHPFunctionData[] pHPFunctionDataArray2 = pHPFunctionDataArray = pHPClassData.getFunctions();
            int n5 = pHPFunctionDataArray.length;
            int n6 = 0;
            while (n6 < n5) {
                pHPFunctionData = pHPFunctionDataArray2[n6];
                arrayList.add(pHPFunctionData.getDocBlock());
                ++n6;
            }
            PHPFunctionData pHPFunctionData2 = pHPFunctionData = pHPClassData.getConsts();
            int n7 = ((PHPFunctionData)pHPFunctionData2).length;
            n5 = 0;
            while (n5 < n7) {
                PHPFunctionData pHPFunctionData3 = pHPFunctionData2[n5];
                arrayList.add(pHPFunctionData3.getDocBlock());
                ++n5;
            }
            PHPClassVarData[] pHPClassVarDataArray2 = pHPClassVarDataArray = pHPClassData.getVars();
            int n8 = pHPClassVarDataArray.length;
            n7 = 0;
            while (n7 < n8) {
                PHPClassVarData pHPClassVarData = pHPClassVarDataArray2[n7];
                arrayList.add(pHPClassVarData.getDocBlock());
                ++n7;
            }
            ++n3;
        }
        this.addAnnotations(arrayList, map, this.allowCollapsing && this.collapsePHPDoc, true);
    }

    private void computeFunctionsAdditions(PHPFileData pHPFileData, Map map) {
        PHPFunctionData pHPFunctionData;
        PHPFunctionData[] pHPFunctionDataArray;
        ArrayList<PHPFunctionData> arrayList = new ArrayList<PHPFunctionData>();
        PHPFunctionData[] pHPFunctionDataArray2 = pHPFunctionDataArray = pHPFileData.getFunctions();
        int n = pHPFunctionDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            pHPFunctionData = pHPFunctionDataArray2[n2];
            arrayList.add(pHPFunctionData);
            ++n2;
        }
        PHPFunctionData pHPFunctionData2 = pHPFunctionData = pHPFileData.getClasses();
        int n3 = ((PHPFunctionData)pHPFunctionData2).length;
        n = 0;
        while (n < n3) {
            PHPFunctionData[] pHPFunctionDataArray3;
            PHPFunctionData pHPFunctionData3 = pHPFunctionData2[n];
            PHPFunctionData[] pHPFunctionDataArray4 = pHPFunctionDataArray3 = pHPFunctionData3.getFunctions();
            int n4 = pHPFunctionDataArray3.length;
            int n5 = 0;
            while (n5 < n4) {
                PHPFunctionData pHPFunctionData4 = pHPFunctionDataArray4[n5];
                arrayList.add(pHPFunctionData4);
                ++n5;
            }
            ++n;
        }
        this.addAnnotations(arrayList, map, this.allowCollapsing && this.collapseFunctions, false);
    }

    private void computeClassesAdditions(PHPFileData pHPFileData, Map map) {
        PHPClassData[] pHPClassDataArray;
        ArrayList<PHPClassData> arrayList = new ArrayList<PHPClassData>();
        PHPClassData[] pHPClassDataArray2 = pHPClassDataArray = pHPFileData.getClasses();
        int n = pHPClassDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            PHPClassData pHPClassData = pHPClassDataArray2[n2];
            arrayList.add(pHPClassData);
            ++n2;
        }
        this.addAnnotations(arrayList, map, this.allowCollapsing && this.collapseClasses, false);
    }

    private void addAnnotations(ArrayList arrayList, Map map, boolean bl, boolean bl2) {
        int n = 0;
        while (n < arrayList.size()) {
            Object e = arrayList.get(n);
            if (e != null) {
                AnnotatedPosition annotatedPosition = null;
                annotatedPosition = bl2 ? this.createAnnotatedPosition((PHPDocBlock)e) : this.createAnnotatedPosition((PHPCodeData)e);
                if (annotatedPosition != null) {
                    annotatedPosition.setAnnotation(new PHPProjectionAnnotation(e, bl, bl2));
                    map.put(annotatedPosition.getAnnotation(), annotatedPosition);
                }
            }
            ++n;
        }
    }

    private AnnotatedPosition createAnnotatedPosition(PHPCodeData pHPCodeData) {
        if (this.document == null) {
            return null;
        }
        try {
            int n = this.document.getLineOfOffset(pHPCodeData.getUserData().getStopPosition());
            int n2 = this.document.getLineOfOffset(pHPCodeData.getUserData().getEndPosition());
            return this.createAnnotatedPosition(n, n2);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private AnnotatedPosition createAnnotatedPosition(PHPDocBlock pHPDocBlock) {
        if (this.document == null) {
            return null;
        }
        try {
            int n = this.document.getLineOfOffset(pHPDocBlock.getStartPosition());
            int n2 = this.document.getLineOfOffset(pHPDocBlock.getEndPosition() + 1);
            return this.createCommentAnnotatedPosition(n, n2);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private AnnotatedPosition createAnnotatedPosition(int n, int n2) throws BadLocationException {
        if (n != n2) {
            int n3;
            int n4 = this.document.getLineOffset(n);
            if (this.document.getNumberOfLines() > n2 + 1) {
                n3 = this.document.getLineOffset(n2 + 1);
            } else if (n2 > n) {
                n3 = this.document.getLineOffset(n2) + this.document.getLineLength(n2);
            } else {
                return null;
            }
            return new AnnotatedPosition(n4, n3 - n4);
        }
        return null;
    }

    private AnnotatedPosition createCommentAnnotatedPosition(int n, int n2) throws BadLocationException {
        if (n != n2) {
            int n3;
            int n4 = this.document.getLineOffset(n);
            if (this.document.getNumberOfLines() > n2 + 1) {
                n3 = this.document.getLineOffset(n2 + 1);
            } else if (n2 > n) {
                n3 = this.document.getLineOffset(n2) + this.document.getLineLength(n2);
            } else {
                return null;
            }
            return new CommentAnnotatedPosition(n4, n3 - n4);
        }
        return null;
    }

    private boolean isInComment(IStructuredDocument iStructuredDocument, int n) throws BadLocationException {
        ITextRegion iTextRegion;
        IStructuredDocumentRegion iStructuredDocumentRegion = iStructuredDocument.getRegionAtCharacterOffset(n);
        ITextRegion iTextRegion2 = iStructuredDocumentRegion.getRegionAtCharacterOffset(n);
        if (iTextRegion2 == null) {
            return false;
        }
        IStructuredDocumentRegion iStructuredDocumentRegion2 = iStructuredDocumentRegion;
        if (iTextRegion2 instanceof ITextRegionContainer) {
            iStructuredDocumentRegion2 = (ITextRegionContainer)iTextRegion2;
            iTextRegion2 = iStructuredDocumentRegion2.getRegionAtCharacterOffset(n);
        }
        if (iTextRegion2.getType() == "PHP_OPEN") {
            return false;
        }
        if (iTextRegion2.getType() == "PHP_CLOSE") {
            if (iStructuredDocumentRegion2.getStartOffset(iTextRegion2) == n) {
                iTextRegion = iStructuredDocumentRegion2.getRegionAtCharacterOffset(n - 1);
                if (iTextRegion instanceof IPhpScriptRegion) {
                    iTextRegion2 = iTextRegion;
                }
            } else {
                return false;
            }
        }
        iTextRegion = null;
        String string = null;
        int n2 = 0;
        if (iTextRegion2 instanceof IPhpScriptRegion) {
            String string2;
            iTextRegion = (IPhpScriptRegion)iTextRegion2;
            n2 = n - iStructuredDocumentRegion2.getStartOffset() - iTextRegion.getStart();
            string = iTextRegion.getPartition(n2);
            if (!(string != "org.eclipse.php.PHP_MULTI_LINE_COMMENT" && string != "org.eclipse.php.PHP_DOC" || (string2 = iTextRegion.getPhpToken(n2).getType()) != "PHP_COMMENT_START" && string2 != "PHPDOC_COMMENT_START" || iTextRegion.getPhpToken(n2).getStart() != n2)) {
                string = iTextRegion.getPartition(n2 - 1);
            }
            return string == "org.eclipse.php.PHP_MULTI_LINE_COMMENT" || string == "org.eclipse.php.PHP_DOC";
        }
        return false;
    }

    public void dataCleared() {
    }

    public void fileDataAdded(PHPFileData pHPFileData) {
        IStructuredModel iStructuredModel = null;
        try {
            try {
                DOMModelForPHP dOMModelForPHP;
                iStructuredModel = StructuredModelManager.getModelManager().getExistingModelForRead(this.document);
                if (iStructuredModel != null && iStructuredModel instanceof DOMModelForPHP && (dOMModelForPHP = (DOMModelForPHP)iStructuredModel).getFileData() == pHPFileData) {
                    this.updateFolds();
                }
            }
            catch (Throwable throwable) {
                if (iStructuredModel != null) {
                    iStructuredModel.releaseFromRead();
                }
            }
        }
        finally {
            if (iStructuredModel != null) {
                iStructuredModel.releaseFromRead();
            }
        }
    }

    public void fileDataChanged(PHPFileData pHPFileData) {
    }

    public void fileDataRemoved(PHPFileData pHPFileData) {
    }

    private class AnnotatedPosition
    extends Position {
        private ProjectionAnnotation annotation;

        public AnnotatedPosition(int n, int n2) {
            super(n, n2);
        }

        public AnnotatedPosition(int n, int n2, ProjectionAnnotation projectionAnnotation) {
            super(n, n2);
            this.annotation = projectionAnnotation;
        }

        public ProjectionAnnotation getAnnotation() {
            return this.annotation;
        }

        public void setAnnotation(ProjectionAnnotation projectionAnnotation) {
            this.annotation = projectionAnnotation;
        }

        public String toString() {
            return "[AnnotatedPosition (" + this.getOffset() + ", " + this.getLength() + ")]";
        }
    }

    private class CommentAnnotatedPosition
    extends AnnotatedPosition
    implements IProjectionPosition {
        public CommentAnnotatedPosition(int n, int n2) {
            super(n, n2);
        }

        public CommentAnnotatedPosition(int n, int n2, ProjectionAnnotation projectionAnnotation) {
            super(n, n2, projectionAnnotation);
        }

        public int computeCaptionOffset(IDocument iDocument) throws BadLocationException {
            return this.findFirstContent(iDocument, this.getOffset(), this.getLength());
        }

        public IRegion[] computeProjectionRegions(IDocument iDocument) throws BadLocationException {
            Region region;
            IRegion iRegion;
            int n;
            int n2 = this.findFirstContent(iDocument, this.getOffset(), this.getLength());
            int n3 = iDocument.getLineOfOffset(this.getOffset());
            int n4 = iDocument.getLineOfOffset(this.getOffset() + n2);
            int n5 = iDocument.getLineOfOffset(this.getOffset() + this.getLength());
            if (n3 < n4) {
                n = iDocument.getLineOffset(n3);
                iRegion = iDocument.getLineInformation(n4);
                int n6 = iRegion.getOffset();
                region = new Region(n, n6 - n);
            } else {
                region = null;
            }
            if (n4 < n5) {
                n = iDocument.getLineOffset(n4 + 1);
                iRegion = new Region(n, this.getOffset() + this.getLength() - n);
                if (region == null) {
                    return new IRegion[]{iRegion};
                }
                return new IRegion[]{region, iRegion};
            }
            if (region != null) {
                return new IRegion[]{region};
            }
            return null;
        }

        private int findFirstContent(IDocument iDocument, int n, int n2) throws BadLocationException {
            int n3 = 0;
            while (n3 < n2) {
                char c = iDocument.getChar(n + n3);
                if (Character.isUnicodeIdentifierPart(c)) {
                    return n3;
                }
                ++n3;
            }
            return 0;
        }
    }

    private class FoldingTimerTask
    extends TimerTask {
        private FoldingTimerTask() {
        }

        public void run() {
            DefaultPHPFoldingStructureProvider.this.updateFolds();
            DefaultPHPFoldingStructureProvider.this.timer.cancel();
        }
    }

    private class PHPModelStateListener
    implements IModelStateListener {
        private PHPModelStateListener() {
        }

        public void modelChanged(IStructuredModel iStructuredModel) {
            if (DefaultPHPFoldingStructureProvider.this.timer != null) {
                DefaultPHPFoldingStructureProvider.this.timer.cancel();
            }
            DefaultPHPFoldingStructureProvider.this.timer = new Timer(false);
            DefaultPHPFoldingStructureProvider.this.timer.schedule((TimerTask)new FoldingTimerTask(), 1000L);
        }

        public void modelAboutToBeChanged(IStructuredModel iStructuredModel) {
        }

        public void modelDirtyStateChanged(IStructuredModel iStructuredModel, boolean bl) {
        }

        public void modelResourceDeleted(IStructuredModel iStructuredModel) {
        }

        public void modelResourceMoved(IStructuredModel iStructuredModel, IStructuredModel iStructuredModel2) {
        }

        public void modelAboutToBeReinitialized(IStructuredModel iStructuredModel) {
        }

        public void modelReinitialized(IStructuredModel iStructuredModel) {
        }
    }

    private static final class PHPProjectionAnnotation
    extends ProjectionAnnotation {
        private Object phpElement;
        private boolean isComment;

        public PHPProjectionAnnotation(Object object, boolean bl, boolean bl2) {
            super(bl);
            this.phpElement = object;
            this.isComment = bl2;
        }

        public Object getElement() {
            return this.phpElement;
        }

        public void setElement(PHPCodeData pHPCodeData) {
            this.phpElement = pHPCodeData;
        }

        public boolean isComment() {
            return this.isComment;
        }

        public void setIsComment(boolean bl) {
            this.isComment = bl;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof PHPProjectionAnnotation) {
                return this.phpElement.equals(((PHPProjectionAnnotation)((Object)object)).phpElement);
            }
            return false;
        }

        public String toString() {
            return "PHPProjectionAnnotation:\n\telement: \t" + this.phpElement.toString() + "\n" + "\tcollapsed: \t" + this.isCollapsed() + "\n" + "\tcomment: \t" + this.isComment + "\n";
        }
    }
}

