/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.folding.projection;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPhpScriptRegion;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.folding.projection.ElementProjectionAnnotation;
import org.eclipse.php.internal.ui.folding.projection.ProjectionAnnotationModelChanges;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProjectionViewerInformation {
    private static final Annotation[] EMPTY_ANNOTATIONS = new Annotation[0];
    private final ProjectionAnnotationModel fProjectionAnnotationModel;
    private final IDocument fDocument;
    private IDocumentListener fDocumentListener;
    private boolean fIsDocumentChanging = false;
    private List<ProjectionAnnotationModelChanges> fQueuedAnnotationChanges;

    public ProjectionViewerInformation(ProjectionViewer projectionViewer) {
        this.fDocument = projectionViewer.getDocument();
        this.fProjectionAnnotationModel = projectionViewer.getProjectionAnnotationModel();
    }

    IDocument getDocument() {
        return this.fDocument;
    }

    private List<ProjectionAnnotationModelChanges> getQueuedAnnotationChanges() {
        if (this.fQueuedAnnotationChanges == null) {
            this.fQueuedAnnotationChanges = new LinkedList<ProjectionAnnotationModelChanges>();
        }
        return this.fQueuedAnnotationChanges;
    }

    void setIsDocumentChanging(boolean bl) {
        this.fIsDocumentChanging = bl;
    }

    boolean isDocumentChanging() {
        return this.fIsDocumentChanging;
    }

    void applyAnnotationModelChanges() {
        List<ProjectionAnnotationModelChanges> list = this.getQueuedAnnotationChanges();
        block2: while (!list.isEmpty()) {
            ProjectionAnnotationModelChanges projectionAnnotationModelChanges = list.remove(0);
            try {
                Object object;
                Position position;
                Object object2;
                Object object3;
                Object object4;
                HashSet<Position> hashSet = new HashSet<Position>();
                HashMap<Position, Object> hashMap = new HashMap<Position, Object>();
                Position position2 = this.fProjectionAnnotationModel.getAnnotationIterator();
                while (position2.hasNext()) {
                    object4 = (ProjectionAnnotation)position2.next();
                    object3 = this.fProjectionAnnotationModel.getPosition((Annotation)object4);
                    if (object4.isCollapsed()) {
                        hashSet.add((Position)object3);
                    }
                    hashMap.put((Position)object3, object4);
                }
                position2 = projectionAnnotationModelChanges.getDeletions();
                if (position2 == null) {
                    position2 = EMPTY_ANNOTATIONS;
                }
                object4 = new HashSet(((Annotation[])position2).length);
                Object object5 = position2;
                int n = ((Annotation[])object5).length;
                int n2 = 0;
                while (n2 < n) {
                    object3 = object5[n2];
                    object2 = this.fProjectionAnnotationModel.getPosition((Annotation)object3);
                    if (hashSet.contains(object2)) {
                        object4.add(object2);
                    }
                    ++n2;
                }
                object3 = projectionAnnotationModelChanges.getAdditions();
                for (Map.Entry entry : object3.entrySet()) {
                    object5 = (Position)entry.getValue();
                    object2 = (ProjectionAnnotation)entry.getKey();
                    if (!object4.contains(object5)) {
                        position = this.fProjectionAnnotationModel.getPosition((Annotation)object2);
                        if (position != null) continue;
                        this.fProjectionAnnotationModel.addAnnotation((Annotation)object2, (Position)object5);
                        continue;
                    }
                    position = (ProjectionAnnotation)hashMap.get(object5);
                    if (position.isCollapsed()) continue;
                    object2.markExpanded();
                    object = new HashMap(1);
                    object.put(object2, object5);
                    this.fProjectionAnnotationModel.replaceAnnotations(new Annotation[]{position}, (Map)object);
                }
                Map map = projectionAnnotationModelChanges.getModifications();
                if (map == null) continue;
                for (Map.Entry entry : map.entrySet()) {
                    object2 = (ElementProjectionAnnotation)((Object)entry.getKey());
                    position = (Position)entry.getValue();
                    object = this.fProjectionAnnotationModel.getPosition((Annotation)object2);
                    if (object == null) {
                        object4.contains(position);
                        continue;
                    }
                    if (position.equals(object) || !object2.sameSize) continue;
                    this.fProjectionAnnotationModel.modifyAnnotationPosition((Annotation)object2, position);
                    continue block2;
                }
            }
            catch (RuntimeException runtimeException) {
                Logger.logException(runtimeException);
            }
        }
    }

    private boolean inScript(int n) {
        ITextRegion iTextRegion;
        String string;
        int n2;
        IPhpScriptRegion iPhpScriptRegion;
        block6: {
            IStructuredDocument iStructuredDocument = (IStructuredDocument)this.fDocument;
            IStructuredDocumentRegion iStructuredDocumentRegion = iStructuredDocument.getRegionAtCharacterOffset(n);
            ITextRegion iTextRegion2 = iStructuredDocumentRegion.getRegionAtCharacterOffset(n);
            if (iTextRegion2 == null) {
                return false;
            }
            IStructuredDocumentRegion iStructuredDocumentRegion2 = iStructuredDocumentRegion;
            if (iTextRegion2 instanceof ITextRegionContainer) {
                iStructuredDocumentRegion2 = (ITextRegionContainer)iTextRegion2;
                iTextRegion2 = iStructuredDocumentRegion2.getRegionAtCharacterOffset(n);
            }
            if (!(iTextRegion2 instanceof IPhpScriptRegion)) {
                return false;
            }
            iPhpScriptRegion = (IPhpScriptRegion)iTextRegion2;
            n2 = n - iStructuredDocumentRegion2.getStartOffset() - iPhpScriptRegion.getStart();
            try {
                string = iPhpScriptRegion.getPartition(n2);
                if (string != "org.eclipse.php.PHP_DEFAULT") break block6;
                return true;
            }
            catch (BadLocationException badLocationException) {
                Logger.logException(badLocationException);
                return false;
            }
        }
        return (string == "org.eclipse.php.PHP_DOC" || string == "org.eclipse.php.PHP_MULTI_LINE_COMMENT") && (iTextRegion = iPhpScriptRegion.getPhpToken(n2)).getStart() == n2;
    }

    boolean hasChangesQueued() {
        return !this.getQueuedAnnotationChanges().isEmpty();
    }

    public void queueAnnotationModelChanges(ProjectionAnnotationModelChanges projectionAnnotationModelChanges) {
        this.getQueuedAnnotationChanges().add(projectionAnnotationModelChanges);
        if (!this.isDocumentChanging()) {
            this.applyAnnotationModelChanges();
        }
    }

    public void initialize() {
        if (this.fDocumentListener == null) {
            this.fDocumentListener = new DocumentListener(this);
        }
        this.getDocument().addDocumentListener(this.fDocumentListener);
    }

    public void dispose() {
        if (this.fDocumentListener != null) {
            this.getDocument().removeDocumentListener(this.fDocumentListener);
        }
        if (this.fQueuedAnnotationChanges != null) {
            this.fQueuedAnnotationChanges.clear();
            this.fQueuedAnnotationChanges = null;
        }
    }

    private static class DocumentListener
    implements IDocumentListener {
        private final ProjectionViewerInformation fInfo;

        public DocumentListener(ProjectionViewerInformation projectionViewerInformation) {
            this.fInfo = projectionViewerInformation;
        }

        public void documentAboutToBeChanged(DocumentEvent documentEvent) {
            IDocument iDocument = documentEvent.getDocument();
            if (this.fInfo.getDocument() == iDocument) {
                this.fInfo.setIsDocumentChanging(true);
            }
        }

        public void documentChanged(DocumentEvent documentEvent) {
            IDocument iDocument = documentEvent.getDocument();
            if (iDocument instanceof IDocumentExtension && this.fInfo.getDocument() == iDocument) {
                ((IDocumentExtension)iDocument).registerPostNotificationReplace((IDocumentListener)this, (IDocumentExtension.IReplace)new PostDocumentChangedListener(this.fInfo));
            }
        }
    }

    private static class PostDocumentChangedListener
    implements IDocumentExtension.IReplace {
        private final ProjectionViewerInformation fInfo;

        public PostDocumentChangedListener(ProjectionViewerInformation projectionViewerInformation) {
            this.fInfo = projectionViewerInformation;
        }

        public void perform(IDocument iDocument, IDocumentListener iDocumentListener) {
            this.fInfo.applyAnnotationModelChanges();
            this.fInfo.setIsDocumentChanging(false);
        }
    }
}

