/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.jdt.dbunit.internal.export;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.sql.DataSource;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.IDatabaseConnection;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.datatools.connectivity.IConnection;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileConnectionManager;
import org.eclipse.datatools.connectivity.internal.ui.wizards.BaseWizard;
import org.eclipse.datatools.connectivity.internal.ui.wizards.ISummaryDataSource;
import org.eclipse.datatools.connectivity.internal.ui.wizards.SummaryWizardPage;
import org.eclipse.datatools.enablement.jdt.dbunit.Activator;
import org.eclipse.datatools.enablement.jdt.dbunit.internal.export.DBUnitDataExtractor;
import org.eclipse.datatools.enablement.jdt.dbunit.internal.export.ExportDBUDataSetObjectSelectionPage;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.jface.wizard.IWizardPage;

public class ExportDBUDataSetWizard
extends BaseWizard {
    private ExportDBUDataSetObjectSelectionPage page1 = null;
    protected SummaryWizardPage mSummaryPage;
    protected Object mIncomingObject;
    private IConnection mConnection = null;
    private DatabaseConnection mDBConnection = null;
    private boolean hadToOpen = false;

    public ExportDBUDataSetWizard(Object incoming) {
        this.mIncomingObject = incoming;
    }

    public Object getIncomingObject() {
        return this.mIncomingObject;
    }

    public void addPages() {
        this.page1 = new ExportDBUDataSetObjectSelectionPage("page1");
        this.addPage((IWizardPage)this.page1);
        this.mSummaryPage = new SummaryWizardPage((ISummaryDataSource)this);
        this.addPage((IWizardPage)this.mSummaryPage);
    }

    public boolean performFinish() {
        try {
            this.writeDataSet();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    protected IDatabaseConnection getConnection() throws Exception {
        IConnectionProfile icp = this.page1.getProfile();
        this.mConnection = ProfileConnectionManager.getProfileConnectionManagerInstance().getConnection(icp, Connection.class.getName());
        if (this.mConnection == null) {
            ProfileConnectionManager.getProfileConnectionManagerInstance().manageProfileConnection(icp, Connection.class.getName(), (Object)Activator.getDefault());
            icp.connect();
            this.mConnection = ProfileConnectionManager.getProfileConnectionManagerInstance().getConnection(icp, Connection.class.getName());
        }
        Connection jdbcConnection = (Connection)this.mConnection.getRawConnection();
        this.mDBConnection = new DatabaseConnection(jdbcConnection);
        return this.mDBConnection;
    }

    protected void writeDataSet() throws Exception {
        boolean hasSchema = false;
        boolean allInSameSchema = true;
        Schema inSchema = null;
        if (this.mIncomingObject instanceof Schema) {
            hasSchema = true;
            inSchema = (Schema)this.mIncomingObject;
        }
        Object[] selectedTables = this.page1.getSelectedObjects();
        ArrayList<String> stringTables = new ArrayList<String>();
        for (int i = 0; i < selectedTables.length; ++i) {
            Table table = (Table)selectedTables[i];
            if (allInSameSchema && !table.getSchema().equals(inSchema)) {
                allInSameSchema = false;
            }
            if (hasSchema) {
                stringTables.add(((Table)selectedTables[i]).getName());
                continue;
            }
            stringTables.add(ExportDBUDataSetObjectSelectionPage.getQualifiedTableName((Table)selectedTables[i], true, true));
        }
        DBUnitDataExtractor extractor = new DBUnitDataExtractor();
        extractor.setDataSource(new MyDataSource(this.page1.getProfile()));
        extractor.setDataSetName(this.page1.getFileName());
        HashMap<String, String[]> properties = new HashMap<String, String[]>();
        properties.put("http://www.dbunit.org/properties/tableType", new String[]{"SYSTEM TABLE", "TABLE", "VIEW"});
        extractor.setDbUnitProperties(properties);
        HashMap<String, String> features = new HashMap<String, String>();
        features.put("http://www.dbunit.org/features/datatypeWarning", "false");
        if (!hasSchema) {
            features.put("http://www.dbunit.org/features/qualifiedTableNames", "true");
        }
        extractor.setDbUnitFeatures(features);
        if (hasSchema && !allInSameSchema) {
            extractor.setSchema(((Schema)this.mIncomingObject).getName());
        }
        extractor.setTableList(stringTables);
        extractor.extract(this.hadToOpen);
        ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, null);
    }

    private class MyDataSource
    implements DataSource {
        private IConnectionProfile mProfile = null;
        private IConnection mConnection = null;
        private Connection mJDBCConnection = null;

        public MyDataSource() {
            this.mProfile = null;
        }

        public MyDataSource(IConnectionProfile icp) {
            this.mProfile = icp;
        }

        public void setConnectionProfile(IConnectionProfile icp) {
            this.mProfile = icp;
        }

        public Connection getConnection() throws SQLException {
            this.mConnection = ProfileConnectionManager.getProfileConnectionManagerInstance().getConnection(this.mProfile, (class$java$sql$Connection == null ? (class$java$sql$Connection = ExportDBUDataSetWizard.class$("java.sql.Connection")) : class$java$sql$Connection).getName());
            if (this.mConnection == null) {
                ExportDBUDataSetWizard.this.hadToOpen = true;
                ProfileConnectionManager.getProfileConnectionManagerInstance().manageProfileConnection(this.mProfile, (class$java$sql$Connection == null ? (class$java$sql$Connection = ExportDBUDataSetWizard.class$("java.sql.Connection")) : class$java$sql$Connection).getName(), (Object)Activator.getDefault());
                this.mProfile.connect();
                this.mConnection = ProfileConnectionManager.getProfileConnectionManagerInstance().getConnection(this.mProfile, (class$java$sql$Connection == null ? (class$java$sql$Connection = ExportDBUDataSetWizard.class$("java.sql.Connection")) : class$java$sql$Connection).getName());
            }
            this.mJDBCConnection = (Connection)this.mConnection.getRawConnection();
            return this.mJDBCConnection;
        }

        public Connection getConnection(String username, String password) throws SQLException {
            return this.getConnection();
        }

        public PrintWriter getLogWriter() throws SQLException {
            return null;
        }

        public int getLoginTimeout() throws SQLException {
            return 0;
        }

        public void setLogWriter(PrintWriter out) throws SQLException {
        }

        public void setLoginTimeout(int seconds) throws SQLException {
        }
    }
}

