/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.elementedit.jsp;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.sse.core.internal.util.URIResolver;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Element;

public class TaglibURIAction
extends Action {
    private String URI;
    private Element element;

    public TaglibURIAction() {
        this.setText(PDPlugin.getResourceString("ElementEdit.Submenu.Taglib"));
    }

    public boolean isEnabled() {
        return this.element != null && this.URI != null && !"".equals(this.URI);
    }

    public void run() {
        String fileName = this.getResolvedURL(this.getElement(), this.URI);
        if (fileName != null && fileName.length() > 0) {
            Path includedPath = new Path(fileName);
            includedPath.makeAbsolute();
            IFile file = this.getFile((IPath)includedPath);
            if (file != null && file.exists()) {
                try {
                    IDE.openEditor((IWorkbenchPage)this.getPage(), (IFile)file);
                    return;
                }
                catch (PartInitException e) {
                    PDPlugin.getAlerts().warning("Message.Warning.Title", e.getLocalizedMessage());
                }
            }
        }
        PDPlugin.getAlerts().warning("Message.Warning.Title", "Taglib.OpenFile.ERROR");
    }

    private IWorkbenchPage getPage() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        return window.getActivePage();
    }

    public void setURI(String uri) {
        this.URI = uri;
    }

    private IFile getFile(IPath includedPath) {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] projects = workspaceRoot.getProjects();
        int i = 0;
        int length = projects.length;
        while (i < length) {
            IPath path = projects[i].getLocation();
            if ((path = path.makeAbsolute()) != null && path.isPrefixOf(includedPath)) {
                includedPath = includedPath.removeFirstSegments(path.segmentCount() - 1);
                return ResourcesPlugin.getWorkspace().getRoot().getFile(includedPath);
            }
            ++i;
        }
        return null;
    }

    private String getResolvedURL(Element element, String attrName) {
        URIResolver resolver = null;
        if (element instanceof IDOMNode) {
            resolver = ((IDOMNode)element).getModel().getResolver();
        }
        if (resolver == null) {
            return null;
        }
        String src = this.URI;
        if (src != null && src.length() > 0) {
            return resolver.getLocationByURI(src);
        }
        return null;
    }

    public Element getElement() {
        return this.element;
    }

    public void setElement(Element element) {
        this.element = element;
    }
}

