/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.wizards;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.php.internal.debug.ui.wizards.IPHPExeCompositeFragment;
import org.eclipse.php.internal.ui.util.SWTUtil;
import org.eclipse.php.internal.ui.wizards.CompositeFragment;
import org.eclipse.php.internal.ui.wizards.IControlHandler;
import org.eclipse.php.internal.ui.wizards.WizardFragmentsFactoryRegistry;
import org.eclipse.php.ui.wizards.ICompositeFragmentFactory;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class PHPExeEditDialog
extends TitleAreaDialog
implements IControlHandler {
    protected static final String FRAGMENT_GROUP_ID = "org.eclipse.php.debug.ui.phpExeWizardCompositeFragment";
    private List<CompositeFragment> runtimeComposites;
    private PHPexeItem phpExeItem;
    private PHPexeItem[] existingItems;

    public PHPExeEditDialog(Shell shell, PHPexeItem pHPexeItem, PHPexeItem[] pHPexeItemArray) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.existingItems = pHPexeItemArray;
        this.phpExeItem = pHPexeItem;
        this.runtimeComposites = new ArrayList<CompositeFragment>(3);
    }

    public void setDescription(String string) {
        super.setMessage(string);
    }

    public PHPexeItem[] getExistingItems() {
        return this.existingItems;
    }

    public void setPHPExeItem(PHPexeItem pHPexeItem) {
        this.phpExeItem = pHPexeItem;
    }

    public PHPexeItem getPHPExeItem() {
        return this.phpExeItem;
    }

    public void setImageDescriptor(ImageDescriptor imageDescriptor) {
        super.setTitleImage(imageDescriptor.createImage());
    }

    protected Control createDialogArea(Composite composite) {
        ICompositeFragmentFactory[] iCompositeFragmentFactoryArray;
        CTabFolder cTabFolder = SWTUtil.createTabFolder((Composite)composite);
        ICompositeFragmentFactory[] iCompositeFragmentFactoryArray2 = iCompositeFragmentFactoryArray = WizardFragmentsFactoryRegistry.getFragmentsFactories((String)FRAGMENT_GROUP_ID);
        int n = iCompositeFragmentFactoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICompositeFragmentFactory iCompositeFragmentFactory = iCompositeFragmentFactoryArray2[n2];
            CTabItem cTabItem = new CTabItem(cTabFolder, 2048);
            CompositeFragment compositeFragment = iCompositeFragmentFactory.createComposite((Composite)cTabFolder, (IControlHandler)this);
            compositeFragment.setData((Object)this.phpExeItem);
            if (compositeFragment instanceof IPHPExeCompositeFragment) {
                ((IPHPExeCompositeFragment)compositeFragment).setExistingItems(this.existingItems);
            }
            cTabItem.setText(compositeFragment.getDisplayName());
            cTabItem.setControl((Control)compositeFragment);
            this.runtimeComposites.add(compositeFragment);
            ++n2;
        }
        this.getShell().setText("Edit PHP Executable");
        cTabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CTabItem cTabItem = (CTabItem)selectionEvent.item;
                CompositeFragment compositeFragment = (CompositeFragment)cTabItem.getControl();
                PHPExeEditDialog.this.setTitle(compositeFragment.getTitle());
                PHPExeEditDialog.this.setDescription(compositeFragment.getDescription());
            }
        });
        return cTabFolder;
    }

    protected void cancelPressed() {
        Iterator<CompositeFragment> iterator = this.runtimeComposites.iterator();
        while (iterator.hasNext()) {
            iterator.next().performCancel();
        }
        super.cancelPressed();
    }

    protected void okPressed() {
        Iterator<CompositeFragment> iterator = this.runtimeComposites.iterator();
        while (iterator.hasNext()) {
            iterator.next().performOk();
        }
        super.okPressed();
    }

    public void update() {
        Button button = this.getButton(0);
        if (button != null) {
            Iterator<CompositeFragment> iterator = this.runtimeComposites.iterator();
            while (iterator.hasNext()) {
                if (iterator.next().isComplete()) continue;
                button.setEnabled(false);
                return;
            }
            button.setEnabled(true);
        }
    }

    public void setMessage(String string, int n) {
        if (n == 2) {
            n = 1;
        }
        super.setMessage(string, n);
    }
}

