/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.debugger;

import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.php.debug.core.debugger.parameters.IDebugParametersInitializer;
import org.eclipse.php.internal.debug.core.Logger;
import org.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.zend.debugger.DebugParametersInitializersRegistry;
import org.eclipse.php.internal.debug.core.zend.debugger.IDebuggerInitializer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class PHPWebServerDebuggerInitializer
implements IDebuggerInitializer {
    private DebugException exception;
    private static boolean isDebugMode = System.getProperty("loggingDebug") != null;

    public void debug(ILaunch iLaunch) throws DebugException {
        String string;
        this.exception = null;
        IDebugParametersInitializer iDebugParametersInitializer = DebugParametersInitializersRegistry.getBestMatchDebugParametersInitializer(iLaunch);
        final String string2 = iDebugParametersInitializer.getRequestURL(iLaunch).replaceAll(" ", "%20");
        boolean bl = true;
        try {
            bl = iLaunch.getLaunchConfiguration().getAttribute("org.eclipse.php.debug.core.RunWithDebugInfo", true);
        }
        catch (CoreException coreException) {}
        if (!bl && "run".equals(iLaunch.getLaunchMode())) {
            string = string2;
        } else {
            String string3 = iDebugParametersInitializer.generateQuery(iLaunch);
            string = string2.indexOf(63) == -1 ? String.valueOf(string2) + '?' + string3 : String.valueOf(string2) + '&' + string3;
        }
        if (isDebugMode) {
            System.out.println("debugQuery = " + string);
        }
        boolean bl2 = false;
        try {
            bl2 = iLaunch.getLaunchConfiguration().getAttribute("org.eclipse.php.debug.core.OpenInBrowser", false);
        }
        catch (Throwable throwable) {
            Logger.logException("Error obtaining the 'openInBrowser' configuration.", throwable);
        }
        if (bl2) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    try {
                        int n = 14;
                        PlatformUI.getWorkbench().getBrowserSupport().createBrowser(n, null, string2, string).openURL(new URL(string));
                    }
                    catch (Throwable throwable) {
                        Logger.logException("Error initializing the web browser.", throwable);
                        String string3 = PHPDebugCoreMessages.Debugger_Unexpected_Error_1;
                        PHPWebServerDebuggerInitializer.this.exception = new DebugException((IStatus)new Status(4, PHPDebugPlugin.getID(), 150, string3, throwable));
                    }
                }
            });
            if (this.exception != null) {
                throw this.exception;
            }
        } else {
            try {
                PHPWebServerDebuggerInitializer.connect(new URL(string));
            }
            catch (MalformedURLException malformedURLException) {
                Logger.logException("Malformed URL Exception " + string, malformedURLException);
                String string4 = PHPDebugCoreMessages.Debugger_Unexpected_Error_1;
                throw new DebugException((IStatus)new Status(4, PHPDebugPlugin.getID(), 150, string4, (Throwable)malformedURLException));
            }
        }
    }

    public static void connect(URL uRL) throws DebugException {
        try {
            URLConnection uRLConnection = uRL.openConnection();
            String string = uRLConnection.getHeaderFieldKey(1);
            if (string == null) {
                Logger.log(2, "No HeaderKey returned by server. Most likely not started");
                String string2 = PHPDebugCoreMessages.DebuggerConnection_Problem_1;
                throw new DebugException((IStatus)new Status(4, PHPDebugPlugin.getID(), 150, string2, null));
            }
            int n = 1;
            while ((string = uRLConnection.getHeaderFieldKey(n)) != null) {
                if (string.equals("X-Zend-Debug-Server")) {
                    String string3 = uRLConnection.getHeaderField(string);
                    if (string3.equals("OK")) break;
                    Logger.log(2, "Unexpected Header Value returned by Server. " + string3);
                    String string4 = String.valueOf(PHPDebugCoreMessages.DebuggerConnection_Problem_2) + " - " + string3;
                    throw new DebugException((IStatus)new Status(4, PHPDebugPlugin.getID(), 150, string4, null));
                }
                ++n;
            }
            InputStream inputStream = uRLConnection.getInputStream();
            while (inputStream.read() != -1) {
            }
        }
        catch (UnknownHostException unknownHostException) {
            Logger.log(2, "Unknown Host Exception.");
            String string = PHPDebugCoreMessages.DebuggerConnection_Problem_3;
            throw new DebugException((IStatus)new Status(4, PHPDebugPlugin.getID(), 150, string, (Throwable)unknownHostException));
        }
        catch (ConnectException connectException) {
            Logger.logException("Unable to connect to URL " + uRL, connectException);
            String string = MessageFormat.format(PHPDebugCoreMessages.DebuggerConnection_Failed_1, uRL.toString());
            throw new DebugException((IStatus)new Status(4, PHPDebugPlugin.getID(), 200, string, null));
        }
        catch (IOException iOException) {
            String string;
            Logger.logException("Unable to connect to URL " + uRL, iOException);
            String string5 = uRL.toString();
            int n = string5.indexOf(63);
            if (n > -1) {
                string5 = string5.substring(0, n);
            }
            if ((string = uRL.getPath()).startsWith("/")) {
                string = string.substring(1);
            }
            String string6 = MessageFormat.format(PHPDebugCoreMessages.DebuggerConnection_Failed_1, string5, string);
            throw new DebugException((IStatus)new Status(4, PHPDebugPlugin.getID(), 200, string6, null));
        }
        catch (Exception exception) {
            Logger.logException("Unexpected exception communicating with server", exception);
            String string = exception.getMessage();
            throw new DebugException((IStatus)new Status(4, PHPDebugPlugin.getID(), 150, string, (Throwable)exception));
        }
    }
}

