/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.phpModel.parser;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.php.internal.core.phpModel.parser.PHPCodeContext;
import org.eclipse.php.internal.core.phpModel.parser.PHPCodeDataFactory;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPVariableData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPVariableTypeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPVariablesTypeManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableContextBuilder {
    private Map<PHPCodeContext, List<PHPVariableData>> contextsToVariables = new HashMap<PHPCodeContext, List<PHPVariableData>>();
    private Map<String, List<PHPVariableTypeData>> variablesInstansiation = new HashMap<String, List<PHPVariableTypeData>>();

    public PHPVariableData addVariable(PHPCodeContext pHPCodeContext, String string) {
        PHPVariableData pHPVariableData = this.getVariable(pHPCodeContext, string = VariableContextBuilder.removeDollar(string));
        if (pHPVariableData != null) {
            return pHPVariableData;
        }
        List<PHPVariableData> list = this.contextsToVariables.get(pHPCodeContext);
        if (list == null) {
            list = new LinkedList<PHPVariableData>();
            this.contextsToVariables.put(pHPCodeContext, list);
        }
        pHPVariableData = PHPCodeDataFactory.createPHPVariableData(string, null, null);
        list.add(pHPVariableData);
        return pHPVariableData;
    }

    public void addVariable(PHPCodeContext pHPCodeContext, PHPVariableData pHPVariableData) {
        if (this.getVariable(pHPCodeContext, pHPVariableData.getName()) != null) {
            return;
        }
        List<PHPVariableData> list = this.contextsToVariables.get(pHPCodeContext);
        if (list == null) {
            list = new LinkedList<PHPVariableData>();
            this.contextsToVariables.put(pHPCodeContext, list);
        }
        list.add(pHPVariableData);
    }

    public void addObjectInstantiation(PHPCodeContext pHPCodeContext, String string, String string2, boolean bl, int n, int n2) {
        String string3 = VariableContextBuilder.createVariableContext(string = VariableContextBuilder.removeDollar(string), pHPCodeContext);
        List<PHPVariableTypeData> list = this.variablesInstansiation.get(string3);
        if (list == null) {
            list = new LinkedList<PHPVariableTypeData>();
            this.variablesInstansiation.put(string3, list);
        }
        list.add(new VariableTypeDataImp(string2, n, n2, bl));
    }

    public PHPVariablesTypeManager getPHPVariablesTypeManager() {
        HashMap<PHPCodeContext, Object[]> hashMap = new HashMap<PHPCodeContext, Object[]>(this.contextsToVariables.size());
        for (Map.Entry<PHPCodeContext, List<PHPVariableData>> entry : this.contextsToVariables.entrySet()) {
            PHPCodeContext pHPCodeContext = entry.getKey();
            List<PHPVariableData> list = entry.getValue();
            Object[] objectArray = list.toArray(new PHPVariableData[list.size()]);
            Arrays.sort(objectArray);
            hashMap.put(pHPCodeContext, objectArray);
        }
        return new PHPVariablesTypeManagerImp(hashMap, this.variablesInstansiation);
    }

    private PHPVariableData getVariable(PHPCodeContext pHPCodeContext, String string) {
        string = VariableContextBuilder.removeDollar(string);
        List<PHPVariableData> list = this.contextsToVariables.get(pHPCodeContext);
        if (list == null) {
            return null;
        }
        for (PHPVariableData pHPVariableData : list) {
            if (!pHPVariableData.getName().equals(string)) continue;
            return pHPVariableData;
        }
        return null;
    }

    public static String createVariableContext(String string, PHPCodeContext pHPCodeContext) {
        StringBuilder stringBuilder = new StringBuilder(16);
        stringBuilder.append(string);
        stringBuilder.append(';');
        stringBuilder.append(pHPCodeContext.getContainerClassName());
        stringBuilder.append(';');
        stringBuilder.append(pHPCodeContext.getContainerFunctionName());
        return stringBuilder.toString();
    }

    private static String removeDollar(String string) {
        if (string.length() > 0 && string.charAt(0) == '$') {
            string = string.substring(1);
        }
        return string;
    }

    public static VariableTypeDataImp createVariableTypeData(String string, int n, int n2, boolean bl) {
        return new VariableTypeDataImp(string, n, n2, bl);
    }

    public static PHPVariablesTypeManagerImp createPHPVariablesTypeManager(Map<PHPCodeContext, PHPVariableData[]> map, Map<String, List<PHPVariableTypeData>> map2) {
        return new PHPVariablesTypeManagerImp(map, map2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PHPVariablesTypeManagerImp
    implements PHPVariablesTypeManager,
    Serializable {
        private Map<PHPCodeContext, PHPVariableData[]> contextsToVariables;
        private Map<String, List<PHPVariableTypeData>> variablesInstansiation;

        private PHPVariablesTypeManagerImp(Map<PHPCodeContext, PHPVariableData[]> map, Map<String, List<PHPVariableTypeData>> map2) {
            this.contextsToVariables = map;
            this.variablesInstansiation = map2;
        }

        @Override
        public PHPVariableData[] getVariables(PHPCodeContext pHPCodeContext) {
            return this.contextsToVariables.get(pHPCodeContext);
        }

        @Override
        public PHPVariableData getVariable(PHPCodeContext pHPCodeContext, String string) {
            string = VariableContextBuilder.removeDollar(string);
            PHPVariableData[] pHPVariableDataArray = this.contextsToVariables.get(pHPCodeContext);
            if (pHPVariableDataArray == null) {
                return null;
            }
            PHPVariableData[] pHPVariableDataArray2 = pHPVariableDataArray;
            int n = pHPVariableDataArray.length;
            int n2 = 0;
            while (n2 < n) {
                PHPVariableData pHPVariableData = pHPVariableDataArray2[n2];
                if (pHPVariableData.getName().equalsIgnoreCase(string)) {
                    return pHPVariableData;
                }
                ++n2;
            }
            return null;
        }

        @Override
        public Map<PHPCodeContext, PHPVariableData[]> getContextsToVariables() {
            return this.contextsToVariables;
        }

        @Override
        public Map<String, List<PHPVariableTypeData>> getVariablesInstansiation() {
            return this.variablesInstansiation;
        }

        @Override
        public PHPVariableTypeData getVariableTypeData(PHPCodeContext pHPCodeContext, String string, int n) {
            String string2 = VariableContextBuilder.createVariableContext(string = VariableContextBuilder.removeDollar(string), pHPCodeContext);
            List<PHPVariableTypeData> list = this.variablesInstansiation.get(string2);
            if (list == null) {
                return null;
            }
            PHPVariableTypeData pHPVariableTypeData = null;
            for (PHPVariableTypeData pHPVariableTypeData2 : list) {
                if (pHPVariableTypeData2.getLine() > n) continue;
                if (pHPVariableTypeData == null) {
                    if (pHPVariableTypeData2.getType() != null) {
                        return pHPVariableTypeData2;
                    }
                    pHPVariableTypeData = pHPVariableTypeData2;
                    continue;
                }
                if (pHPVariableTypeData2.getType() == null) continue;
                if (pHPVariableTypeData2.isUserDocumentation()) {
                    return pHPVariableTypeData2;
                }
                return pHPVariableTypeData;
            }
            return pHPVariableTypeData;
        }

        @Override
        public PHPVariableTypeData getVariableTypeDataByPosition(PHPCodeContext pHPCodeContext, String string, int n) {
            String string2 = VariableContextBuilder.createVariableContext(string = VariableContextBuilder.removeDollar(string), pHPCodeContext);
            List<PHPVariableTypeData> list = this.variablesInstansiation.get(string2);
            if (list == null) {
                return null;
            }
            PHPVariableTypeData pHPVariableTypeData = null;
            for (PHPVariableTypeData pHPVariableTypeData2 : list) {
                if (pHPVariableTypeData2.getPosition() > n) continue;
                if (pHPVariableTypeData == null) {
                    if (pHPVariableTypeData2.getType() != null) {
                        return pHPVariableTypeData2;
                    }
                    pHPVariableTypeData = pHPVariableTypeData2;
                    continue;
                }
                if (pHPVariableTypeData2.getType() == null) continue;
                if (pHPVariableTypeData2.isUserDocumentation()) {
                    return pHPVariableTypeData2;
                }
                return pHPVariableTypeData;
            }
            return pHPVariableTypeData;
        }
    }

    private static final class VariableTypeDataImp
    implements PHPVariableTypeData {
        private String type;
        private int line;
        private int position;
        private boolean isUserDocumentation;

        VariableTypeDataImp(String string, int n, int n2, boolean bl) {
            this.type = string;
            this.line = n;
            this.position = n2;
            this.isUserDocumentation = bl;
        }

        public String getType() {
            return this.type;
        }

        public int getLine() {
            return this.line;
        }

        public int getPosition() {
            return this.position;
        }

        public boolean isUserDocumentation() {
            return this.isUserDocumentation;
        }
    }
}

