/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.util;

import java.util.regex.Pattern;
import org.eclipse.core.runtime.IPath;

public class IncludeStringHack {
    private static final Pattern DOUBLE_DOT_WITH_SLASH = Pattern.compile("\\.{2}([\\/])");
    private static final String DOUBLE_PIPE_WITH_SLASH_REPLACEMENT = "||$1";
    private static final Pattern DOUBLE_DOT_AT_END = Pattern.compile("\\.{2}$");
    private static final String DOUBLE_PIPE_AT_END_REPLACEMENT = "||";
    private static final Pattern SINGLE_DOT_WITH_SLASH = Pattern.compile("\\.{1}([\\/])");
    private static final String SINGLE_PIPE_WITH_SLASH_REPLACEMENT = "|$1";
    private static final Pattern SINGLE_DOT_AT_END = Pattern.compile("\\.{1}$");
    private static final String SINGLE_PIPE_AT_END_REPLACEMENT = "|";
    private static final Pattern DOUBLE_PIPE_WITH_SLASH = Pattern.compile("\\|{2}([\\/])");
    private static final String DOUBLE_DOT_WITH_SLASH_REPLACEMENT = "..$1";
    private static final Pattern DOUBLE_PIPE_AT_END = Pattern.compile("\\|{2}$");
    private static final String DOUBLE_DOT_AT_END_REPLACEMENT = "..";
    private static final Pattern SINGLE_PIPE_WITH_SLASH = Pattern.compile("\\|{1}([\\/])");
    private static final String SINGLE_DOT_WITH_SLASH_REPLACEMENT = ".$1";
    private static final Pattern SINGLE_PIPE_AT_END = Pattern.compile("\\|{1}$");
    private static final String SINGLE_DOT_AT_END_REPLACEMENT = ".";

    public static String hack(String string) {
        string = DOUBLE_DOT_WITH_SLASH.matcher(string).replaceAll(DOUBLE_PIPE_WITH_SLASH_REPLACEMENT);
        string = DOUBLE_DOT_AT_END.matcher(string).replaceAll(DOUBLE_PIPE_AT_END_REPLACEMENT);
        string = SINGLE_DOT_WITH_SLASH.matcher(string).replaceAll(SINGLE_PIPE_WITH_SLASH_REPLACEMENT);
        string = SINGLE_DOT_AT_END.matcher(string).replaceAll(SINGLE_PIPE_AT_END_REPLACEMENT);
        return string;
    }

    public static String unhack(String string) {
        string = DOUBLE_PIPE_WITH_SLASH.matcher(string).replaceAll(DOUBLE_DOT_WITH_SLASH_REPLACEMENT);
        string = DOUBLE_PIPE_AT_END.matcher(string).replaceAll(DOUBLE_DOT_AT_END_REPLACEMENT);
        string = SINGLE_PIPE_WITH_SLASH.matcher(string).replaceAll(SINGLE_DOT_WITH_SLASH_REPLACEMENT);
        string = SINGLE_PIPE_AT_END.matcher(string).replaceAll(SINGLE_DOT_AT_END_REPLACEMENT);
        return string;
    }

    public static boolean isHacked(IPath iPath) {
        int n = 0;
        while (n < iPath.segmentCount()) {
            if (iPath.segment(n).equals(SINGLE_PIPE_AT_END_REPLACEMENT) || iPath.segment(n).equals(DOUBLE_PIPE_AT_END_REPLACEMENT)) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

