/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import java.util.LinkedList;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.actions.SelectionDispatchAction;
import org.eclipse.ui.IWorkbenchSite;

public class ConvertToPDTProjectAction
extends SelectionDispatchAction {
    private static final String PHPECLIPSE_NATURE = "net.sourceforge.phpeclipse.phpnature";
    private static final String PHPECLIPSE_BUILDER = "net.sourceforge.phpeclipse.parserbuilder";
    private IProject[] selectedProjects;

    public ConvertToPDTProjectAction(IWorkbenchSite iWorkbenchSite) {
        super(iWorkbenchSite);
        this.setText(PHPUIMessages.getString("ConvertToPDTProjectAction_convert_to_PDT_project_title"));
        this.setToolTipText(PHPUIMessages.getString("ConvertToPDTProjectAction_convert_to_PDT_project_tooltip"));
        this.setDescription(PHPUIMessages.getString("ConvertToPDTProjectAction_convert_to_PDT_project_description"));
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        this.selectedProjects = this.getProjectsFromSelection(iStructuredSelection);
        this.setEnabled(this.selectedProjects.length > 0);
    }

    private IProject[] getProjectsFromSelection(IStructuredSelection iStructuredSelection) {
        LinkedList<IProject> linkedList = new LinkedList<IProject>();
        for (Object e : iStructuredSelection) {
            if (!(e instanceof IProject)) continue;
            IProject iProject = (IProject)e;
            try {
                if (!iProject.isOpen() || !iProject.hasNature(PHPECLIPSE_NATURE)) continue;
                linkedList.add(iProject);
            }
            catch (CoreException coreException) {}
        }
        return linkedList.toArray(new IProject[linkedList.size()]);
    }

    public void run(IStructuredSelection iStructuredSelection) {
        final IProject[] iProjectArray = this.getProjectsFromSelection(iStructuredSelection);
        if (iProjectArray.length > 0) {
            WorkspaceJob workspaceJob = new WorkspaceJob(PHPUIMessages.getString("ConvertToPDTProjectAction_converting_project_job_title")){

                public IStatus runInWorkspace(IProgressMonitor iProgressMonitor) throws CoreException {
                    int n = 0;
                    while (n < iProjectArray.length) {
                        IProject iProject = iProjectArray[n];
                        IProjectDescription iProjectDescription = iProject.getDescription();
                        LinkedList<ICommand> linkedList = new LinkedList<ICommand>();
                        ICommand[] iCommandArray = iProjectDescription.getBuildSpec();
                        int n2 = 0;
                        while (n2 < iCommandArray.length) {
                            if (!iCommandArray[n2].getBuilderName().equals(ConvertToPDTProjectAction.PHPECLIPSE_BUILDER)) {
                                linkedList.add(iCommandArray[n2]);
                            }
                            ++n2;
                        }
                        ICommand iCommand = iProjectDescription.newCommand();
                        iCommand.setBuilderName("org.eclipse.php.core.ValidationManagerWrapper");
                        linkedList.add(iCommand);
                        iCommand = iProjectDescription.newCommand();
                        iCommand.setBuilderName("org.eclipse.php.core.PhpIncrementalProjectBuilder");
                        linkedList.add(iCommand);
                        iProjectDescription.setBuildSpec(linkedList.toArray(new ICommand[linkedList.size()]));
                        LinkedList<String> linkedList2 = new LinkedList<String>();
                        String[] stringArray = iProjectDescription.getNatureIds();
                        int n3 = 0;
                        while (n3 < stringArray.length) {
                            if (!stringArray[n3].equals(ConvertToPDTProjectAction.PHPECLIPSE_NATURE)) {
                                linkedList2.add(stringArray[n3]);
                            }
                            ++n3;
                        }
                        linkedList2.add("org.eclipse.php.core.PHPNature");
                        iProjectDescription.setNatureIds(linkedList2.toArray(new String[linkedList2.size()]));
                        iProject.setDescription(iProjectDescription, iProgressMonitor);
                        ++n;
                    }
                    return Status.OK_STATUS;
                }
            };
            workspaceJob.setUser(true);
            workspaceJob.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
            workspaceJob.schedule();
        }
    }
}

