/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.input;

import java.io.File;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.php.internal.core.resources.ExternalFilesRegistry;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.editors.text.ILocationProvider;

public class NonExistingPHPFileEditorInput
implements IEditorInput,
ILocationProvider {
    private static int fgNonExisting = 0;
    private IFileStore fFileStore;
    private String fName;

    public NonExistingPHPFileEditorInput(IFileStore iFileStore, String string) {
        Assert.isNotNull((Object)iFileStore);
        Assert.isTrue((boolean)"file".equals(iFileStore.getFileSystem().getScheme()));
        this.fFileStore = iFileStore;
        this.fName = String.valueOf(string) + ++fgNonExisting + ".php";
    }

    public NonExistingPHPFileEditorInput(IPath iPath) {
        Assert.isNotNull((Object)iPath);
        IFileStore iFileStore = null;
        String string = iPath.toString();
        if (string.endsWith(".php")) {
            iFileStore = EFS.getLocalFileSystem().getStore(iPath.removeLastSegments(1));
            this.fName = iPath.lastSegment();
        } else {
            iFileStore = EFS.getLocalFileSystem().getStore(iPath);
            this.fName = "PHPDocument" + ++fgNonExisting + ".php";
        }
        Assert.isTrue((boolean)"file".equals(iFileStore.getFileSystem().getScheme()));
        this.fFileStore = iFileStore;
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return this.fName;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return this.fName;
    }

    public Object getAdapter(Class clazz) {
        if (ILocationProvider.class == clazz) {
            return this;
        }
        if (IResource.class == clazz) {
            return ExternalFilesRegistry.getInstance().getFileEntry(this.getPath().toOSString());
        }
        return Platform.getAdapterManager().getAdapter((Object)this, clazz);
    }

    public IPath getPath() {
        return this.getPath(this);
    }

    public IPath getPath(Object object) {
        if (object instanceof NonExistingPHPFileEditorInput) {
            NonExistingPHPFileEditorInput nonExistingPHPFileEditorInput = (NonExistingPHPFileEditorInput)object;
            String string = nonExistingPHPFileEditorInput.fFileStore.toURI().getPath();
            if (string.endsWith(".php")) {
                return new Path(string);
            }
            return new Path(String.valueOf(string) + File.separatorChar + this.fName);
        }
        return null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof NonExistingPHPFileEditorInput) {
            NonExistingPHPFileEditorInput nonExistingPHPFileEditorInput = (NonExistingPHPFileEditorInput)object;
            return this.fFileStore.equals(nonExistingPHPFileEditorInput.fFileStore) && this.fName.equals(nonExistingPHPFileEditorInput.fName);
        }
        return false;
    }

    public int hashCode() {
        return this.fFileStore.hashCode();
    }
}

