/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.filters;

import java.text.Collator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.activities.WorkbenchActivityHelper;

public class FilterDescriptor
implements Comparable,
IPluginContribution {
    private static String PATTERN_FILTER_ID_PREFIX = "_patternFilterId_";
    private static final String EXTENSION_POINT_NAME = "phpElementFilters";
    private static final String FILTER_TAG = "filter";
    private static final String PATTERN_ATTRIBUTE = "pattern";
    private static final String ID_ATTRIBUTE = "id";
    private static final String VIEW_ID_ATTRIBUTE = "viewId";
    private static final String TARGET_ID_ATTRIBUTE = "targetId";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String ENABLED_ATTRIBUTE = "enabled";
    private static final String DESCRIPTION_ATTRIBUTE = "description";
    private static final String SELECTED_ATTRIBUTE = "selected";
    private static FilterDescriptor[] fgFilterDescriptors;
    private IConfigurationElement fElement;

    public static FilterDescriptor[] getFilterDescriptors() {
        if (fgFilterDescriptors == null) {
            IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
            IConfigurationElement[] iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor("org.eclipse.php.ui", EXTENSION_POINT_NAME);
            fgFilterDescriptors = FilterDescriptor.createFilterDescriptors(iConfigurationElementArray);
        }
        return fgFilterDescriptors;
    }

    public static FilterDescriptor[] getFilterDescriptors(String string) {
        FilterDescriptor[] filterDescriptorArray = FilterDescriptor.getFilterDescriptors();
        ArrayList<FilterDescriptor> arrayList = new ArrayList<FilterDescriptor>(filterDescriptorArray.length);
        int n = 0;
        while (n < filterDescriptorArray.length) {
            String string2 = filterDescriptorArray[n].getTargetId();
            if (!WorkbenchActivityHelper.filterItem((Object)filterDescriptorArray[n]) && (string2 == null || string2.equals(string))) {
                arrayList.add(filterDescriptorArray[n]);
            }
            ++n;
        }
        return arrayList.toArray(new FilterDescriptor[arrayList.size()]);
    }

    private FilterDescriptor(IConfigurationElement iConfigurationElement) {
        this.fElement = iConfigurationElement;
        Assert.isNotNull((Object)this.getId(), (String)"An extension for extension-point org.eclipse.php.ui.phpElementFilters does not provide a valid ID");
        Assert.isNotNull((Object)this.getName(), (String)"An extension for extension-point org.eclipse.php.ui.phpElementFilters does not provide a valid name");
    }

    public ViewerFilter createViewerFilter() {
        if (!this.isCustomFilter()) {
            return null;
        }
        final ViewerFilter[] viewerFilterArray = new ViewerFilter[1];
        String string = MessageFormat.format(PHPUIMessages.getString("FilterDescriptor_filterCreationError_message"), this.getId());
        SafeRunnable safeRunnable = new SafeRunnable(string){

            public void run() throws Exception {
                viewerFilterArray[0] = (ViewerFilter)FilterDescriptor.this.fElement.createExecutableExtension(FilterDescriptor.CLASS_ATTRIBUTE);
            }
        };
        Platform.run((ISafeRunnable)safeRunnable);
        return viewerFilterArray[0];
    }

    public String getId() {
        if (this.isPatternFilter()) {
            String string = this.getTargetId();
            if (string == null) {
                return String.valueOf(PATTERN_FILTER_ID_PREFIX) + this.getPattern();
            }
            return String.valueOf(string) + PATTERN_FILTER_ID_PREFIX + this.getPattern();
        }
        return this.fElement.getAttribute(ID_ATTRIBUTE);
    }

    public String getName() {
        String string = this.fElement.getAttribute(NAME_ATTRIBUTE);
        if (string == null && this.isPatternFilter()) {
            string = this.getPattern();
        }
        return string;
    }

    public String getPattern() {
        return this.fElement.getAttribute(PATTERN_ATTRIBUTE);
    }

    public String getTargetId() {
        String string = this.fElement.getAttribute(TARGET_ID_ATTRIBUTE);
        if (string != null) {
            return string;
        }
        return this.fElement.getAttribute(VIEW_ID_ATTRIBUTE);
    }

    public String getDescription() {
        String string = this.fElement.getAttribute(DESCRIPTION_ATTRIBUTE);
        if (string == null) {
            string = "";
        }
        return string;
    }

    public boolean isPatternFilter() {
        return this.getPattern() != null;
    }

    public boolean isCustomFilter() {
        return this.fElement.getAttribute(CLASS_ATTRIBUTE) != null;
    }

    public boolean isEnabled() {
        String string = this.fElement.getAttribute(ENABLED_ATTRIBUTE);
        if (string == null) {
            string = this.fElement.getAttribute(SELECTED_ATTRIBUTE);
        }
        return string == null || Boolean.valueOf(string) != false;
    }

    public int compareTo(Object object) {
        if (object instanceof FilterDescriptor) {
            return Collator.getInstance().compare(this.getName(), ((FilterDescriptor)object).getName());
        }
        return Integer.MIN_VALUE;
    }

    private static FilterDescriptor[] createFilterDescriptors(IConfigurationElement[] iConfigurationElementArray) {
        ArrayList<FilterDescriptor> arrayList = new ArrayList<FilterDescriptor>(5);
        HashSet<String> hashSet = new HashSet<String>(5);
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            final IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
            if (FILTER_TAG.equals(iConfigurationElement.getName())) {
                final FilterDescriptor[] filterDescriptorArray = new FilterDescriptor[1];
                Platform.run((ISafeRunnable)new SafeRunnable(PHPUIMessages.getString("FilterDescriptor_filterDescriptionCreationError_message")){

                    public void run() throws Exception {
                        filterDescriptorArray[0] = new FilterDescriptor(iConfigurationElement, null);
                    }
                });
                if (filterDescriptorArray[0] != null && !hashSet.contains(filterDescriptorArray[0].getId())) {
                    arrayList.add(filterDescriptorArray[0]);
                    hashSet.add(filterDescriptorArray[0].getId());
                }
            }
            ++n;
        }
        return arrayList.toArray(new FilterDescriptor[arrayList.size()]);
    }

    public String getLocalId() {
        return this.fElement.getAttribute(ID_ATTRIBUTE);
    }

    public String getPluginId() {
        return this.fElement.getNamespaceIdentifier();
    }

    /* synthetic */ FilterDescriptor(IConfigurationElement iConfigurationElement, FilterDescriptor filterDescriptor) {
        this(iConfigurationElement);
    }
}

