/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences.includepath;

import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.php.internal.core.project.options.PHPProjectOptions;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.preferences.includepath.VariableBlock;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class IncludePathVarsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "org.eclipse.php.ui.preferences.IncludePathVariables";
    private VariableBlock fVariableBlock;
    private String fStoredSettings;

    public IncludePathVarsPreferencePage() {
        this.setPreferenceStore(PHPUiPlugin.getDefault().getPreferenceStore());
        this.fVariableBlock = new VariableBlock(true, null);
        this.fStoredSettings = null;
        this.setTitle(PHPUIMessages.getString("IncludePathVariablesPreferencePage_title"));
        this.setDescription(PHPUIMessages.getString("IncludePathVariablesPreferencePage_description"));
        this.noDefaultAndApplyButton();
    }

    public void createControl(Composite composite) {
        super.createControl(composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.php.help.path_variables_preferences");
    }

    protected Control createContents(Composite composite) {
        Control control = this.fVariableBlock.createContents(composite);
        Dialog.applyDialogFont((Control)control);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.php.help.path_variables_preferences");
        return control;
    }

    public void init(IWorkbench iWorkbench) {
    }

    protected void performDefaults() {
        this.fVariableBlock.performDefaults();
        super.performDefaults();
    }

    public boolean performOk() {
        PHPUiPlugin.getDefault().savePluginPreferences();
        return this.fVariableBlock.performOk();
    }

    public void setVisible(boolean bl) {
        if (bl) {
            if (this.fStoredSettings != null && !this.fStoredSettings.equals(this.getCurrentSettings())) {
                this.fVariableBlock.refresh(null);
            }
        } else {
            if (this.fVariableBlock.hasChanges()) {
                String string = PHPUIMessages.getString("IncludePathVariablesPreferencePage_savechanges_title");
                String string2 = PHPUIMessages.getString("IncludePathVariablesPreferencePage_savechanges_message");
                if (MessageDialog.openQuestion((Shell)this.getShell(), (String)string, (String)string2)) {
                    this.performOk();
                }
                this.fVariableBlock.setChanges(false);
            }
            this.fStoredSettings = this.getCurrentSettings();
        }
        super.setVisible(bl);
    }

    private String getCurrentSettings() {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = PHPProjectOptions.getIncludePathVariableNames();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            stringBuffer.append(string).append('\u0000');
            IPath iPath = PHPProjectOptions.getIncludePathVariable((String)string);
            if (iPath != null) {
                stringBuffer.append(iPath.toString());
            }
            stringBuffer.append('\u0000');
            ++n;
        }
        return stringBuffer.toString();
    }
}

