/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.util;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.internal.ui.util.EditorUtility;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public class CodeInjector {
    private int offset = -1;
    private IStructuredDocument document = null;
    private IStructuredModel model = null;
    private PHPFileData existingPHPFile = null;

    public CodeInjector() {
    }

    public CodeInjector(PHPFileData pHPFileData, int n) {
        this.existingPHPFile = pHPFileData;
        this.offset = n;
    }

    public CodeInjector(PHPFileData pHPFileData) {
        this.existingPHPFile = pHPFileData;
    }

    private void init() {
        try {
            try {
                IEditorPart iEditorPart = EditorUtility.openInEditor(this.existingPHPFile, true);
                this.document = (IStructuredDocument)((PHPStructuredEditor)iEditorPart).getDocument();
                this.model = StructuredModelManager.getModelManager().getModelForEdit(this.document);
            }
            catch (PartInitException partInitException) {
                Logger.logException(partInitException);
                this.model.releaseFromEdit();
            }
        }
        finally {
            this.model.releaseFromEdit();
        }
    }

    public void setOffset(int n) {
        this.offset = n;
    }

    public void inject(String string, boolean bl, boolean bl2) {
        this.init();
        if (this.offset == -1) {
            this.offset = this.document.getLength();
        }
        this.document.replaceText((Object)this, this.offset, 0, string);
        if (bl) {
            this.formatDocument(this.document, this.offset, string.length() + 1);
        }
        if (bl2) {
            try {
                this.model.save();
            }
            catch (Exception exception) {
                Logger.logException(exception);
            }
        }
    }

    public void formatDocument(IStructuredDocument iStructuredDocument, int n, int n2) {
        IContentFormatter iContentFormatter = null;
        if (iContentFormatter == null) {
            iContentFormatter = PHPUiPlugin.getDefault().getActiveFormatter();
        }
        try {
            iContentFormatter.format((IDocument)iStructuredDocument, (IRegion)new Region(n, n2));
        }
        catch (Exception exception) {
            Logger.logException(exception);
        }
    }

    public int getOffset() {
        return this.offset;
    }
}

