/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import java.util.ArrayList;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;

public class ExternalBreakpointActionHelper {
    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean hasMarkers(IResource iResource, IDocument iDocument, AbstractMarkerAnnotationModel abstractMarkerAnnotationModel, IVerticalRulerInfo iVerticalRulerInfo) {
        if (iResource != null && abstractMarkerAnnotationModel != null) {
            try {
                if (iResource.exists()) {
                    IMarker[] iMarkerArray = iResource.findMarkers(IBreakpoint.LINE_BREAKPOINT_MARKER, true, 0);
                    if (iMarkerArray != null) {
                        int n = 0;
                        while (n < iMarkerArray.length) {
                            if (ExternalBreakpointActionHelper.includesRulerLine(abstractMarkerAnnotationModel.getMarkerPosition(iMarkerArray[n]), iDocument, iVerticalRulerInfo)) {
                                return true;
                            }
                            ++n;
                        }
                    }
                } else {
                    IMarker[] iMarkerArray = iResource.getWorkspace().getRoot().findMarkers(IBreakpoint.LINE_BREAKPOINT_MARKER, true, 0);
                    IBreakpointManager iBreakpointManager = DebugPlugin.getDefault().getBreakpointManager();
                    if (iMarkerArray != null) {
                        int n = 0;
                        while (n < iMarkerArray.length) {
                            if (iBreakpointManager.getBreakpoint(iMarkerArray[n]) != null && ExternalBreakpointActionHelper.includesRulerLine(abstractMarkerAnnotationModel.getMarkerPosition(iMarkerArray[n]), iDocument, iVerticalRulerInfo)) {
                                return true;
                            }
                            ++n;
                        }
                    }
                }
            }
            catch (CoreException coreException) {}
        }
        return false;
    }

    public static IMarker[] getMarkers(IResource iResource, IDocument iDocument, AbstractMarkerAnnotationModel abstractMarkerAnnotationModel, IVerticalRulerInfo iVerticalRulerInfo) {
        ArrayList<IMarker> arrayList = new ArrayList<IMarker>();
        if (iResource != null && abstractMarkerAnnotationModel != null) {
            try {
                if (iResource.exists()) {
                    IMarker[] iMarkerArray = iResource.findMarkers(IBreakpoint.BREAKPOINT_MARKER, true, 0);
                    if (iMarkerArray != null) {
                        int n = 0;
                        while (n < iMarkerArray.length) {
                            if (ExternalBreakpointActionHelper.includesRulerLine(abstractMarkerAnnotationModel.getMarkerPosition(iMarkerArray[n]), iDocument, iVerticalRulerInfo)) {
                                arrayList.add(iMarkerArray[n]);
                            }
                            ++n;
                        }
                    }
                } else {
                    IMarker[] iMarkerArray = iResource.getWorkspace().getRoot().findMarkers(IBreakpoint.BREAKPOINT_MARKER, true, 0);
                    if (iMarkerArray != null) {
                        IBreakpointManager iBreakpointManager = DebugPlugin.getDefault().getBreakpointManager();
                        int n = 0;
                        while (n < iMarkerArray.length) {
                            if (iBreakpointManager.getBreakpoint(iMarkerArray[n]) != null && ExternalBreakpointActionHelper.includesRulerLine(abstractMarkerAnnotationModel.getMarkerPosition(iMarkerArray[n]), iDocument, iVerticalRulerInfo)) {
                                arrayList.add(iMarkerArray[n]);
                            }
                            ++n;
                        }
                    }
                }
            }
            catch (CoreException coreException) {}
        }
        return arrayList.toArray(new IMarker[0]);
    }

    private static boolean includesRulerLine(Position position, IDocument iDocument, IVerticalRulerInfo iVerticalRulerInfo) {
        if (position != null && iVerticalRulerInfo != null) {
            try {
                int n = iDocument.getLineOfOffset(position.getOffset());
                int n2 = iVerticalRulerInfo.getLineOfLastMouseButtonActivity();
                if (n2 == n) {
                    return true;
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        return false;
    }
}

