/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.doubleclick;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultTextDoubleClickStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPhpScriptRegion;
import org.eclipse.php.internal.core.documentModel.partitioner.PHPPartitionTypes;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.swt.graphics.Point;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.w3c.dom.Node;

public class PHPDoubleClickStrategy
extends DefaultTextDoubleClickStrategy {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doubleClicked(ITextViewer iTextViewer) {
        block14: {
            if (iTextViewer instanceof StructuredTextViewer) {
                IStructuredModel iStructuredModel;
                block12: {
                    block13: {
                        StructuredTextViewer structuredTextViewer = (StructuredTextViewer)iTextViewer;
                        iStructuredModel = null;
                        try {
                            IStructuredDocumentRegion iStructuredDocumentRegion;
                            Node node;
                            int n;
                            iStructuredModel = StructuredModelManager.getModelManager().getExistingModelForRead(structuredTextViewer.getDocument());
                            if (iStructuredModel == null || (n = iTextViewer.getSelectedRange().x) <= 0 || (node = (Node)iStructuredModel.getIndexedRegion(n)) == null || (iStructuredDocumentRegion = iStructuredModel.getStructuredDocument().getRegionAtCharacterOffset(n)) == null) break block12;
                            ITextRegion iTextRegion = iStructuredDocumentRegion.getRegionAtCharacterOffset(n);
                            IStructuredDocumentRegion iStructuredDocumentRegion2 = iStructuredDocumentRegion;
                            if (iTextRegion instanceof ITextRegionContainer) {
                                iStructuredDocumentRegion2 = (ITextRegionContainer)iTextRegion;
                                iTextRegion = iStructuredDocumentRegion2.getRegionAtCharacterOffset(n);
                            }
                            if (iTextRegion == null || iTextRegion.getType() != "PHP_CONTENT") break block12;
                            IPhpScriptRegion iPhpScriptRegion = (IPhpScriptRegion)iTextRegion;
                            if ((iTextRegion = iPhpScriptRegion.getPhpToken(n - iStructuredDocumentRegion2.getStartOffset() - iPhpScriptRegion.getStart())).getType() == "PHP_VARIABLE" || PHPPartitionTypes.isPHPDocTagState((String)iTextRegion.getType())) {
                                structuredTextViewer.setSelectedRange(iStructuredDocumentRegion2.getStartOffset() + iPhpScriptRegion.getStart() + iTextRegion.getStart(), iTextRegion.getTextLength());
                            } else {
                                if (iTextRegion.getType() != "PHPDOC_COMMENT" && iTextRegion.getType() != "PHP_LINE_COMMENT" && iTextRegion.getType() != "PHP_COMMENT") break block12;
                                this.resetVariableSelectionRangeInComments(iTextViewer, structuredTextViewer);
                            }
                            if (iStructuredModel == null) break block13;
                        }
                        catch (BadLocationException badLocationException) {
                            PHPUiPlugin.log(badLocationException);
                            if (iStructuredModel != null) {
                                iStructuredModel.releaseFromRead();
                            }
                            break block14;
                        }
                        catch (Throwable throwable) {
                            if (iStructuredModel != null) {
                                iStructuredModel.releaseFromRead();
                            }
                            throw throwable;
                        }
                        iStructuredModel.releaseFromRead();
                    }
                    return;
                }
                if (iStructuredModel != null) {
                    iStructuredModel.releaseFromRead();
                }
            }
        }
        super.doubleClicked(iTextViewer);
    }

    private void resetVariableSelectionRangeInComments(ITextViewer iTextViewer, StructuredTextViewer structuredTextViewer) throws BadLocationException {
        super.doubleClicked(iTextViewer);
        Point point = structuredTextViewer.getSelectedRange();
        int n = point.x;
        if (n > 0) {
            IDocument iDocument = structuredTextViewer.getDocument();
            char c = iDocument.getChar(n - 1);
            if (c == '$') {
                structuredTextViewer.setSelectedRange(n - 1, point.y + 1);
            } else if (point.y == 1 && iDocument.getChar(n) == '$') {
                structuredTextViewer.setSelectedRange(n, point.y + 1);
            }
        }
    }
}

