/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.configuration;

import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.formatter.MultiPassContentFormatter;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.php.internal.core.documentModel.partitioner.PHPStructuredTextPartitioner;
import org.eclipse.php.internal.core.format.FormatPreferencesSupport;
import org.eclipse.php.internal.core.format.PhpFormatProcessorImpl;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.autoEdit.CloseTagAutoEditStrategyPHP;
import org.eclipse.php.internal.ui.autoEdit.MainAutoEditStrategy;
import org.eclipse.php.internal.ui.doubleclick.PHPDoubleClickStrategy;
import org.eclipse.php.internal.ui.editor.PHPCodeHyperlinkDetector;
import org.eclipse.php.internal.ui.editor.PHPStructuredTextViewer;
import org.eclipse.php.internal.ui.editor.contentassist.PHPContentAssistProcessor;
import org.eclipse.php.internal.ui.editor.contentassist.PHPDocContentAssistProcessor;
import org.eclipse.php.internal.ui.editor.highlighter.LineStyleProviderForPhp;
import org.eclipse.php.internal.ui.editor.hover.PHPTextHoverProxy;
import org.eclipse.php.internal.ui.preferences.PreferenceConstants;
import org.eclipse.php.internal.ui.text.PHPElementProvider;
import org.eclipse.php.internal.ui.text.PHPOutlineInformationControl;
import org.eclipse.php.internal.ui.text.hover.PHPEditorTextHoverDescriptor;
import org.eclipse.php.internal.ui.util.ElementCreationProxy;
import org.eclipse.php.ui.editor.hover.IHyperlinkDetectorForPHP;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.html.core.internal.text.StructuredTextPartitionerForHTML;
import org.eclipse.wst.html.ui.StructuredTextViewerConfigurationHTML;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatProcessor;
import org.eclipse.wst.sse.ui.internal.contentassist.StructuredContentAssistant;
import org.eclipse.wst.sse.ui.internal.format.StructuredFormattingStrategy;
import org.eclipse.wst.sse.ui.internal.provisional.style.LineStyleProvider;
import org.eclipse.wst.xml.core.internal.text.rules.StructuredTextPartitionerForXML;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PHPStructuredTextViewerConfiguration
extends StructuredTextViewerConfigurationHTML {
    private static final String PHP_CONTENT_ASSISTANT_EXT = "org.eclipse.php.ui.phpContentAssistant";
    private static final String CONTENT_ASSIST_PROCESSOR_EXT = "org.eclipse.php.ui.phpContentAssistProcessor";
    private static final String HYPERLINK_DETECTOR_EXT = "org.eclipse.php.ui.phpHyperlinkDetector";
    private static final String FORMATTER_PROCESSOR_EXT = "org.eclipse.php.ui.phpFormatterProcessor";
    private static final String SHOW_OUTLINE_PREF_KEY = "org.eclipse.php.ui.edit.text.php.show.outline";
    private static final String EMPTY = "";
    private static final String[] DEFAULT_PREFIXES = new String[]{"//", "#", ""};
    private static final IAutoEditStrategy mainAutoEditStrategy = new MainAutoEditStrategy();
    private static final IAutoEditStrategy closeTagAutoEditStrategy = new CloseTagAutoEditStrategyPHP();
    private static final IAutoEditStrategy[] phpStrategies = new IAutoEditStrategy[]{mainAutoEditStrategy};
    private String[] configuredContentTypes;
    private LineStyleProvider fLineStyleProvider;
    private final List<IHyperlinkDetectorForPHP> detectors = new LinkedList<IHyperlinkDetectorForPHP>();
    private List<IContentAssistProcessor> processors = null;
    private StructuredContentAssistant fContentAssistant = null;

    public PHPStructuredTextViewerConfiguration() {
        this.detectors.add(new PHPCodeHyperlinkDetector());
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(HYPERLINK_DETECTOR_EXT);
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            ElementCreationProxy elementCreationProxy;
            IHyperlinkDetectorForPHP iHyperlinkDetectorForPHP;
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
            if (iConfigurationElement.getName().equals("detector") && (iHyperlinkDetectorForPHP = (IHyperlinkDetectorForPHP)(elementCreationProxy = new ElementCreationProxy(iConfigurationElement, HYPERLINK_DETECTOR_EXT)).getObject()) != null) {
                this.detectors.add(iHyperlinkDetectorForPHP);
            }
            ++n;
        }
    }

    public String[] getConfiguredContentTypes(ISourceViewer iSourceViewer) {
        if (this.configuredContentTypes == null) {
            String[] stringArray = PHPStructuredTextPartitioner.getConfiguredContentTypes();
            String[] stringArray2 = StructuredTextPartitionerForXML.getConfiguredContentTypes();
            String[] stringArray3 = StructuredTextPartitionerForHTML.getConfiguredContentTypes();
            this.configuredContentTypes = new String[2 + stringArray.length + stringArray2.length + stringArray3.length];
            this.configuredContentTypes[0] = "org.eclipse.wst.sse.ST_DEFAULT";
            this.configuredContentTypes[1] = "org.eclipse.wst.sse.UNKNOWN_PARTITION_TYPE";
            int n = 0;
            System.arraycopy(stringArray, 0, this.configuredContentTypes, n += 2, stringArray.length);
            System.arraycopy(stringArray2, 0, this.configuredContentTypes, n += stringArray.length, stringArray2.length);
            System.arraycopy(stringArray3, 0, this.configuredContentTypes, n += stringArray2.length, stringArray3.length);
        }
        return this.configuredContentTypes;
    }

    public LineStyleProvider getLineStyleProvider() {
        if (this.fLineStyleProvider == null) {
            this.fLineStyleProvider = new LineStyleProviderForPhp();
        }
        return this.fLineStyleProvider;
    }

    public LineStyleProvider[] getLineStyleProviders(ISourceViewer iSourceViewer, String string) {
        if (string == "org.eclipse.php.PHP_DEFAULT") {
            return new LineStyleProvider[]{this.getLineStyleProvider()};
        }
        return super.getLineStyleProviders(iSourceViewer, string);
    }

    public IContentAssistProcessor[] getContentAssistProcessors(ISourceViewer iSourceViewer, String string) {
        IContentAssistProcessor[] iContentAssistProcessorArray = null;
        if (string == "org.eclipse.php.PHP_DEFAULT") {
            List<IContentAssistProcessor> list = this.getPHPDefaultProcessors();
            iContentAssistProcessorArray = list.toArray(new IContentAssistProcessor[list.size()]);
        } else {
            iContentAssistProcessorArray = super.getContentAssistProcessors(iSourceViewer, string);
        }
        return iContentAssistProcessorArray;
    }

    private List<IContentAssistProcessor> getPHPDefaultProcessors() {
        if (this.processors != null) {
            return this.processors;
        }
        this.processors = new LinkedList<IContentAssistProcessor>();
        this.processors.add(new PHPContentAssistProcessor());
        this.processors.add(new PHPDocContentAssistProcessor());
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(CONTENT_ASSIST_PROCESSOR_EXT);
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            ElementCreationProxy elementCreationProxy;
            IContentAssistProcessor iContentAssistProcessor;
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
            if (iConfigurationElement.getName().equals("processor") && (iContentAssistProcessor = (IContentAssistProcessor)(elementCreationProxy = new ElementCreationProxy(iConfigurationElement, CONTENT_ASSIST_PROCESSOR_EXT)).getObject()) != null) {
                this.processors.add(iContentAssistProcessor);
            }
            ++n;
        }
        return this.processors;
    }

    public IContentAssistant getPHPContentAssistant(ISourceViewer iSourceViewer) {
        return this.getPHPContentAssistant(iSourceViewer, false);
    }

    public IContentAssistant getPHPContentAssistant(ISourceViewer iSourceViewer, boolean bl) {
        if (this.fContentAssistant == null || bl) {
            this.fContentAssistant = this.getPHPContentAssistantExtension();
            if (this.fContentAssistant == null) {
                this.fContentAssistant = new StructuredContentAssistant();
            }
            IPreferenceStore iPreferenceStore = PreferenceConstants.getPreferenceStore();
            this.fContentAssistant.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(iSourceViewer));
            this.fContentAssistant.enableAutoActivation(iPreferenceStore.getBoolean("contentAssistAutoactivation"));
            this.fContentAssistant.setAutoActivationDelay(iPreferenceStore.getInt("contentAssistAutoactivationDelay"));
            this.fContentAssistant.enableAutoInsert(iPreferenceStore.getBoolean("contentAssistAutoinsert"));
            this.fContentAssistant.setProposalPopupOrientation(10);
            this.fContentAssistant.setContextInformationPopupOrientation(20);
            this.fContentAssistant.setInformationControlCreator(this.getInformationControlCreator(iSourceViewer));
            String[] stringArray = this.getConfiguredContentTypes(iSourceViewer);
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n];
                IContentAssistProcessor[] iContentAssistProcessorArray = this.getContentAssistProcessors(iSourceViewer, string);
                if (iContentAssistProcessorArray != null) {
                    int n2 = 0;
                    while (n2 < iContentAssistProcessorArray.length) {
                        this.fContentAssistant.setContentAssistProcessor(iContentAssistProcessorArray[n2], string);
                        ++n2;
                    }
                }
                ++n;
            }
        }
        return this.fContentAssistant;
    }

    private StructuredContentAssistant getPHPContentAssistantExtension() {
        StructuredContentAssistant structuredContentAssistant = null;
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(PHP_CONTENT_ASSISTANT_EXT);
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            ElementCreationProxy elementCreationProxy;
            StructuredContentAssistant structuredContentAssistant2;
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
            if (iConfigurationElement.getName().equals("contentAssistant") && (structuredContentAssistant2 = (StructuredContentAssistant)(elementCreationProxy = new ElementCreationProxy(iConfigurationElement, PHP_CONTENT_ASSISTANT_EXT)).getObject()) != null) {
                structuredContentAssistant = structuredContentAssistant2;
            }
            ++n;
        }
        return structuredContentAssistant;
    }

    public String[] getDefaultPrefixes(ISourceViewer iSourceViewer, String string) {
        return DEFAULT_PREFIXES;
    }

    public int[] getConfiguredTextHoverStateMasks(ISourceViewer iSourceViewer, String string) {
        PHPEditorTextHoverDescriptor[] pHPEditorTextHoverDescriptorArray = PHPUiPlugin.getDefault().getPHPEditorTextHoverDescriptors();
        int[] nArray = new int[pHPEditorTextHoverDescriptorArray.length];
        int n = 0;
        int n2 = 0;
        while (n2 < pHPEditorTextHoverDescriptorArray.length) {
            if (pHPEditorTextHoverDescriptorArray[n2].isEnabled()) {
                int n3 = 0;
                int n4 = pHPEditorTextHoverDescriptorArray[n2].getStateMask();
                while (n3 < n) {
                    if (nArray[n3] == n4) break;
                    ++n3;
                }
                if (n3 == n) {
                    nArray[n++] = n4;
                }
            }
            ++n2;
        }
        if (n == pHPEditorTextHoverDescriptorArray.length) {
            return nArray;
        }
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, n);
        return nArray2;
    }

    public ITextHover getTextHover(ISourceViewer iSourceViewer, String string, int n) {
        if (!PHPStructuredTextPartitioner.isPHPPartitionType((String)string)) {
            return super.getTextHover(iSourceViewer, string, n);
        }
        PHPEditorTextHoverDescriptor[] pHPEditorTextHoverDescriptorArray = PHPUiPlugin.getDefault().getPHPEditorTextHoverDescriptors();
        int n2 = 0;
        while (n2 < pHPEditorTextHoverDescriptorArray.length) {
            if (pHPEditorTextHoverDescriptorArray[n2].isEnabled() && pHPEditorTextHoverDescriptorArray[n2].getStateMask() == n) {
                return new PHPTextHoverProxy(pHPEditorTextHoverDescriptorArray[n2], null);
            }
            ++n2;
        }
        return null;
    }

    public ITextHover getTextHover(ISourceViewer iSourceViewer, String string) {
        return this.getTextHover(iSourceViewer, string, 255);
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer iSourceViewer) {
        if (!this.fPreferenceStore.getBoolean("hyperlinksEnabled")) {
            return null;
        }
        IHyperlinkDetector[] iHyperlinkDetectorArray = super.getHyperlinkDetectors(iSourceViewer);
        int n = iHyperlinkDetectorArray != null ? iHyperlinkDetectorArray.length : 0;
        IHyperlinkDetector[] iHyperlinkDetectorArray2 = new IHyperlinkDetector[n + this.detectors.size()];
        this.detectors.toArray(iHyperlinkDetectorArray2);
        System.arraycopy(iHyperlinkDetectorArray, 0, iHyperlinkDetectorArray2, this.detectors.size(), n);
        return iHyperlinkDetectorArray2;
    }

    public IContentFormatter getContentFormatter(ISourceViewer iSourceViewer) {
        MultiPassContentFormatter multiPassContentFormatter = null;
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(FORMATTER_PROCESSOR_EXT);
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
            if (iConfigurationElement.getName().equals("processor")) {
                ElementCreationProxy elementCreationProxy = new ElementCreationProxy(iConfigurationElement, FORMATTER_PROCESSOR_EXT);
                multiPassContentFormatter = (IContentFormatter)elementCreationProxy.getObject();
            }
            ++n;
        }
        if (multiPassContentFormatter == null) {
            multiPassContentFormatter = new MultiPassContentFormatter(this.getConfiguredDocumentPartitioning(iSourceViewer), "org.eclipse.wst.html.HTML_DEFAULT");
            multiPassContentFormatter.setMasterStrategy((IFormattingStrategy)new StructuredFormattingStrategy((IStructuredFormatProcessor)new PhpFormatProcessorImpl()));
        }
        return multiPassContentFormatter;
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer iSourceViewer, String string) {
        if (string.equals("org.eclipse.php.PHP_DEFAULT")) {
            return phpStrategies;
        }
        return this.getPhpAutoEditStrategy(iSourceViewer, string);
    }

    private final IAutoEditStrategy[] getPhpAutoEditStrategy(ISourceViewer iSourceViewer, String string) {
        IAutoEditStrategy[] iAutoEditStrategyArray = super.getAutoEditStrategies(iSourceViewer, string);
        int n = iAutoEditStrategyArray.length;
        IAutoEditStrategy[] iAutoEditStrategyArray2 = new IAutoEditStrategy[n + 1];
        System.arraycopy(iAutoEditStrategyArray, 0, iAutoEditStrategyArray2, 0, n);
        iAutoEditStrategyArray2[n] = closeTagAutoEditStrategy;
        return iAutoEditStrategyArray2;
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer iSourceViewer, String string) {
        if (string == "org.eclipse.php.PHP_DEFAULT") {
            return new PHPDoubleClickStrategy();
        }
        return super.getDoubleClickStrategy(iSourceViewer, string);
    }

    public String[] getIndentPrefixes(ISourceViewer iSourceViewer, String string) {
        Vector<String> vector = new Vector<String>();
        char c = FormatPreferencesSupport.getInstance().getIndentationChar(null);
        int n = FormatPreferencesSupport.getInstance().getIndentationSize(null);
        int n2 = 0;
        while (n2 <= n) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            int n3 = 0;
            while (n3 + n2 < n) {
                stringBuffer.append(c);
                ++n3;
            }
            if (n2 != 0) {
                bl = true;
            }
            if (bl) {
                stringBuffer.append('\t');
                vector.add(stringBuffer.toString());
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            }
            vector.add(stringBuffer.toString());
            ++n2;
        }
        vector.add(EMPTY);
        return vector.toArray(new String[vector.size()]);
    }

    public IInformationPresenter getOutlinePresenter(ISourceViewer iSourceViewer) {
        InformationPresenter informationPresenter = new InformationPresenter(this.getOutlinePresenterControlCreator(iSourceViewer, SHOW_OUTLINE_PREF_KEY));
        informationPresenter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(iSourceViewer));
        informationPresenter.setAnchor(AbstractInformationControlManager.ANCHOR_GLOBAL);
        PHPElementProvider pHPElementProvider = new PHPElementProvider((IEditorPart)((PHPStructuredTextViewer)iSourceViewer).getTextEditor());
        informationPresenter.setInformationProvider((IInformationProvider)pHPElementProvider, "org.eclipse.php.PHP_DEFAULT");
        informationPresenter.setSizeConstraints(50, 20, true, false);
        return informationPresenter;
    }

    private IInformationControlCreator getOutlinePresenterControlCreator(ISourceViewer iSourceViewer, final String string) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell shell) {
                int n = 16;
                int n2 = 768;
                return new PHPOutlineInformationControl(shell, n, n2, string);
            }
        };
    }
}

