/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.project.build;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.internal.core.CoreMessages;
import org.eclipse.php.internal.core.documentModel.markers.MarkerContributor;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.project.options.PHPProjectOptions;

public class FullPhpProjectBuildVisitor
implements IResourceVisitor {
    private IProgressMonitor monitor;
    private MarkerContributor validator = MarkerContributor.getInstance();

    public FullPhpProjectBuildVisitor(IProgressMonitor iProgressMonitor) {
        this.monitor = iProgressMonitor;
    }

    public boolean visit(IResource iResource) {
        if (this.monitor.isCanceled()) {
            return false;
        }
        if (iResource.getType() == 1) {
            this.handle((IFile)iResource);
            return false;
        }
        if (iResource.getType() == 4) {
            return this.handle((IProject)iResource);
        }
        return true;
    }

    private boolean handle(IProject iProject) {
        if (PHPWorkspaceModelManager.getInstance().getModelForProject(iProject, true) == null) {
            return false;
        }
        PHPProjectOptions pHPProjectOptions = PHPProjectOptions.forProject(iProject);
        pHPProjectOptions.validateIncludePath();
        return true;
    }

    private void handle(IFile iFile) {
        if (this.monitor.isCanceled()) {
            return;
        }
        if (!PHPModelUtil.isPhpFile(iFile)) {
            this.monitor.worked(1);
            return;
        }
        this.monitor.subTask(NLS.bind((String)CoreMessages.getString("FullPhpProjectBuildVisitor_0"), (Object)iFile.getFullPath().toPortableString()));
        PHPWorkspaceModelManager.getInstance().addFileToModel(iFile);
        this.validator.markFile(iFile);
        this.monitor.worked(1);
    }
}

