/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.project.build;

import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.php.core.project.build.IPHPBuilderExtension;
import org.eclipse.php.internal.core.CoreMessages;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.project.build.PHPBuilderExtensionsRegistry;
import org.eclipse.php.internal.core.project.build.RSEFolderReporter;

public class PHPIncrementalProjectBuilder
extends IncrementalProjectBuilder {
    private IPHPBuilderExtension[] extensions = PHPBuilderExtensionsRegistry.getInstance().getExtensions();

    protected IProject[] build(final int n, final Map map, IProgressMonitor iProgressMonitor) throws CoreException {
        final IProject iProject = this.getProject();
        final IResourceDelta iResourceDelta = this.getDelta(iProject);
        if (n == 9) {
            RSEFolderReporter rSEFolderReporter = new RSEFolderReporter();
            try {
                iResourceDelta.accept((IResourceDeltaVisitor)rSEFolderReporter);
            }
            catch (CoreException coreException) {
                Logger.logException(coreException);
            }
            if (rSEFolderReporter.isNewJobNeeded()) {
                WorkspaceJob workspaceJob = new WorkspaceJob("Building PHP projects"){

                    public IStatus runInWorkspace(IProgressMonitor iProgressMonitor) throws CoreException {
                        PHPIncrementalProjectBuilder.this.internalBuild(iProject, iResourceDelta, n, map, iProgressMonitor);
                        return Status.OK_STATUS;
                    }
                };
                workspaceJob.setPriority(30);
                workspaceJob.setUser(false);
                workspaceJob.schedule();
                return null;
            }
        }
        return this.internalBuild(iProject, iResourceDelta, n, map, iProgressMonitor);
    }

    private IProject[] internalBuild(IProject iProject, IResourceDelta iResourceDelta, int n, Map map, IProgressMonitor iProgressMonitor) throws CoreException {
        iProgressMonitor.beginTask(CoreMessages.getString("PHPIncrementalProjectBuilder_0"), this.extensions.length);
        int n2 = 1;
        if (iResourceDelta != null) {
            FileCounter fileCounter = new FileCounter();
            iResourceDelta.accept((IResourceDeltaVisitor)fileCounter);
            n2 = fileCounter.numOfFiles;
        }
        int n3 = 0;
        while (n3 < this.extensions.length) {
            if (this.extensions[n3].isEnabled()) {
                SubProgressMonitor subProgressMonitor = new SubProgressMonitor(iProgressMonitor, 1);
                subProgressMonitor.beginTask(iProject.getName(), n2);
                this.extensions[n3].build(iProject, iResourceDelta, n, map, (IProgressMonitor)subProgressMonitor);
            }
            ++n3;
        }
        return null;
    }

    protected void clean(IProgressMonitor iProgressMonitor) throws CoreException {
        int n = 0;
        while (n < this.extensions.length) {
            if (this.extensions[n].isEnabled()) {
                this.extensions[n].clean(this.getProject(), iProgressMonitor);
            }
            ++n;
        }
    }

    protected void startupOnInitialize() {
        super.startupOnInitialize();
        int n = 0;
        while (n < this.extensions.length) {
            this.extensions[n].startupOnInitialize(this);
            ++n;
        }
    }

    class FileCounter
    implements IResourceDeltaVisitor {
        public int numOfFiles = 0;

        FileCounter() {
        }

        public boolean visit(IResourceDelta iResourceDelta) throws CoreException {
            if (iResourceDelta.getResource().getType() == 1) {
                ++this.numOfFiles;
                return false;
            }
            return true;
        }
    }
}

