/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.daemon;

import java.io.IOException;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.text.MessageFormat;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.php.debug.daemon.communication.ICommunicationDaemon;
import org.eclipse.php.internal.debug.core.Logger;
import org.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractDebuggerCommunicationDaemon
implements ICommunicationDaemon {
    protected Object lock = new Object();
    protected ServerSocket serverSocket;
    protected boolean isAlive;
    protected Thread listenerThread;

    public void init() {
        this.resetSocket();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startListen() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isAlive && this.serverSocket != null) {
                this.startListenThread();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopListen() {
        Object object = this.lock;
        synchronized (object) {
            block15: {
                this.isAlive = false;
                if (this.serverSocket != null) {
                    try {
                        if (!this.serverSocket.isClosed()) {
                            this.serverSocket.close();
                        }
                    }
                    catch (SocketException socketException) {
                        this.serverSocket = null;
                        break block15;
                    }
                    catch (IOException iOException) {
                        try {
                            Logger.logException("Problem while closing the debugger ServerSocket.", iOException);
                            break block15;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            this.serverSocket = null;
                        }
                    }
                    this.serverSocket = null;
                }
            }
        }
        try {
            if (this.listenerThread != null) {
                this.listenerThread.join(2000L);
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isListening() {
        Object object = this.lock;
        synchronized (object) {
            return this.isAlive;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean resetSocket() {
        this.stopListen();
        int n = this.getReceiverPort();
        try {
            Object object = this.lock;
            synchronized (object) {
                this.serverSocket = new ServerSocket(n);
                this.startListen();
                return true;
            }
        }
        catch (BindException bindException) {
            this.handleMultipleBindingError();
            return false;
        }
        catch (IOException iOException) {
            Logger.logException("Error while restting the socket for the debug requests.", iOException);
        }
        return false;
    }

    public void handleMultipleBindingError() {
        final int n = this.getReceiverPort();
        Logger.log(4, "The debug port " + n + " is in use. Please select a different port for the debugger.");
        final Display display = Display.getDefault();
        display.asyncExec(new Runnable(){

            public void run() {
                String string = MessageFormat.format(PHPDebugCoreMessages.Port_Error_Message_Message, String.valueOf(n));
                MessageDialog.openWarning((Shell)display.getActiveShell(), (String)PHPDebugCoreMessages.Port_Error_Message_Title, (String)string);
            }
        });
    }

    public abstract int getReceiverPort();

    protected abstract void startConnectionThread(Socket var1);

    public abstract String getDebuggerID();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startListenThread() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isAlive) {
                return;
            }
            this.isAlive = true;
        }
        object = " - Port: " + (this.serverSocket != null ? String.valueOf(this.serverSocket.getLocalPort()) : "??");
        this.listenerThread = new Thread((Runnable)new ReceiverThread(), "PHP Debugger Daemon Thread " + (String)object);
        this.listenerThread.setDaemon(true);
        this.listenerThread.start();
    }

    public boolean isEnabled() {
        return true;
    }

    private class ReceiverThread
    implements Runnable {
        private ReceiverThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (AbstractDebuggerCommunicationDaemon.this.isAlive) {
                    Socket socket = AbstractDebuggerCommunicationDaemon.this.serverSocket.accept();
                    AbstractDebuggerCommunicationDaemon.this.startConnectionThread(socket);
                }
            }
            catch (IOException iOException) {
                Object object = AbstractDebuggerCommunicationDaemon.this.lock;
                synchronized (object) {
                    if (AbstractDebuggerCommunicationDaemon.this.isAlive) {
                        Logger.logException("Error while listening to incoming debug requests. Listen thread terminated!", iOException);
                        AbstractDebuggerCommunicationDaemon.this.isAlive = false;
                    }
                }
            }
        }
    }
}

