/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.xdebug.dbgp;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.preferences.AbstractDebuggerConfigurationDialog;
import org.eclipse.php.internal.debug.core.xdebug.IDELayer;
import org.eclipse.php.internal.debug.core.xdebug.IDELayerFactory;
import org.eclipse.php.internal.debug.core.xdebug.XDebugPreferenceInit;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpProxyHandler;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.XDebugDebuggerConfiguration;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class XDebugConfigurationDialog
extends AbstractDebuggerConfigurationDialog {
    private Text portTextBox;
    private Button showGlobals;
    private Spinner variableDepth;
    private Button useMultiSession;
    private Button useProxy;
    private Text idekeyTextBox;
    private Text proxyTextBox;
    private XDebugDebuggerConfiguration xdebugDebuggerConfiguration;

    public XDebugConfigurationDialog(XDebugDebuggerConfiguration xDebugDebuggerConfiguration, Shell shell) {
        super(shell);
        this.xdebugDebuggerConfiguration = xDebugDebuggerConfiguration;
    }

    private void toggleProxyFields(boolean bl) {
        this.idekeyTextBox.setEnabled(bl);
        this.proxyTextBox.setEnabled(bl);
    }

    protected Control createDialogArea(Composite composite) {
        composite = (Composite)super.createDialogArea(composite);
        this.setTitle(PHPDebugCoreMessages.XDebugConfigurationDialog_xdebugSettings);
        Composite composite2 = this.createSubsection(composite, PHPDebugCoreMessages.XDebugConfigurationDialog_xdebugSettings);
        this.addLabelControl(composite2, PHPDebugCoreMessages.DebuggerConfigurationDialog_debugPort, "org.eclipse.php.debug.core.xdebug_port");
        this.portTextBox = this.addNumTextField(composite2, "org.eclipse.php.debug.core.xdebug_port", 5, 2, false);
        this.showGlobals = this.addCheckBox(composite2, PHPDebugCoreMessages.XDebugConfigurationDialog_showSuperGlobals, "org.eclipse.php.debug.core.xdebug_showSuperGlobals", 0);
        this.addLabelControl(composite2, PHPDebugCoreMessages.XDebugConfigurationDialog_maxArrayDepth, "org.eclipse.php.debug.core.xdebug_arrayDepth");
        this.variableDepth = this.addVariableLevel(composite2, "org.eclipse.php.debug.core.xdebug_arrayDepth", 1, 150, 2);
        this.useMultiSession = this.addCheckBox(composite2, PHPDebugCoreMessages.XDebugConfigurationDialog_useMultisession, "org.eclipse.php.debug.core.xdebug_multisession", 0);
        Composite composite3 = this.createSubsection(composite2, PHPDebugCoreMessages.XDebugConfigurationDialog_proxyGroup);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite3.setLayout((Layout)gridLayout);
        this.useProxy = this.addCheckBox(composite3, PHPDebugCoreMessages.XDebugConfigurationDialog_useProxy, "org.eclipse.php.debug.core.xdebug_useproxy", 0);
        this.useProxy.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                XDebugConfigurationDialog.this.toggleProxyFields(XDebugConfigurationDialog.this.useProxy.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                XDebugConfigurationDialog.this.toggleProxyFields(XDebugConfigurationDialog.this.useProxy.getSelection());
            }
        });
        this.addLabelControl(composite3, PHPDebugCoreMessages.XDebugConfigurationDialog_idekey, "org.eclipse.php.debug.core.xdebug_idekey");
        this.idekeyTextBox = this.addATextField(composite3, "org.eclipse.php.debug.core.xdebug_idekey", 100, 2);
        this.addLabelControl(composite3, PHPDebugCoreMessages.XDebugConfigurationDialog_proxy, "org.eclipse.php.debug.core.xdebug_proxy");
        this.proxyTextBox = this.addATextField(composite3, "org.eclipse.php.debug.core.xdebug_proxy", 100, 2);
        this.internalInitializeValues();
        return composite2;
    }

    private Text addNumTextField(Composite composite, String string, int n, int n2, boolean bl) {
        Text text = super.addTextField(composite, string, n, n2);
        text.addModifyListener((ModifyListener)new NumFieldValidateListener(bl));
        return text;
    }

    private Text addATextField(Composite composite, String string, int n, int n2) {
        Text text = new Text(composite, 2052);
        text.setData((Object)string);
        GridData gridData = new GridData(768);
        gridData.horizontalIndent = n2;
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = false;
        gridData.minimumWidth = n;
        text.setLayoutData((Object)gridData);
        return text;
    }

    protected void okPressed() {
        IDELayer iDELayer = IDELayerFactory.getIDELayer();
        Preferences preferences = iDELayer.getPrefs();
        preferences.setValue("org.eclipse.php.debug.core.xdebug_port", this.portTextBox.getText());
        preferences.setValue("org.eclipse.php.debug.core.xdebug_showSuperGlobals", this.showGlobals.getSelection());
        preferences.setValue("org.eclipse.php.debug.core.xdebug_arrayDepth", this.variableDepth.getSelection());
        preferences.setValue("org.eclipse.php.debug.core.xdebug_multisession", this.useMultiSession.getSelection());
        preferences.setValue("org.eclipse.php.debug.core.xdebug_useproxy", this.useProxy.getSelection());
        preferences.setValue("org.eclipse.php.debug.core.xdebug_idekey", this.idekeyTextBox.getText());
        preferences.setValue("org.eclipse.php.debug.core.xdebug_proxy", this.proxyTextBox.getText());
        DBGpProxyHandler.instance.configure();
        PHPDebugPlugin.getDefault().savePluginPreferences();
        super.okPressed();
    }

    private void internalInitializeValues() {
        IDELayer iDELayer = IDELayerFactory.getIDELayer();
        Preferences preferences = iDELayer.getPrefs();
        int n = preferences.getInt("org.eclipse.php.debug.core.xdebug_port");
        if (n == 0) {
            XDebugPreferenceInit.setDefaults();
            n = preferences.getInt("org.eclipse.php.debug.core.xdebug_port");
        }
        this.portTextBox.setText(Integer.toString(n));
        this.showGlobals.setSelection(preferences.getBoolean("org.eclipse.php.debug.core.xdebug_showSuperGlobals"));
        this.useMultiSession.setSelection(preferences.getBoolean("org.eclipse.php.debug.core.xdebug_multisession"));
        this.variableDepth.setSelection(preferences.getInt("org.eclipse.php.debug.core.xdebug_arrayDepth"));
        boolean bl = preferences.getBoolean("org.eclipse.php.debug.core.xdebug_useproxy");
        this.useProxy.setSelection(bl);
        String string = preferences.getString("org.eclipse.php.debug.core.xdebug_idekey");
        if (string == null || string.length() == 0) {
            string = DBGpProxyHandler.instance.generateIDEKey();
        }
        this.idekeyTextBox.setText(string);
        this.proxyTextBox.setText(preferences.getString("org.eclipse.php.debug.core.xdebug_proxy"));
        this.toggleProxyFields(bl);
    }

    private Spinner addVariableLevel(Composite composite, String string, int n, int n2, int n3) {
        Spinner spinner = new Spinner(composite, 512);
        spinner.setData((Object)string);
        spinner.setMinimum(n);
        spinner.setMaximum(n2);
        GridData gridData = new GridData();
        gridData.horizontalIndent = n3;
        gridData.horizontalSpan = 2;
        spinner.setLayoutData((Object)gridData);
        spinner.setIncrement(1);
        spinner.setPageIncrement(3);
        return spinner;
    }

    class NumFieldValidateListener
    implements ModifyListener {
        private boolean timeoutField;

        NumFieldValidateListener(boolean bl) {
            this.timeoutField = bl;
        }

        public void modifyText(ModifyEvent modifyEvent) {
            Integer n;
            String string = null;
            boolean bl = true;
            String string2 = ((Text)modifyEvent.widget).getText();
            try {
                n = new Integer(string2);
                int n2 = n;
                if (!this.timeoutField) {
                    if (n2 <= 0 || n2 > 65535) {
                        bl = false;
                        string = PHPDebugCoreMessages.XDebugConfigurationDialog_invalidPortRange;
                    }
                } else if (n2 < 10 || n2 > 100000) {
                    bl = false;
                    string = PHPDebugCoreMessages.XDebugConfigurationDialog_invalidTimeout;
                }
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
                string = !this.timeoutField ? PHPDebugCoreMessages.DebuggerConfigurationDialog_invalidPort : PHPDebugCoreMessages.XDebugConfigurationDialog_invalidTimeoutValue;
            }
            XDebugConfigurationDialog.this.setErrorMessage(string);
            n = XDebugConfigurationDialog.this.getButton(0);
            if (n != null) {
                n.setEnabled(bl);
            }
        }
    }
}

