/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.console;

import java.io.File;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.filesystem.local.LocalFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.internal.core.filesystem.FileStoreFactory;
import org.eclipse.php.internal.core.resources.ExternalFileWrapper;
import org.eclipse.php.internal.debug.ui.Logger;
import org.eclipse.php.internal.ui.editor.input.NonExistingPHPFileEditorInput;
import org.eclipse.php.internal.ui.util.EditorUtility;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.sse.ui.StructuredTextEditor;

public class PHPFileLink
implements IHyperlink {
    private Object fFile;
    private int fFileOffset;
    private int fFileLength;
    private int fFileLineNumber;

    public PHPFileLink(Object object, int n, int n2, int n3) {
        this.fFile = object;
        this.fFileOffset = n;
        this.fFileLength = n2;
        this.fFileLineNumber = n3;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void linkActivated() {
        IEditorPart iEditorPart = null;
        Object var2_2 = null;
        try {
            ExternalFileWrapper externalFileWrapper;
            if (this.fFile instanceof File) {
                externalFileWrapper = new FileStoreEditorInput((IFileStore)new LocalFile((File)this.fFile));
                iEditorPart = EditorUtility.openInEditor((IEditorInput)externalFileWrapper, (String)"org.eclipse.php.editor", (boolean)false);
            } else if (this.fFile instanceof ExternalFileWrapper) {
                externalFileWrapper = (ExternalFileWrapper)this.fFile;
                IPath iPath = externalFileWrapper.getFullPath();
                if (iPath.segmentCount() > 1 && iPath.segment(iPath.segmentCount() - 2).equalsIgnoreCase("Untitled_Documents")) {
                    NonExistingPHPFileEditorInput nonExistingPHPFileEditorInput = new NonExistingPHPFileEditorInput(iPath);
                    iEditorPart = EditorUtility.openInEditor((IEditorInput)nonExistingPHPFileEditorInput, (String)"org.eclipse.php.untitledPhpEditor", (boolean)false);
                } else {
                    FileStoreEditorInput fileStoreEditorInput = new FileStoreEditorInput(FileStoreFactory.createFileStore((File)new File(externalFileWrapper.getFullPath().toOSString())));
                    iEditorPart = EditorUtility.openInEditor((IEditorInput)fileStoreEditorInput, (String)"org.eclipse.php.editor", (boolean)false);
                }
            } else {
                iEditorPart = this.fFile instanceof IFile ? EditorUtility.openInEditor((IEditorInput)new FileEditorInput((IFile)this.fFile), (String)"org.eclipse.php.editor", (boolean)false) : EditorUtility.openInEditor((Object)this.fFile, (boolean)false);
            }
            if (iEditorPart != null && this.fFileLineNumber > 0 && iEditorPart instanceof StructuredTextEditor && this.fFileOffset < 0) {
                externalFileWrapper = ((StructuredTextEditor)iEditorPart).getTextViewer().getDocument().getLineInformation(this.fFileLineNumber - 1);
                this.fFileOffset = externalFileWrapper.getOffset();
                this.fFileLength = externalFileWrapper.getLength();
            }
        }
        catch (PartInitException partInitException) {
            Logger.logException(partInitException);
            if (iEditorPart == null) return;
            EditorUtility.revealInEditor(iEditorPart, (int)this.fFileOffset, (int)this.fFileLength);
            if (var2_2 == null) return;
            var2_2.releaseFromRead();
            return;
        }
        catch (BadLocationException badLocationException) {
            Logger.logException(badLocationException);
            return;
        }
        catch (NullPointerException nullPointerException) {
            Logger.logException(nullPointerException);
            if (iEditorPart == null) return;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            EditorUtility.revealInEditor(iEditorPart, (int)this.fFileOffset, (int)this.fFileLength);
            if (var2_2 == null) return;
            var2_2.releaseFromRead();
            return;
        }
        {
            finally {
                if (iEditorPart != null) {
                    EditorUtility.revealInEditor(iEditorPart, (int)this.fFileOffset, (int)this.fFileLength);
                    if (var2_2 != null) {
                        var2_2.releaseFromRead();
                    }
                }
            }
        }
        if (iEditorPart == null) return;
        EditorUtility.revealInEditor((IEditorPart)iEditorPart, (int)this.fFileOffset, (int)this.fFileLength);
        if (var2_2 == null) return;
        var2_2.releaseFromRead();
    }

    public void linkEntered() {
    }

    public void linkExited() {
    }
}

