/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.wizards;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.php.internal.debug.core.pathmapper.PathMapper;
import org.eclipse.php.internal.debug.core.pathmapper.PathMapperRegistry;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.php.internal.debug.ui.PHPDebugUIImages;
import org.eclipse.php.internal.debug.ui.pathmapper.PathMappingComposite;
import org.eclipse.php.internal.debug.ui.wizards.PHPExeEditDialog;
import org.eclipse.php.internal.ui.wizards.CompositeFragment;
import org.eclipse.php.internal.ui.wizards.IControlHandler;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class PathMapperCompositeFragment
extends CompositeFragment {
    private PathMappingComposite pathMapperComposite;

    public PathMapperCompositeFragment(Composite composite, IControlHandler iControlHandler, boolean bl) {
        super(composite, iControlHandler, bl);
        this.controlHandler.setTitle("PHP Executable Path Mapping");
        this.controlHandler.setDescription("Specify mapping between PHP executable relative and local paths");
        this.controlHandler.setImageDescriptor(PHPDebugUIImages.getImageDescriptor("IMG_WIZBAN_PHPEXE"));
        this.setDisplayName("Path Mapping");
        this.setTitle("Edit PHP Executable Path Mapping");
        this.setDescription("Configure PHP Executable Path Mapping");
        if (bl) {
            this.setData(((PHPExeEditDialog)this.controlHandler).getPHPExeItem());
        }
        this.createControl(bl);
    }

    protected void createControl(boolean bl) {
        GridLayout gridLayout = new GridLayout();
        this.setLayout((Layout)gridLayout);
        Composite composite = new Composite((Composite)this, 0);
        gridLayout.numColumns = 1;
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        this.pathMapperComposite = new PathMappingComposite(composite, 0);
        gridData = new GridData(1808);
        this.pathMapperComposite.setLayoutData(gridData);
        Dialog.applyDialogFont((Control)this);
        this.init();
        this.validate();
    }

    protected void init() {
        PathMapper pathMapper;
        if (this.pathMapperComposite == null || this.pathMapperComposite.isDisposed()) {
            return;
        }
        PHPexeItem pHPexeItem = this.getPHPExeItem();
        if (pHPexeItem != null && (pathMapper = PathMapperRegistry.getByPHPExe((PHPexeItem)pHPexeItem)) != null) {
            this.pathMapperComposite.setData(pathMapper.getMapping());
        }
    }

    protected void validate() {
        this.setMessage(this.getDescription(), 0);
        this.setComplete(true);
        this.controlHandler.update();
    }

    protected void setMessage(String string, int n) {
        this.controlHandler.setMessage(string, n);
        this.setComplete(n != 3);
        this.controlHandler.update();
    }

    public boolean performOk() {
        PHPexeItem pHPexeItem = this.getPHPExeItem();
        if (pHPexeItem != null) {
            PathMapper pathMapper = PathMapperRegistry.getByPHPExe((PHPexeItem)pHPexeItem);
            pathMapper.setMapping(this.pathMapperComposite.getMappings());
            PathMapperRegistry.storeToPreferences();
        }
        return true;
    }

    public void setData(Object object) {
        if (object != null && !(object instanceof PHPexeItem)) {
            throw new IllegalArgumentException("The given object is not a PHPExeItem");
        }
        super.setData(object);
        this.init();
        this.validate();
    }

    public PHPexeItem getPHPExeItem() {
        return (PHPexeItem)this.getData();
    }
}

