/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.internal.ui.actions.refactoring.MoveAction;
import org.eclipse.dltk.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.actions.ActionUtils;
import org.eclipse.php.internal.ui.actions.SelectionConverter;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.operations.UndoRedoActionGroup;
import org.eclipse.ui.part.Page;

public class RefactorActionGroup
extends ActionGroup {
    public static final String MENU_ID = "org.eclipse.php.ui.refactoring.menu";
    public static final String GROUP_REORG = "reorgGroup";
    public static final String GROUP_TYPE = "typeGroup";
    private IWorkbenchSite fSite;
    private PHPStructuredEditor fEditor;
    private String fGroupName = "group.reorganize";
    private SelectionDispatchAction fMoveAction;
    private UndoRedoActionGroup fUndoRedoActionGroup;
    private List fEditorActions;
    private IKeyBindingService fKeyBindingService;
    private Action fNoActionAvailable = new NoActionAvailable();

    public RefactorActionGroup(IViewPart part) {
        this((IWorkbenchSite)part.getSite(), part.getSite().getKeyBindingService());
        IUndoContext workspaceContext = (IUndoContext)ResourcesPlugin.getWorkspace().getAdapter(IUndoContext.class);
        this.fUndoRedoActionGroup = new UndoRedoActionGroup((IWorkbenchPartSite)part.getViewSite(), workspaceContext, true);
    }

    public RefactorActionGroup(Page page) {
        this((IWorkbenchSite)page.getSite(), null);
    }

    public RefactorActionGroup(PHPStructuredEditor editor, String groupName) {
        this.fSite = editor.getEditorPart().getEditorSite();
        this.fEditor = editor;
        this.fGroupName = groupName;
        ISelectionProvider provider = editor.getSelectionProvider();
        ISelection selection = provider.getSelection();
        this.fEditorActions = new ArrayList();
        this.fMoveAction = new MoveAction((IWorkbenchSite)editor.getEditorSite());
        this.fMoveAction.setActionDefinitionId("org.eclipse.php.ui.edit.text.move.element");
        this.fMoveAction.update(selection);
        RefactorActionGroup.initAction(this.fMoveAction, provider, selection);
        editor.setAction("MoveElement", (IAction)this.fMoveAction);
        this.fEditorActions.add(this.fMoveAction);
        this.fKeyBindingService = editor.getEditorSite().getKeyBindingService();
    }

    private RefactorActionGroup(IWorkbenchSite site, IKeyBindingService keyBindingService) {
        this.fSite = site;
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        ISelection selection = provider.getSelection();
        this.fMoveAction = new MoveAction(site);
        this.fMoveAction.setActionDefinitionId("org.eclipse.php.ui.edit.text.move.element");
        RefactorActionGroup.initAction(this.fMoveAction, provider, selection);
        this.fKeyBindingService = keyBindingService;
    }

    private static void initAction(SelectionDispatchAction action, ISelectionProvider provider, ISelection selection) {
        action.update(selection);
        provider.addSelectionChangedListener((ISelectionChangedListener)action);
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        actionBars.setGlobalActionHandler("org.eclipse.php.ui.actions.Move", (IAction)this.fMoveAction);
        if (this.fUndoRedoActionGroup != null) {
            this.fUndoRedoActionGroup.fillActionBars(actionBars);
        }
    }

    public void retargetFileMenuActions(IActionBars actionBars) {
        actionBars.setGlobalActionHandler(ActionFactory.MOVE.getId(), (IAction)this.fMoveAction);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        this.addRefactorSubmenu(menu);
    }

    public void dispose() {
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        this.disposeAction((ISelectionChangedListener)this.fMoveAction, provider);
        if (this.fUndoRedoActionGroup != null) {
            this.fUndoRedoActionGroup.dispose();
        }
        super.dispose();
    }

    private void disposeAction(ISelectionChangedListener action, ISelectionProvider provider) {
        if (action != null) {
            provider.removeSelectionChangedListener(action);
        }
    }

    private void addRefactorSubmenu(IMenuManager menu) {
        String menuText = PHPUIMessages.getString("RefactorMenu_label");
        IMenuManager refactorSubmenu = (IMenuManager)menu.find(MENU_ID);
        if (refactorSubmenu == null) {
            refactorSubmenu = new MenuManager(menuText, MENU_ID);
        }
        if (this.fEditor != null) {
            ISourceModule element = SelectionConverter.getInput(this.fEditor);
            if (element != null && ActionUtils.isPHPSource(element)) {
                refactorSubmenu.addMenuListener(new IMenuListener(){

                    public void menuAboutToShow(IMenuManager manager) {
                        RefactorActionGroup.this.refactorMenuShown(manager);
                    }
                });
                this.fillMenu(menu, refactorSubmenu);
            }
        } else {
            this.fillMenu(menu, refactorSubmenu);
        }
    }

    private void fillMenu(IMenuManager menu, IMenuManager refactorSubmenu) {
        if (this.fillRefactorMenu(refactorSubmenu) > 0) {
            menu.appendToGroup(this.fGroupName, (IContributionItem)refactorSubmenu);
        } else {
            refactorSubmenu.add((IAction)this.fNoActionAvailable);
        }
    }

    private int fillRefactorMenu(IMenuManager refactorSubmenu) {
        int added = 0;
        refactorSubmenu.add((IContributionItem)new Separator(GROUP_REORG));
        refactorSubmenu.add((IContributionItem)new Separator(GROUP_TYPE));
        return added += this.addAction(refactorSubmenu, (IAction)this.fMoveAction);
    }

    private int addAction(IMenuManager menu, IAction action) {
        if (action != null && action.isEnabled()) {
            menu.add(action);
            return 1;
        }
        return 0;
    }

    private void refactorMenuShown(final IMenuManager refactorSubmenu) {
        Menu menu = ((MenuManager)refactorSubmenu).getMenu();
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuHidden(MenuEvent e) {
                RefactorActionGroup.this.refactorMenuHidden(refactorSubmenu);
            }
        });
        ITextSelection textSelection = (ITextSelection)this.fEditor.getSelectionProvider().getSelection();
        for (SelectionDispatchAction action : this.fEditorActions) {
            action.update((ISelection)textSelection);
        }
    }

    private void refactorMenuHidden(IMenuManager manager) {
        ITextSelection textSelection = (ITextSelection)this.fEditor.getSelectionProvider().getSelection();
        for (SelectionDispatchAction action : this.fEditorActions) {
            action.update((ISelection)textSelection);
        }
    }

    private static class NoActionAvailable
    extends Action {
        public NoActionAvailable() {
            this.setEnabled(false);
            this.setText(PHPUIMessages.getString("RefactorActionGroup_no_refactoring_available"));
        }
    }
}

