/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.util;

import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.internal.ui.util.EditorUtility;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public class CodeInjector {
    private int offset = -1;
    private IStructuredDocument document = null;
    private IStructuredModel model = null;
    private ISourceModule existingPHPFile = null;

    public CodeInjector() {
    }

    public CodeInjector(ISourceModule existingPHPFile, int offset) {
        this.existingPHPFile = existingPHPFile;
        this.offset = offset;
    }

    public CodeInjector(ISourceModule existingPHPFile) {
        this.existingPHPFile = existingPHPFile;
    }

    private void init() {
        try {
            try {
                IEditorPart editor = EditorUtility.openInEditor(this.existingPHPFile, true);
                this.document = (IStructuredDocument)((PHPStructuredEditor)editor).getDocument();
                this.model = StructuredModelManager.getModelManager().getModelForEdit(this.document);
            }
            catch (PartInitException e) {
                Logger.logException(e);
                this.model.releaseFromEdit();
            }
        }
        finally {
            this.model.releaseFromEdit();
        }
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void inject(String contents, boolean doFormat, boolean saveChanges) {
        this.init();
        if (this.offset == -1) {
            this.offset = this.document.getLength();
        }
        this.document.replaceText((Object)this, this.offset, 0, contents);
        if (doFormat) {
            this.formatDocument(this.document, this.offset, contents.length() + 1);
        }
        if (saveChanges) {
            try {
                this.model.save();
            }
            catch (Exception e) {
                Logger.logException(e);
            }
        }
    }

    public void formatDocument(IStructuredDocument document, int offset, int length) {
        IContentFormatter formatter = null;
        if (formatter == null) {
            formatter = PHPUiPlugin.getDefault().getActiveFormatter();
        }
        try {
            formatter.format((IDocument)document, (IRegion)new Region(offset, length));
        }
        catch (Exception e) {
            Logger.logException(e);
        }
    }

    public int getOffset() {
        return this.offset;
    }
}

