/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.php.internal.debug.core.Logger;
import org.eclipse.php.internal.debug.core.pathmapper.VirtualPath;
import org.eclipse.php.internal.debug.core.zend.debugger.DefaultExpression;
import org.eclipse.php.internal.debug.core.zend.debugger.DefaultExpressionsManager;
import org.eclipse.php.internal.debug.core.zend.debugger.Expression;
import org.eclipse.php.internal.debug.core.zend.debugger.ExpressionValue;
import org.eclipse.php.internal.debug.core.zend.debugger.IRemoteDebugger;
import org.eclipse.php.internal.debug.core.zend.debugger.PHPstack;
import org.eclipse.php.internal.debug.core.zend.debugger.RemoteDebugger;
import org.eclipse.php.internal.debug.core.zend.debugger.StackLayer;
import org.eclipse.php.internal.debug.core.zend.model.PHPDebugTarget;
import org.eclipse.php.internal.debug.core.zend.model.PHPStackFrame;
import org.eclipse.php.internal.debug.core.zend.model.PHPThread;
import org.eclipse.php.internal.debug.core.zend.model.PHPVariable;
import org.eclipse.php.internal.debug.core.zend.model.ResolveBlackList;

public class ContextManager {
    private PHPDebugTarget fTarget;
    private IRemoteDebugger fDebugger;
    private StackLayer[] fPreviousLayers;
    private IStackFrame[] fPreviousFrames = null;
    private Map<String, Expression[]> fStackVariables;
    private Map<String, String> fResolvedStackLayersMap;
    private int fSuspendCount;
    private IVariable[] fVariables;
    private static final String DUMMY_PHP_FILE = "dummy.php";

    public ContextManager(PHPDebugTarget target, IRemoteDebugger debugger) {
        this.fTarget = target;
        this.fSuspendCount = target.getSuspendCount();
        this.fDebugger = debugger;
        this.fStackVariables = new HashMap<String, Expression[]>();
        this.fResolvedStackLayersMap = new HashMap<String, String>();
    }

    public void cacheResolvedStackLayers(String nonResolvedTuple, String resolvedCalled) {
        if (!this.fResolvedStackLayersMap.containsKey(nonResolvedTuple)) {
            this.fResolvedStackLayersMap.put(nonResolvedTuple, resolvedCalled);
        }
    }

    public String getCachedResolvedStackLayer(String nonResolvedTuple) {
        if (this.fResolvedStackLayersMap.containsKey(nonResolvedTuple)) {
            return this.fResolvedStackLayersMap.get(nonResolvedTuple);
        }
        return "";
    }

    public void addToResolveBlacklist(VirtualPath path, ResolveBlackList.Type type) {
        ResolveBlackList.getInstance().add(this.fDebugger.getDebugHandler().getDebugTarget().getLaunch(), path, type);
    }

    public boolean isResolveBlacklisted(String remoteFile) {
        return ResolveBlackList.getInstance().containsEntry(this.fDebugger.getDebugHandler().getDebugTarget().getLaunch(), remoteFile);
    }

    public IStackFrame[] getStackFrames() throws DebugException {
        return this.getStackFrames(false);
    }

    public IStackFrame[] getStackFrames(boolean fetchVariables) throws DebugException {
        PHPstack stack = this.fDebugger.getCallStack(fetchVariables);
        PHPThread thread = (PHPThread)this.fTarget.getThreads()[0];
        StackLayer[] layers = stack.getLayers();
        boolean main = false;
        if (layers.length == 1) {
            main = true;
        }
        if (this.fPreviousFrames == null) {
            this.fPreviousFrames = this.applyDebugFilters(this.createNewFrames(layers, thread));
            this.fVariables = this.createVariables(main, false, true);
            this.createStackVariables(layers);
            this.fSuspendCount = this.fTarget.getSuspendCount();
            return this.fPreviousFrames;
        }
        if (this.fSuspendCount == this.fTarget.getSuspendCount()) {
            if (fetchVariables) {
                this.createStackVariables(layers);
            }
            return this.fPreviousFrames;
        }
        this.fSuspendCount = this.fTarget.getSuspendCount();
        boolean layersSame = this.compareLayers(layers, this.fPreviousLayers);
        if (layersSame) {
            this.fVariables = this.createVariables(main, false, false);
            PHPStackFrame originalFrame = (PHPStackFrame)this.fPreviousFrames[0];
            int topID = originalFrame.getIdentifier();
            String fileName = originalFrame.getAbsoluteFileName();
            String sourceFile = originalFrame.getSourceName();
            this.fPreviousFrames[0] = new PHPStackFrame(thread, fileName, main ? "" : this.fPreviousFrames[1].getName(), this.fTarget.getLastStop(), topID, sourceFile);
        } else if (layers.length == 1 && layers[0].getCalledFileName().endsWith(DUMMY_PHP_FILE)) {
            this.fDebugger.finish();
        } else {
            this.fPreviousFrames = this.applyDebugFilters(this.createNewFrames(layers, thread));
            this.fVariables = this.createVariables(main, false, true);
        }
        this.createStackVariables(layers);
        return this.fPreviousFrames;
    }

    private IStackFrame[] applyDebugFilters(IStackFrame[] previousFrames) {
        ArrayList<IStackFrame> tempStackFrames = new ArrayList<IStackFrame>();
        int i = 0;
        while (i < previousFrames.length) {
            String stackFrameName;
            if (i != previousFrames.length - 1 || !(stackFrameName = ((PHPStackFrame)previousFrames[i]).getAbsoluteFileName()).endsWith(DUMMY_PHP_FILE)) {
                tempStackFrames.add(previousFrames[i]);
            }
            ++i;
        }
        IStackFrame[] result = new IStackFrame[tempStackFrames.size()];
        tempStackFrames.toArray(result);
        return result;
    }

    public IVariable[] getVariables() {
        return this.fVariables;
    }

    public Expression[] getStackVariables(PHPStackFrame stack) {
        String functionName = "";
        try {
            functionName = stack.getName();
        }
        catch (DebugException e) {
            Logger.logException("PHP Problem getting name from stack", e);
        }
        Expression[] variables = new Expression[]{};
        if (!functionName.equals("")) {
            String key = String.valueOf(functionName) + stack.getAbsoluteFileName();
            variables = this.fStackVariables.get(key);
        }
        return variables;
    }

    private boolean compareLayers(StackLayer[] layers, StackLayer[] prevLayers) {
        if (layers.length != prevLayers.length) {
            return false;
        }
        int i = 0;
        while (i < layers.length) {
            if (!this.compareLayer(layers[i], prevLayers[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean compareLayer(StackLayer layer, StackLayer prevLayer) {
        return layer.getCallerFileName().equals(prevLayer.getCallerFileName()) && layer.getCallerFunctionName().equals(prevLayer.getCallerFunctionName()) && layer.getCallerLineNumber() == prevLayer.getCallerLineNumber() && layer.getCalledFileName().equals(prevLayer.getCalledFileName()) && layer.getCalledFunctionName().equals(prevLayer.getCalledFunctionName()) && layer.getCalledLineNumber() == prevLayer.getCalledLineNumber();
    }

    private IStackFrame[] createNewFrames(StackLayer[] layers, PHPThread thread) throws DebugException {
        RemoteDebugger remoteDebugger = (RemoteDebugger)this.fDebugger;
        String cwd = remoteDebugger.getCurrentWorkingDirectory();
        String currentScript = null;
        IStackFrame[] frames = new IStackFrame[(layers.length - 1) * 2 + 1];
        int frameCt = (layers.length - 1) * 2 + 1;
        int i = 1;
        while (i < layers.length) {
            String sName = layers[i].getCallerFileName();
            String rName = remoteDebugger.convertToLocalFilename(sName, cwd, frameCt < frames.length ? ((PHPStackFrame)frames[frameCt]).getSourceName() : null);
            if (rName == null) {
                rName = sName;
            }
            frames[frameCt - 1] = new PHPStackFrame(thread, sName, layers[i].getCallerFunctionName(), layers[i].getCallerLineNumber() + 1, frameCt, rName);
            --frameCt;
            sName = layers[i].getCalledFileName();
            rName = remoteDebugger.convertToLocalFilename(sName, cwd, rName);
            if (rName == null) {
                rName = sName;
            }
            frames[frameCt - 1] = new PHPStackFrame(thread, sName, layers[i].getCalledFunctionName(), layers[i].getCalledLineNumber() + 1, frameCt, layers[i], rName);
            --frameCt;
            if (!layers[i].getCalledFileName().equals(this.fTarget.getLastFileName())) {
                currentScript = rName;
            }
            ++i;
        }
        String resolvedFile = remoteDebugger.convertToLocalFilename(this.fTarget.getLastFileName(), cwd, currentScript);
        if (resolvedFile == null) {
            resolvedFile = this.fTarget.getLastFileName();
        }
        frames[0] = new PHPStackFrame(thread, this.fTarget.getLastFileName(), layers.length == 1 ? "" : frames[1].getName(), this.fTarget.getLastStop(), frameCt, resolvedFile);
        this.fPreviousLayers = layers;
        return frames;
    }

    private void createStackVariables(StackLayer[] layers) {
        this.fStackVariables.clear();
        StackLayer[] stackLayerArray = layers;
        int n = layers.length;
        int n2 = 0;
        while (n2 < n) {
            StackLayer element = stackLayerArray[n2];
            Expression[] stackVariables = element.getVariables();
            if (stackVariables.length != 0) {
                String key = String.valueOf(element.getCalledFunctionName()) + element.getCalledFileName();
                this.fStackVariables.put(key, stackVariables);
            }
            ++n2;
        }
    }

    private IVariable[] createVariables(boolean main, boolean update, boolean clear) {
        IVariable[] variables;
        DefaultExpressionsManager expressionsManager = this.fTarget.getExpressionManager();
        if (expressionsManager == null) {
            return new IVariable[0];
        }
        if (clear) {
            expressionsManager.clear();
        }
        Expression[] localVariables = expressionsManager.getLocalVariables(1);
        Expression[] GlobalVariables = expressionsManager.getGlobalVariables(1);
        if (main) {
            variables = new PHPVariable[localVariables.length];
            int i = 0;
            while (i < localVariables.length) {
                variables[i] = new PHPVariable(this.fTarget, localVariables[i]);
                ++i;
            }
        } else {
            variables = new PHPVariable[localVariables.length + 1];
            int i = 0;
            while (i < localVariables.length) {
                variables[i + 1] = new PHPVariable(this.fTarget, localVariables[i]);
                ++i;
            }
            String global = "$GLOBALS";
            DefaultExpression gExp = new DefaultExpression(global);
            String sArray = "Array";
            String sArrayAsString = String.valueOf(sArray) + " [" + new Integer(GlobalVariables.length).toString() + "]";
            ExpressionValue gEValue = new ExpressionValue(5, sArray, sArrayAsString, GlobalVariables);
            gExp.setValue(gEValue);
            variables[0] = new PHPVariable(this.fTarget, gExp, true);
        }
        return variables;
    }

    public IRemoteDebugger getRemoteDebugger() {
        return this.fDebugger;
    }
}

