/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.explorer;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.internal.ui.preferences.PreferenceConstants;
import org.eclipse.php.ui.actions.OccurrencesSearchGroup;
import org.eclipse.search.internal.ui.OpenSearchDialogAction;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;

public class PHPSearchActionGroup
extends ActionGroup {
    private OpenSearchDialogAction action;
    private OccurrencesSearchGroup fOccurrencesGroup;
    private final PHPStructuredEditor fEditor;

    public PHPSearchActionGroup(PHPStructuredEditor editor) {
        Assert.isNotNull((Object)editor);
        this.fEditor = editor;
        this.action = new OpenSearchDialogAction();
        this.fOccurrencesGroup = new OccurrencesSearchGroup(editor);
    }

    public PHPSearchActionGroup(IWorkbenchSite site) {
        this.fEditor = null;
        this.action = new OpenSearchDialogAction();
        this.fOccurrencesGroup = new OccurrencesSearchGroup(site);
    }

    public void setContext(ActionContext context) {
        this.fOccurrencesGroup.setContext(context);
        super.setContext(context);
    }

    public void fillActionBars(IActionBars actionBar) {
        this.fOccurrencesGroup.fillActionBars(actionBar);
        super.fillActionBars(actionBar);
    }

    public void fillContextMenu(IMenuManager menu) {
        IContributionItem item;
        super.fillContextMenu(menu);
        if (!PreferenceConstants.getPreferenceStore().getBoolean("Search.usereducemenu")) {
            IMenuManager target = menu;
            MenuManager searchSubMenu = null;
            if (this.fEditor != null) {
                String groupName = "SearchMessages.group_search";
                searchSubMenu = new MenuManager(groupName, "group.find");
                searchSubMenu.add((IContributionItem)new GroupMarker("group.find"));
                target = searchSubMenu;
            }
            if (searchSubMenu != null) {
                this.fOccurrencesGroup.fillContextMenu(target);
                searchSubMenu.add((IContributionItem)new Separator());
            }
            if (searchSubMenu != null && searchSubMenu.getItems().length > 2) {
                menu.appendToGroup("group.find", (IContributionItem)searchSubMenu);
            }
        }
        if ((item = menu.find("group.open")) != null) {
            menu.appendToGroup("group.open", (IAction)this.action);
        }
    }

    public void dispose() {
        this.fOccurrencesGroup.dispose();
        super.dispose();
    }
}

