/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.server.ui.launching;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.php.internal.core.documentModel.provisional.contenttype.ContentTypeIdForPHP;
import org.eclipse.php.internal.core.util.FileUtils;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.debugger.AbstractDebuggerConfiguration;
import org.eclipse.php.internal.debug.core.preferences.PHPDebugCorePreferenceNames;
import org.eclipse.php.internal.debug.core.preferences.PHPDebuggersRegistry;
import org.eclipse.php.internal.debug.core.preferences.PHPProjectPreferences;
import org.eclipse.php.internal.debug.ui.Logger;
import org.eclipse.php.internal.debug.ui.PHPDebugUIMessages;
import org.eclipse.php.internal.debug.ui.PHPDebugUIPlugin;
import org.eclipse.php.internal.server.core.Server;
import org.eclipse.php.internal.server.core.manager.ServersManager;
import org.eclipse.php.internal.server.ui.launching.PHPWebPageLaunchDialog;
import org.eclipse.php.internal.server.ui.launching.PHPWebPageURLLaunchDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;

public class PHPWebPageLaunchShortcut
implements ILaunchShortcut {
    public void launch(ISelection selection, String mode) {
        if (selection instanceof IStructuredSelection) {
            PHPWebPageLaunchShortcut.searchAndLaunch(((IStructuredSelection)selection).toArray(), mode, this.getPHPServerLaunchConfigType());
        }
    }

    public void launch(IEditorPart editor, String mode) {
        IEditorInput input = editor.getEditorInput();
        IFile file = (IFile)input.getAdapter(IFile.class);
        if (file != null) {
            PHPWebPageLaunchShortcut.searchAndLaunch(new Object[]{file}, mode, this.getPHPServerLaunchConfigType());
        }
    }

    private ILaunchConfigurationType getPHPServerLaunchConfigType() {
        ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
        return lm.getLaunchConfigurationType("org.eclipse.php.debug.core.launching.webPageLaunch");
    }

    public static void searchAndLaunch(Object[] search, String mode, ILaunchConfigurationType configType) {
        int entries = search == null ? 0 : search.length;
        int i = 0;
        while (i < entries) {
            block18: {
                try {
                    Server defaultServer;
                    String phpPathString = null;
                    IProject project = null;
                    Object obj = search[i];
                    if (obj instanceof IModelElement) {
                        IModelElement elem = (IModelElement)obj;
                        IResource res = null;
                        if (elem instanceof ISourceModule) {
                            res = ((ISourceModule)elem).getCorrespondingResource();
                        } else if (elem instanceof IType) {
                            res = ((IType)elem).getUnderlyingResource();
                        } else if (elem instanceof IMethod) {
                            res = ((IMethod)elem).getUnderlyingResource();
                        }
                        if (res instanceof IFile) {
                            obj = (IFile)res;
                        }
                    }
                    if (obj instanceof IFile) {
                        IFile file = (IFile)obj;
                        project = file.getProject();
                        IContentType contentType = Platform.getContentTypeManager().getContentType(ContentTypeIdForPHP.ContentTypeID_PHP);
                        if (contentType.isAssociatedWith(file.getName())) {
                            phpPathString = file.getFullPath().toString();
                        }
                    }
                    if ((defaultServer = ServersManager.getDefaultServer(project)) == null) {
                        PHPDebugPlugin.createDefaultPHPServer();
                        defaultServer = ServersManager.getDefaultServer((IProject)project);
                        if (defaultServer == null) {
                            throw new CoreException((IStatus)new Status(4, "org.eclipse.php.debug.ui", 0, "Could not create a defualt server for the launch.", null));
                        }
                    }
                    boolean breakAtFirstLine = PHPProjectPreferences.getStopAtFirstLine((IProject)project);
                    String selectedURL = null;
                    boolean showDebugDialog = true;
                    if (obj instanceof IScriptProject) {
                        PHPWebPageLaunchDialog dialog = new PHPWebPageLaunchDialog(mode, (IScriptProject)obj);
                        int open = dialog.open();
                        if (open != 0) break block18;
                        defaultServer = dialog.getServer();
                        selectedURL = dialog.getPhpPathString();
                        phpPathString = dialog.getFilename();
                        breakAtFirstLine = dialog.isBreakAtFirstLine();
                        showDebugDialog = false;
                    }
                    if (phpPathString == null) {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.php.debug.ui", 0, PHPDebugUIMessages.launch_failure_no_target, null));
                    }
                    ILaunchConfiguration config = PHPWebPageLaunchShortcut.findLaunchConfiguration(project, phpPathString, selectedURL, defaultServer, mode, configType, breakAtFirstLine, showDebugDialog);
                    if (config != null) {
                        DebugUITools.launch((ILaunchConfiguration)config, (String)mode);
                    }
                }
                catch (CoreException ce) {
                    final IStatus stat = ce.getStatus();
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            ErrorDialog.openError((Shell)PHPDebugUIPlugin.getActiveWorkbenchShell(), (String)PHPDebugUIMessages.launch_failure_msg_title, (String)PHPDebugUIMessages.launch_failure_server_msg_text, (IStatus)stat);
                        }
                    });
                }
            }
            ++i;
        }
    }

    static ILaunchConfiguration findLaunchConfiguration(IProject project, String fileName, String selectedURL, Server server, String mode, ILaunchConfigurationType configType, boolean breakAtFirstLine, boolean showDebugDialog) {
        ILaunchConfiguration config = null;
        try {
            ILaunchConfiguration[] configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(configType);
            int numConfigs = configs == null ? 0 : configs.length;
            int i = 0;
            while (i < numConfigs) {
                String configuredServerName = configs[i].getAttribute("name", null);
                String configuredFileName = configs[i].getAttribute("file_name", null);
                if (configuredFileName.equals(fileName) && server.getName().equals(configuredServerName)) {
                    config = configs[i].getWorkingCopy();
                    break;
                }
                ++i;
            }
            if (config == null) {
                config = PHPWebPageLaunchShortcut.createConfiguration(project, fileName, selectedURL, server, configType, mode, breakAtFirstLine, showDebugDialog);
            }
        }
        catch (CoreException ce) {
            ce.printStackTrace();
        }
        return config;
    }

    static String computeContextRoot(String url, String fileName, Server server) {
        String serverBaseURL = server.getBaseURL();
        if (url.length() > serverBaseURL.length() + 1) {
            url = url.substring(serverBaseURL.length() + 1);
        } else if (url.length() == serverBaseURL.length() || url.length() == serverBaseURL.length() + 1) {
            return "";
        }
        if (fileName.length() > 0) {
            int pathIndex = (fileName = fileName.substring(1)).indexOf(47);
            fileName = pathIndex < 0 ? "" : fileName.substring(pathIndex);
        }
        if (url.length() <= fileName.length()) {
            return "";
        }
        url = url.substring(0, url.length() - fileName.length());
        return url;
    }

    static ILaunchConfiguration createConfiguration(IProject project, String fileName, String selectedURL, Server server, ILaunchConfigurationType configType, String mode, boolean breakAtFirstLine, boolean showDebugDialog) throws CoreException {
        ILaunchConfiguration config = null;
        if (!FileUtils.resourceExists((String)fileName)) {
            return null;
        }
        String URL2 = null;
        URL2 = selectedURL != null ? selectedURL : String.valueOf(server.getBaseURL()) + new Path(fileName).toString();
        ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, PHPWebPageLaunchShortcut.getNewConfigurationName(fileName));
        String debuggerID = PHPProjectPreferences.getDefaultDebuggerID((IProject)project);
        wc.setAttribute(PHPDebugCorePreferenceNames.PHP_DEBUGGER_ID, debuggerID);
        AbstractDebuggerConfiguration debuggerConfiguration = PHPDebuggersRegistry.getDebuggerConfiguration((String)debuggerID);
        wc.setAttribute(PHPDebugCorePreferenceNames.CONFIGURATION_DELEGATE_CLASS, debuggerConfiguration.getWebLaunchDelegateClass());
        wc.setAttribute("name", server.getName());
        wc.setAttribute("file_name", fileName);
        wc.setAttribute("base_url", URL2);
        wc.setAttribute("org.eclipse.php.debug.core.RunWithDebugInfo", PHPDebugPlugin.getDebugInfoOption());
        wc.setAttribute("org.eclipse.php.debug.core.OpenInBrowser", PHPDebugPlugin.getOpenInBrowserOption());
        wc.setAttribute("firstLineBreakpoint", breakAtFirstLine);
        if (showDebugDialog) {
            String title = "debug".equals(mode) ? "Debug PHP Web Page" : ("profile".equals(mode) ? "Profile PHP Web Page" : "Run PHP Web Page");
            PHPWebPageURLLaunchDialog launchDialog = new PHPWebPageURLLaunchDialog(wc, server, title);
            launchDialog.setBlockOnOpen(true);
            if (launchDialog.open() == 1) {
                return null;
            }
        }
        config = wc.doSave();
        return config;
    }

    protected static String getNewConfigurationName(String fileName) {
        String configurationName = "New_configuration";
        try {
            IPath path = Path.fromOSString((String)fileName);
            String fileExtention = path.getFileExtension();
            String lastSegment = path.lastSegment();
            if (lastSegment != null) {
                if (fileExtention != null) {
                    lastSegment = lastSegment.replaceFirst("." + fileExtention, "");
                }
                configurationName = lastSegment;
            }
        }
        catch (Exception e) {
            Logger.log((int)202, (String)("Could not generate configuration name for " + fileName + ".\nThe default name will be used."), (Throwable)e);
        }
        return DebugPlugin.getDefault().getLaunchManager().generateUniqueLaunchConfigurationNameFrom(configurationName);
    }
}

