/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.wizards;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.preferences.PHPVersionConfigurationBlock;
import org.eclipse.php.internal.ui.wizards.PHPVersionGroup;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizardPage;
import org.eclipse.wst.common.frameworks.internal.operations.IProjectCreationPropertiesNew;
import org.eclipse.wst.common.frameworks.internal.ui.NewProjectGroup;

public class PHPProjectWizardBasePage
extends DataModelWizardPage
implements IProjectCreationPropertiesNew {
    protected NewProjectGroup projectNameGroup;
    protected PHPVersionGroup fVersionGroup;
    protected JavaScriptSupportGroup fJavaScriptSupportGroup;

    public PHPProjectWizardBasePage(IDataModel dataModel, String pageName) {
        super(dataModel, pageName);
        this.setTitle(PHPUIMessages.getString("PHPProjectWizardBasePage.0"));
        this.setDescription(PHPUIMessages.getString("PHPProjectWizardBasePage.1"));
        this.setPageComplete(false);
    }

    protected void setSize(Composite composite) {
        if (composite != null) {
            Point minSize = composite.computeSize(-1, -1);
            composite.setSize(minSize);
            if (composite.getParent() instanceof ScrolledComposite) {
                ScrolledComposite sc1 = (ScrolledComposite)composite.getParent();
                sc1.setMinSize(minSize);
                sc1.setExpandHorizontal(true);
                sc1.setExpandVertical(true);
            }
        }
    }

    protected String[] getValidationPropertyNames() {
        return new String[]{"IProjectCreationPropertiesNew.PROJECT_NAME", "IProjectCreationPropertiesNew.PROJECT_LOCATION"};
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite top = new Composite(parent, 0);
        top.setLayout((Layout)new GridLayout(1, true));
        top.setLayoutData((Object)new GridData(1808));
        this.createProjectNameGroup(top);
        this.createProjectOptionsGroup(top);
        this.createJavaScriptSupportGroup(top);
        this.setHelpContext(top);
        return top;
    }

    protected void setHelpContext(Composite top) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)top, "org.eclipse.php.help.creating_projects_and_files");
    }

    protected void createProjectNameGroup(Composite parent) {
        this.projectNameGroup = new NewProjectGroup(parent, this.model);
    }

    protected void createProjectOptionsGroup(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        composite.setLayout((Layout)layout);
        this.fVersionGroup = new PHPVersionGroup(parent, (WizardPage)this);
    }

    protected void createJavaScriptSupportGroup(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        composite.setLayout((Layout)layout);
        this.fJavaScriptSupportGroup = new JavaScriptSupportGroup(parent, this);
    }

    public void setProjectOptionInModel(IDataModel model) {
        this.fVersionGroup.setPropertiesInDataModel(model);
        this.fJavaScriptSupportGroup.setPropertiesInDataModel(model);
    }

    public PHPVersionConfigurationBlock getPHPVersionBlock() {
        return this.fVersionGroup.getVersionBlock();
    }

    public void setInitialProjectName(String name) {
        this.projectNameGroup.projectNameField.setText(name);
    }

    public class JavaScriptSupportGroup {
        private final Group fGroup;
        protected Button fEnableJavaScriptSupport;

        public JavaScriptSupportGroup(Composite composite, PHPProjectWizardBasePage page) {
            this.fGroup = new Group(composite, 0);
            this.fGroup.setFont(composite.getFont());
            GridLayout layout = new GridLayout();
            this.fGroup.setLayout((Layout)layout);
            GridData data = new GridData(1808);
            this.fGroup.setLayoutData((Object)data);
            this.fGroup.setText(PHPUIMessages.getString("JavaScriptSupportGroup_OptionBlockTitle"));
            Composite checkLinkComposite = new Composite((Composite)this.fGroup, 0);
            checkLinkComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            checkLinkComposite.setLayout((Layout)new GridLayout(2, false));
            this.fEnableJavaScriptSupport = new Button(checkLinkComposite, 131104);
            this.fEnableJavaScriptSupport.setText(PHPUIMessages.getString("JavaScriptSupportGroup_EnableSupport"));
            this.fEnableJavaScriptSupport.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            this.fEnableJavaScriptSupport.setSelection(PHPProjectWizardBasePage.this.model.getBooleanProperty("org.eclipse.php.core.addJsNature"));
        }

        public void setPropertiesInDataModel(IDataModel model) {
            model.setBooleanProperty("org.eclipse.php.core.addJsNature", this.fEnableJavaScriptSupport.getSelection());
        }
    }
}

