/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.corext.dom;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.ClassDeclaration;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.FunctionDeclaration;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.InterfaceDeclaration;
import org.eclipse.php.internal.core.ast.nodes.MethodDeclaration;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.ast.nodes.Variable;
import org.eclipse.php.internal.core.ast.visitor.AbstractVisitor;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class LocalVariableIndex
extends AbstractVisitor {
    private int fTopIndex;
    private static boolean isProgramScope = false;
    private final Set<String> variablesSet = new HashSet<String>();

    public static int perform(ASTNode node) {
        Assert.isTrue((node != null ? 1 : 0) != 0);
        switch (node.getType()) {
            case 42: {
                isProgramScope = false;
                return LocalVariableIndex.internalPerform((ASTNode)((MethodDeclaration)node).getFunction());
            }
            case 29: {
                isProgramScope = false;
                return LocalVariableIndex.internalPerform((ASTNode)((FunctionDeclaration)node));
            }
            case 46: {
                isProgramScope = true;
                return LocalVariableIndex.internalPerform((ASTNode)((Program)node));
            }
        }
        Assert.isTrue((boolean)false);
        return -1;
    }

    private static int internalPerform(ASTNode node) {
        LocalVariableIndex counter = new LocalVariableIndex();
        node.accept((Visitor)counter);
        return counter.fTopIndex;
    }

    public boolean visit(Variable variable) {
        String variableName;
        Expression name = variable.getName();
        if (variable.isDollared() && name.getType() == 33 && !(variableName = ((Identifier)name).getName()).equalsIgnoreCase("this") && !this.variablesSet.contains(variableName)) {
            this.variablesSet.add(variableName);
            this.handleVariableBinding();
        }
        return true;
    }

    public boolean visit(FunctionDeclaration function) {
        return !isProgramScope;
    }

    public boolean visit(ClassDeclaration classDeclaration) {
        return !isProgramScope;
    }

    public boolean visit(InterfaceDeclaration interfaceDeclaration) {
        return !isProgramScope;
    }

    private void handleVariableBinding() {
        this.fTopIndex = this.variablesSet.size();
    }
}

