/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.debugger;

import org.eclipse.core.runtime.Path;

public class DebugError
implements Cloneable {
    public static final int DEFAULT_ID = -1;
    private int id = -1;
    private int code = 1;
    private String fileName = "";
    private int lineNumber = -1;
    private String text = "";
    private static String[] codeToName = new String[]{"Debug Error", "Debug Warning", "Parsing Error", "Notice", "Fatal Error", "Core Warning", "Compile Error", "Compile Warning", "User Error", "User Warning", "User Notice", "Debug Strict (PHP 5)"};

    public static boolean isNotice(DebugError debugError) {
        int errorIndex = DebugError.getErrorIndex(debugError.getCode());
        return errorIndex == 3 || errorIndex == 10;
    }

    public static boolean isWarning(DebugError debugError) {
        int errorIndex = DebugError.getErrorIndex(debugError.getCode());
        return errorIndex == 1 || errorIndex == 5 || errorIndex == 7 || errorIndex == 9;
    }

    public static boolean isError(DebugError debugError) {
        int errorIndex = DebugError.getErrorIndex(debugError.getCode());
        return errorIndex == 0 || errorIndex == 2 || errorIndex == 4 || errorIndex == 6 || errorIndex == 8;
    }

    public static boolean isStrict(DebugError debugError) {
        int errorIndex = DebugError.getErrorIndex(debugError.getCode());
        return errorIndex == 11;
    }

    private static int getErrorIndex(int code) {
        int index = (int)(Math.log(code) / Math.log(2.0));
        return index;
    }

    private static String getErrorName(int code) {
        int index = DebugError.getErrorIndex(code);
        if (index < codeToName.length) {
            return codeToName[index];
        }
        return codeToName[3];
    }

    public DebugError() {
    }

    public DebugError(int code, String fileName, int lineNumber, String text) {
        this();
        this.code = code;
        this.fileName = fileName;
        this.lineNumber = lineNumber;
        this.text = text;
    }

    public void setID(int id) {
        this.id = id;
    }

    public int getID() {
        return this.id;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public String getCodeName() {
        return DebugError.getErrorName(this.code);
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileDisplayName() {
        Path filePath = new Path(this.fileName);
        if (filePath.segmentCount() > 1 && filePath.segment(filePath.segmentCount() - 2).equals("Untitled_Documents")) {
            return filePath.lastSegment();
        }
        return this.fileName;
    }

    public String getFullPathName() {
        return this.fileName;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setErrorText(String text) {
        this.text = text;
    }

    public String getErrorText() {
        return this.text;
    }

    public Object clone() throws CloneNotSupportedException {
        return (DebugError)super.clone();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getCodeName());
        if (this.lineNumber >= 0) {
            buffer.append(": ");
            buffer.append(this.getFileDisplayName());
            buffer.append(" line ");
            buffer.append(this.lineNumber);
        }
        buffer.append(" - " + this.getErrorText());
        return buffer.toString();
    }

    public int getErrorTextLength() {
        return (" - " + this.getErrorText()).length();
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof DebugError) {
            DebugError other = (DebugError)obj;
            result = this.code == other.code && this.fileName.equals(other.fileName) && this.lineNumber == other.lineNumber && this.text.equals(other.text);
        }
        return result;
    }
}

