/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.model;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.php.internal.debug.core.model.PHPDebugElement;
import org.eclipse.php.internal.debug.core.zend.debugger.Expression;
import org.eclipse.php.internal.debug.core.zend.debugger.StackLayer;
import org.eclipse.php.internal.debug.core.zend.model.PHPDebugTarget;
import org.eclipse.php.internal.debug.core.zend.model.PHPThread;

public class PHPStackFrame
extends PHPDebugElement
implements IStackFrame {
    private static final Pattern LAMBDA_FUNC_PATTERN = Pattern.compile("(.*)\\((\\d+)\\) : runtime-created function");
    private PHPThread fThread;
    private String fName;
    private String fFileName;
    private int fPC;
    private int fId;
    private String fResName;

    public PHPStackFrame(IThread thread, String fileName, String funcName, int lineNumber, int id, String rName) {
        super((PHPDebugTarget)thread.getDebugTarget());
        this.baseInit(thread, fileName, funcName, lineNumber, id, rName);
    }

    private void baseInit(IThread thread, String fileName, String funcName, int lineNumber, int id, String rName) {
        Matcher matcher = LAMBDA_FUNC_PATTERN.matcher(fileName);
        if (matcher.matches()) {
            fileName = matcher.group(1);
            lineNumber = Integer.parseInt(matcher.group(2));
        }
        this.fName = funcName;
        this.fFileName = fileName;
        this.fPC = lineNumber;
        this.fId = id;
        this.fThread = (PHPThread)thread;
        this.fResName = rName;
    }

    public PHPStackFrame(IThread thread, String fileName, String funcName, int lineNumber, int id, StackLayer layer, String rName) {
        super((PHPDebugTarget)thread.getDebugTarget());
        this.baseInit(thread, fileName, funcName, lineNumber, id, rName);
    }

    public IThread getThread() {
        return this.fThread;
    }

    public IVariable[] getVariables() throws DebugException {
        return ((PHPDebugTarget)this.getDebugTarget()).getVariables();
    }

    public boolean hasVariables() throws DebugException {
        return ((PHPDebugTarget)this.getDebugTarget()).getVariables().length > 0;
    }

    public int getLineNumber() throws DebugException {
        return this.fPC;
    }

    public int checkLineNumber() throws DebugException {
        return this.fPC;
    }

    public int getCharStart() throws DebugException {
        return -1;
    }

    public int getCharEnd() throws DebugException {
        return -1;
    }

    public String getName() throws DebugException {
        return this.fName;
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        return new IRegisterGroup[0];
    }

    public boolean hasRegisterGroups() throws DebugException {
        return false;
    }

    public boolean canStepInto() {
        return this.getThread().canStepInto();
    }

    public boolean canStepOver() {
        return this.getThread().canStepOver();
    }

    public boolean canStepReturn() {
        return this.getThread().canStepReturn();
    }

    public boolean isStepping() {
        return this.getThread().isStepping();
    }

    public void stepInto() throws DebugException {
        this.getThread().stepInto();
    }

    public void stepOver() throws DebugException {
        this.getThread().stepOver();
    }

    public void stepReturn() throws DebugException {
        this.getThread().stepReturn();
    }

    public boolean canResume() {
        return this.getThread().canResume();
    }

    public boolean canSuspend() {
        return this.getThread().canSuspend();
    }

    public boolean isSuspended() {
        return this.getThread().isSuspended();
    }

    public void resume() throws DebugException {
        this.getThread().resume();
    }

    public void suspend() throws DebugException {
        this.getThread().suspend();
    }

    public boolean canTerminate() {
        return this.getThread().canTerminate();
    }

    public boolean isTerminated() {
        return this.getThread().isTerminated();
    }

    public void terminate() throws DebugException {
        this.getThread().terminate();
    }

    public String getSourceName() {
        return this.fResName;
    }

    public String getAbsoluteFileName() {
        return this.fFileName;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof PHPStackFrame) {
            PHPStackFrame sf = (PHPStackFrame)((Object)obj);
            try {
                return sf.fId == this.fId && sf.getSourceName().equals(this.getSourceName()) && sf.getName().equals(this.getName());
            }
            catch (DebugException debugException) {}
        }
        return false;
    }

    public int hashCode() {
        return this.getSourceName().hashCode() + ((Object)((Object)this.fThread)).hashCode();
    }

    protected int getIdentifier() {
        return this.fId;
    }

    public Expression[] getStackVariables() {
        return ((PHPDebugTarget)this.getDebugTarget()).getStackVariables(this);
    }
}

