/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.preferences.PHPPreferencePageBlocksRegistry;
import org.eclipse.php.internal.ui.preferences.ScrolledCompositeImpl;
import org.eclipse.php.ui.preferences.IPHPPreferencePageBlock;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceSorter;

public abstract class AbstractPHPPropertyPreferencePage
extends PropertyPage
implements IWorkbenchPreferencePage {
    private static final Object DISABLE_LINK = "DISABLE_LINK";
    protected Map fData = null;
    protected Button fEnableProjectSettings;
    private Link fProjectSettingsLink;
    protected IPHPPreferencePageBlock[] projectScopeAddons;
    protected IPHPPreferencePageBlock[] workspaceAddons;

    public final void applyData(Object data) {
        super.applyData(data);
        if (data instanceof Map) {
            this.fData = (Map)data;
            this.updateLinkEnablement();
        }
    }

    protected Control createWorkspaceContents(Composite composite) {
        ScrolledCompositeImpl scrolledCompositeImpl = new ScrolledCompositeImpl(composite, 768);
        Composite group = new Composite((Composite)scrolledCompositeImpl, 0);
        group.setLayout((Layout)new GridLayout());
        try {
            this.workspaceAddons = PHPPreferencePageBlocksRegistry.getPHPPreferencePageBlock(this.getPreferencePageID());
            int i = 0;
            while (i < this.workspaceAddons.length) {
                this.workspaceAddons[i].setCompositeAddon(group);
                this.workspaceAddons[i].initializeValues((PreferencePage)this);
                ++i;
            }
            scrolledCompositeImpl.setContent((Control)group);
        }
        catch (Exception e) {
            PHPUiPlugin.log(e);
        }
        return scrolledCompositeImpl;
    }

    protected Control createProjectContents(Composite composite) {
        ScrolledCompositeImpl scrolledCompositeImpl = new ScrolledCompositeImpl(composite, 768);
        Composite group = new Composite((Composite)scrolledCompositeImpl, 0);
        group.setLayout((Layout)new GridLayout());
        try {
            this.projectScopeAddons = PHPPreferencePageBlocksRegistry.getPHPPreferencePageBlock(this.getPropertyPageID());
            int i = 0;
            while (i < this.projectScopeAddons.length) {
                this.projectScopeAddons[i].setCompositeAddon(group);
                this.projectScopeAddons[i].initializeValues((PreferencePage)this);
                ++i;
            }
            scrolledCompositeImpl.setContent((Control)group);
        }
        catch (Exception e) {
            PHPUiPlugin.log(e);
        }
        return scrolledCompositeImpl;
    }

    public final Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        Composite checkLinkComposite = new Composite(composite, 0);
        checkLinkComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        checkLinkComposite.setLayout((Layout)new GridLayout(2, false));
        if (this.getProject() != null) {
            this.fEnableProjectSettings = new Button(checkLinkComposite, 32);
            this.fEnableProjectSettings.setText(PHPUIMessages.getString("AbstractPHPPropertyPreferencePage.0"));
            this.fEnableProjectSettings.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            boolean enabledForProject = this.createPreferenceScopes()[0].getNode(this.getPreferenceNodeQualifier()).getBoolean(this.getProjectSettingsKey(), false);
            this.fEnableProjectSettings.setSelection(enabledForProject);
        } else {
            Label spacer = new Label(checkLinkComposite, 32);
            spacer.setLayoutData((Object)new GridData());
        }
        this.fProjectSettingsLink = new Link(checkLinkComposite, 0);
        this.fProjectSettingsLink.setFont(composite.getFont());
        this.fProjectSettingsLink.setLayoutData((Object)new GridData(0x1000008, 1, true, false));
        if (this.getProject() != null) {
            this.fProjectSettingsLink.setText("<a>" + PHPUIMessages.getString("AbstractPHPPropertyPreferencePage.1") + "</a>");
        } else {
            this.fProjectSettingsLink.setText("<a>" + PHPUIMessages.getString("AbstractPHPPropertyPreferencePage.2") + "</a>");
        }
        this.updateLinkEnablement();
        this.fProjectSettingsLink.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                if (AbstractPHPPropertyPreferencePage.this.getProject() == null) {
                    AbstractPHPPropertyPreferencePage.this.openProjectSettings();
                } else {
                    AbstractPHPPropertyPreferencePage.this.openWorkspaceSettings();
                }
            }
        });
        if (this.getProject() != null) {
            Label line = new Label(composite, 258);
            line.setLayoutData((Object)new GridData(256));
        }
        final Control common = this.createProjectContents(composite);
        common.setLayoutData((Object)new GridData(256));
        if (this.fEnableProjectSettings == null) {
            Control workspaceControls = this.createWorkspaceContents(composite);
            workspaceControls.setLayoutData((Object)new GridData(1808));
        } else {
            SelectionAdapter selectionAdapter = new SelectionAdapter(){
                ControlEnableState enablements = null;

                public void widgetSelected(SelectionEvent e) {
                    super.widgetSelected(e);
                    if (AbstractPHPPropertyPreferencePage.this.fEnableProjectSettings.getSelection()) {
                        if (this.enablements != null) {
                            this.enablements.restore();
                            this.enablements = null;
                        }
                    } else {
                        this.enablements = ControlEnableState.disable((Control)common);
                    }
                }
            };
            selectionAdapter.widgetSelected(null);
            this.fEnableProjectSettings.addSelectionListener((SelectionListener)selectionAdapter);
        }
        return composite;
    }

    public void createControl(Composite parent) {
        if (this.getProject() != null) {
            this.noDefaultAndApplyButton();
        }
        super.createControl(parent);
    }

    protected IScopeContext[] createPreferenceScopes() {
        IProject project = this.getProject();
        if (project != null) {
            return new IScopeContext[]{new ProjectScope(project), new InstanceScope(), new DefaultScope()};
        }
        return new IScopeContext[]{new InstanceScope(), new DefaultScope()};
    }

    protected abstract String getPreferenceNodeQualifier();

    protected abstract String getPreferencePageID();

    protected IProject getProject() {
        IAdaptable element = this.getElement();
        if (element != null) {
            if (element instanceof IProject) {
                return (IProject)element;
            }
            if (element instanceof IScriptProject) {
                return ((IScriptProject)element).getProject();
            }
        }
        return null;
    }

    protected abstract String getProjectSettingsKey();

    protected abstract String getPropertyPageID();

    protected boolean isElementSettingsEnabled() {
        return this.fEnableProjectSettings != null && this.fEnableProjectSettings.getSelection();
    }

    void openProjectSettings() {
        Object[] result;
        ListDialog dialog = new ListDialog(this.getShell()){

            protected Control createDialogArea(Composite container) {
                Control area = super.createDialogArea(container);
                this.getTableViewer().setSorter((ViewerSorter)new ResourceSorter(1));
                return area;
            }
        };
        dialog.setMessage(PHPUIMessages.getString("AbstractPHPPropertyPreferencePage.3"));
        dialog.setContentProvider(new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return ((IWorkspace)inputElement).getRoot().getProjects();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        dialog.setLabelProvider((ILabelProvider)new DecoratingLabelProvider((ILabelProvider)new WorkbenchLabelProvider(), PHPUiPlugin.getDefault().getWorkbench().getDecoratorManager().getLabelDecorator()));
        dialog.setInput((Object)ResourcesPlugin.getWorkspace());
        dialog.setTitle(PHPUIMessages.getString("AbstractPHPPropertyPreferencePage.4"));
        if (dialog.open() == 0 && (result = dialog.getResult()).length > 0) {
            IProject project = (IProject)dialog.getResult()[0];
            HashMap<Object, Boolean> data = new HashMap<Object, Boolean>();
            data.put(DISABLE_LINK, Boolean.TRUE);
            PreferencesUtil.createPropertyDialogOn((Shell)this.getShell(), (IAdaptable)project, (String)this.getPropertyPageID(), (String[])new String[]{this.getPropertyPageID()}, data).open();
        }
    }

    void openWorkspaceSettings() {
        HashMap<Object, Boolean> data = new HashMap<Object, Boolean>();
        data.put(DISABLE_LINK, Boolean.TRUE);
        PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)this.getPreferencePageID(), (String[])new String[]{this.getPreferencePageID()}, data).open();
    }

    public boolean performOk() {
        int i;
        boolean ok = super.performOk();
        IScopeContext[] preferenceScopes = this.createPreferenceScopes();
        if (this.getProject() != null) {
            if (this.isElementSettingsEnabled()) {
                preferenceScopes[0].getNode(this.getPreferenceNodeQualifier()).putBoolean(this.getProjectSettingsKey(), this.fEnableProjectSettings.getSelection());
            } else {
                preferenceScopes[0].getNode(this.getPreferenceNodeQualifier()).remove(this.getProjectSettingsKey());
            }
        }
        if (this.projectScopeAddons != null) {
            i = 0;
            while (i < this.projectScopeAddons.length) {
                this.projectScopeAddons[i].performOK(this.isElementSettingsEnabled());
                ++i;
            }
        }
        if (this.workspaceAddons != null) {
            i = 0;
            while (i < this.workspaceAddons.length) {
                this.workspaceAddons[i].performOK(false);
                ++i;
            }
        }
        return ok;
    }

    public void performDefaults() {
        int i;
        if (this.projectScopeAddons != null) {
            i = 0;
            while (i < this.projectScopeAddons.length) {
                this.projectScopeAddons[i].performDefaults();
                ++i;
            }
        }
        if (this.workspaceAddons != null) {
            i = 0;
            while (i < this.workspaceAddons.length) {
                this.workspaceAddons[i].performDefaults();
                ++i;
            }
        }
        super.performDefaults();
    }

    public void performApply() {
        super.performApply();
    }

    private void updateLinkEnablement() {
        if (this.fData != null && this.fProjectSettingsLink != null) {
            this.fProjectSettingsLink.setEnabled(!Boolean.TRUE.equals(this.fData.get(DISABLE_LINK)));
        }
    }
}

