/* The following code was generated by JFlex 1.4.1 on 7/14/09 6:51 AM */

/*******************************************************************************
 * Copyright (c) 2006 Zend Corporation and IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Zend and IBM - Initial implementation
 *******************************************************************************/

package org.eclipse.php.internal.core.ast.scanner.php5;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

import org.eclipse.php.internal.core.ast.nodes.IDocumentorLexer;
import org.eclipse.php.internal.core.ast.nodes.Comment;
import java_cup.sym;
import org.eclipse.php.internal.core.ast.nodes.AST;
import java_cup.runtime.Symbol;
import org.eclipse.php.internal.core.phpModel.parser.StateStack;
import org.eclipse.php.internal.core.PHPVersion;


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.1
 * on 7/14/09 6:51 AM from the specification file
 * <tt>ast_scanner.flex</tt>
 */
public class PhpAstLexer implements org.eclipse.php.internal.core.ast.scanner.AstLexer {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int ST_DOCBLOCK = 11;
  public static final int ST_IN_SCRIPTING = 1;
  public static final int ST_LOOKING_FOR_PROPERTY = 7;
  public static final int ST_ONE_LINE_COMMENT = 12;
  public static final int ST_COMMENT = 10;
  public static final int ST_BACKQUOTE = 3;
  public static final int ST_DOUBLE_QUOTES = 2;
  public static final int ST_START_HEREDOC = 5;
  public static final int YYINITIAL = 0;
  public static final int ST_VAR_OFFSET = 9;
  public static final int ST_LOOKING_FOR_VARNAME = 8;
  public static final int ST_HEREDOC = 4;
  public static final int ST_END_HEREDOC = 6;

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\12\1\13\2\0\1\11\22\0\1\12\1\57\1\15\1\100"+
    "\1\14\1\63\1\64\1\77\1\50\1\52\1\61\1\4\1\67\1\44"+
    "\1\2\1\62\1\5\11\1\1\46\1\21\1\60\1\56\1\45\1\73"+
    "\1\74\1\35\1\7\1\30\1\24\1\3\1\25\1\51\1\36\1\22"+
    "\1\53\1\41\1\40\1\43\1\27\1\31\1\42\1\55\1\33\1\32"+
    "\1\23\1\26\1\47\1\37\1\6\1\34\1\10\1\70\1\16\1\71"+
    "\1\66\1\54\1\17\1\35\1\7\1\30\1\24\1\3\1\25\1\51"+
    "\1\36\1\22\1\53\1\41\1\40\1\43\1\27\1\31\1\42\1\55"+
    "\1\33\1\76\1\23\1\26\1\47\1\37\1\6\1\34\1\10\1\20"+
    "\1\65\1\75\1\72\201\10\uff00\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\4\0\1\1\10\0\2\2\1\3\1\4\1\5\1\6"+
    "\1\7\1\4\3\6\1\10\1\11\1\12\1\13\1\14"+
    "\1\15\16\6\1\16\1\17\1\20\1\6\1\21\1\6"+
    "\1\22\1\6\1\23\1\24\1\25\1\26\1\27\1\30"+
    "\1\31\1\32\1\33\1\34\1\35\1\36\1\37\1\40"+
    "\1\41\1\42\1\3\1\43\1\1\1\3\1\44\2\3"+
    "\1\1\2\3\1\45\1\3\2\1\3\3\2\46\1\47"+
    "\1\50\1\51\1\50\1\52\1\53\1\54\1\5\1\7"+
    "\1\54\1\55\1\56\1\57\1\60\1\16\1\17\1\20"+
    "\1\21\1\23\1\24\1\25\1\26\1\27\1\30\1\31"+
    "\1\32\1\33\1\61\1\40\1\62\1\10\1\63\3\10"+
    "\3\64\2\63\1\0\1\65\1\66\1\2\1\67\1\0"+
    "\1\70\6\6\1\71\1\72\1\0\2\6\2\0\1\73"+
    "\2\0\1\74\2\0\1\75\7\6\1\76\11\6\1\77"+
    "\5\6\1\100\5\6\1\101\1\102\1\103\1\104\1\105"+
    "\1\106\1\6\12\0\2\6\1\107\1\110\2\111\1\112"+
    "\1\113\1\0\1\114\1\115\1\116\1\117\1\120\1\121"+
    "\1\122\1\123\1\124\1\125\1\126\4\0\1\73\2\127"+
    "\1\130\1\131\1\127\3\0\3\132\3\0\1\1\2\127"+
    "\1\0\1\133\1\0\1\134\1\135\1\0\1\136\1\137"+
    "\1\140\1\141\2\0\1\67\1\0\7\6\1\67\1\142"+
    "\1\6\1\0\5\6\1\143\3\6\1\144\2\6\1\145"+
    "\1\6\1\146\1\147\12\6\1\150\6\6\1\151\1\152"+
    "\12\0\6\6\1\153\1\154\1\155\3\0\1\156\1\0"+
    "\2\117\2\126\1\0\1\157\1\160\1\1\1\135\2\0"+
    "\6\6\1\161\1\162\1\6\1\163\21\6\1\164\11\6"+
    "\1\165\4\6\12\0\7\6\2\0\1\166\4\0\1\6"+
    "\1\167\5\6\1\170\1\171\3\6\1\172\1\6\1\173"+
    "\3\6\1\174\2\6\1\175\1\6\1\176\1\177\1\200"+
    "\1\201\5\6\1\202\1\203\1\6\1\204\2\6\4\0"+
    "\1\205\7\0\7\6\2\206\2\0\1\207\2\210\1\0"+
    "\2\6\1\211\2\6\1\212\4\6\1\213\5\6\1\214"+
    "\1\215\1\216\2\6\1\217\2\6\3\0\1\220\5\0"+
    "\1\221\1\0\1\222\6\6\3\0\1\223\5\6\1\224"+
    "\2\6\1\225\1\226\1\6\1\227\1\6\1\230\1\6"+
    "\1\231\1\6\3\0\1\232\1\0\1\233\6\6\3\0"+
    "\3\6\1\234\4\6\1\235\1\236\1\6\1\237\1\6"+
    "\1\240\1\241\1\242\3\6\1\243\1\6\4\0\2\6"+
    "\1\244\1\245\4\6\1\246\1\6\1\247\2\6\2\0"+
    "\1\250\1\251\1\6\1\252\1\253\3\6\1\254\2\0"+
    "\4\6\3\0\1\255\1\256\1\257\1\6\1\260\1\0"+
    "\1\6\1\0\1\6\1\0\1\261\14\0\1\66\1\0";

  private static int [] zzUnpackAction() {
    int [] result = new int[629];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\101\0\202\0\303\0\u0104\0\u0145\0\u0186\0\u01c7"+
    "\0\u0208\0\u0249\0\u028a\0\u02cb\0\u030c\0\u034d\0\u038e\0\u03cf"+
    "\0\u0410\0\u0451\0\u0492\0\u04d3\0\u0514\0\u0555\0\u0596\0\u05d7"+
    "\0\u0618\0\u0659\0\u069a\0\u03cf\0\u03cf\0\u03cf\0\u06db\0\u071c"+
    "\0\u075d\0\u079e\0\u07df\0\u0820\0\u0861\0\u08a2\0\u08e3\0\u0924"+
    "\0\u0965\0\u09a6\0\u09e7\0\u0a28\0\u0a69\0\u0aaa\0\u0aeb\0\u0b2c"+
    "\0\u0b6d\0\u0bae\0\u03cf\0\u0bef\0\u0c30\0\u0c71\0\u0cb2\0\u0cf3"+
    "\0\u0d34\0\u0d75\0\u0db6\0\u0df7\0\u0e38\0\u03cf\0\u03cf\0\u03cf"+
    "\0\u03cf\0\u0e79\0\u03cf\0\u03cf\0\u0eba\0\u03cf\0\u0efb\0\u0f3c"+
    "\0\u03cf\0\u0f7d\0\u0fbe\0\u0fff\0\u1040\0\u1081\0\u03cf\0\u10c2"+
    "\0\u1103\0\u1144\0\u1185\0\u11c6\0\u1207\0\u03cf\0\u1248\0\u03cf"+
    "\0\u03cf\0\u1289\0\u12ca\0\u03cf\0\u130b\0\u134c\0\u03cf\0\u03cf"+
    "\0\u138d\0\u03cf\0\u03cf\0\u03cf\0\u03cf\0\u03cf\0\u03cf\0\u03cf"+
    "\0\u03cf\0\u03cf\0\u03cf\0\u03cf\0\u03cf\0\u03cf\0\u03cf\0\u03cf"+
    "\0\u03cf\0\u03cf\0\u03cf\0\u03cf\0\u03cf\0\u13ce\0\u140f\0\u03cf"+
    "\0\u1450\0\u1491\0\u14d2\0\u1513\0\u03cf\0\u03cf\0\u1554\0\u1595"+
    "\0\u15d6\0\u1617\0\u1658\0\u1699\0\u16da\0\u03cf\0\u171b\0\u175c"+
    "\0\u179d\0\u17de\0\u181f\0\u1860\0\u03cf\0\u03cf\0\u18a1\0\u18e2"+
    "\0\u1923\0\u1964\0\u0eba\0\u19a5\0\u069a\0\u19e6\0\u03cf\0\u1a27"+
    "\0\u1a68\0\u05d7\0\u1aa9\0\u1aea\0\u1b2b\0\u1b6c\0\u1bad\0\u1bee"+
    "\0\u1c2f\0\u05d7\0\u1c70\0\u1cb1\0\u1cf2\0\u1d33\0\u1d74\0\u1db5"+
    "\0\u1df6\0\u1e37\0\u1e78\0\u05d7\0\u1eb9\0\u1efa\0\u1f3b\0\u1f7c"+
    "\0\u1fbd\0\u05d7\0\u1ffe\0\u203f\0\u2080\0\u20c1\0\u2102\0\u03cf"+
    "\0\u03cf\0\u03cf\0\u2143\0\u03cf\0\u03cf\0\u2184\0\u21c5\0\u0b6d"+
    "\0\u2206\0\u2247\0\u2288\0\u22c9\0\u230a\0\u234b\0\u238c\0\u23cd"+
    "\0\u240e\0\u244f\0\u03cf\0\u2490\0\u24d1\0\u03cf\0\u03cf\0\u2512"+
    "\0\u2553\0\u03cf\0\u03cf\0\u2594\0\u25d5\0\u03cf\0\u03cf\0\u03cf"+
    "\0\u03cf\0\u03cf\0\u03cf\0\u2616\0\u2657\0\u2698\0\u0f7d\0\u26d9"+
    "\0\u271a\0\u2698\0\u03cf\0\u03cf\0\u03cf\0\u26d9\0\u275b\0\u1081"+
    "\0\u279c\0\u275b\0\u03cf\0\u279c\0\u27dd\0\u11c6\0\u281e\0\u285f"+
    "\0\u27dd\0\u281e\0\u1248\0\u03cf\0\u28a0\0\u03cf\0\u28e1\0\u2922"+
    "\0\u03cf\0\u03cf\0\u03cf\0\u03cf\0\u2963\0\u29a4\0\u29e5\0\u29e5"+
    "\0\u2a26\0\u2a67\0\u2aa8\0\u2ae9\0\u2b2a\0\u2b6b\0\u2bac\0\u18a1"+
    "\0\u05d7\0\u2bed\0\u2c2e\0\u2c6f\0\u2cb0\0\u2cf1\0\u2d32\0\u2d73"+
    "\0\u05d7\0\u2db4\0\u2df5\0\u2e36\0\u05d7\0\u2e77\0\u2eb8\0\u2ef9"+
    "\0\u2f3a\0\u05d7\0\u05d7\0\u2f7b\0\u2fbc\0\u2ffd\0\u303e\0\u307f"+
    "\0\u30c0\0\u3101\0\u3142\0\u3183\0\u31c4\0\u05d7\0\u3205\0\u3246"+
    "\0\u3287\0\u32c8\0\u3309\0\u334a\0\u03cf\0\u05d7\0\u338b\0\u33cc"+
    "\0\u340d\0\u344e\0\u348f\0\u34d0\0\u3511\0\u3552\0\u3593\0\u35d4"+
    "\0\u3615\0\u3656\0\u3697\0\u36d8\0\u3719\0\u375a\0\u03cf\0\u03cf"+
    "\0\u03cf\0\u379b\0\u37dc\0\u381d\0\u385e\0\u389f\0\u38e0\0\u03cf"+
    "\0\u3921\0\u03cf\0\u3962\0\u03cf\0\u03cf\0\u39a3\0\u2922\0\u39e4"+
    "\0\u3a25\0\u3a66\0\u3aa7\0\u3ae8\0\u3b29\0\u3b6a\0\u3bab\0\u05d7"+
    "\0\u3bec\0\u3c2d\0\u05d7\0\u3c6e\0\u3caf\0\u3cf0\0\u3d31\0\u3d72"+
    "\0\u3db3\0\u3df4\0\u3e35\0\u3e76\0\u3eb7\0\u3ef8\0\u3f39\0\u3f7a"+
    "\0\u3fbb\0\u3ffc\0\u403d\0\u407e\0\u05d7\0\u40bf\0\u4100\0\u4141"+
    "\0\u4182\0\u41c3\0\u4204\0\u4245\0\u4286\0\u42c7\0\u05d7\0\u4308"+
    "\0\u4349\0\u438a\0\u43cb\0\u440c\0\u444d\0\u448e\0\u44cf\0\u4510"+
    "\0\u4551\0\u4592\0\u45d3\0\u4614\0\u4655\0\u4696\0\u46d7\0\u4718"+
    "\0\u4759\0\u479a\0\u47db\0\u481c\0\u485d\0\u489e\0\u03cf\0\u48df"+
    "\0\u4920\0\u4961\0\u49a2\0\u49e3\0\u05d7\0\u4a24\0\u4a65\0\u4aa6"+
    "\0\u4ae7\0\u4b28\0\u05d7\0\u05d7\0\u4b69\0\u4baa\0\u4beb\0\u05d7"+
    "\0\u4c2c\0\u05d7\0\u4c6d\0\u4cae\0\u4cef\0\u05d7\0\u4d30\0\u4d71"+
    "\0\u05d7\0\u4db2\0\u05d7\0\u05d7\0\u05d7\0\u05d7\0\u4df3\0\u4e34"+
    "\0\u4e75\0\u4eb6\0\u4ef7\0\u05d7\0\u05d7\0\u4f38\0\u05d7\0\u4f79"+
    "\0\u4fba\0\u4ffb\0\u503c\0\u507d\0\u50be\0\u03cf\0\u50ff\0\u5140"+
    "\0\u5181\0\u51c2\0\u5203\0\u5244\0\u5285\0\u52c6\0\u5307\0\u5348"+
    "\0\u5389\0\u53ca\0\u540b\0\u544c\0\u548d\0\u03cf\0\u54ce\0\u550f"+
    "\0\u03cf\0\u5550\0\u03cf\0\u5591\0\u55d2\0\u5613\0\u5654\0\u5695"+
    "\0\u56d6\0\u05d7\0\u5717\0\u5758\0\u5799\0\u57da\0\u05d7\0\u581b"+
    "\0\u585c\0\u589d\0\u58de\0\u591f\0\u05d7\0\u05d7\0\u05d7\0\u5960"+
    "\0\u59a1\0\u05d7\0\u59e2\0\u5a23\0\u5a64\0\u5aa5\0\u5ae6\0\u03cf"+
    "\0\u5b27\0\u5b68\0\u5ba9\0\u5bea\0\u5c2b\0\u03cf\0\u5c6c\0\u05d7"+
    "\0\u5cad\0\u5cee\0\u5d2f\0\u5d70\0\u5db1\0\u5df2\0\u5e33\0\u5e74"+
    "\0\u5eb5\0\u05d7\0\u5ef6\0\u5f37\0\u5f78\0\u5fb9\0\u5ffa\0\u603b"+
    "\0\u607c\0\u60bd\0\u05d7\0\u05d7\0\u60fe\0\u05d7\0\u613f\0\u6180"+
    "\0\u61c1\0\u05d7\0\u6202\0\u6243\0\u6284\0\u62c5\0\u03cf\0\u6306"+
    "\0\u03cf\0\u6347\0\u6388\0\u63c9\0\u640a\0\u644b\0\u648c\0\u64cd"+
    "\0\u650e\0\u654f\0\u6590\0\u65d1\0\u6612\0\u05d7\0\u6653\0\u6694"+
    "\0\u66d5\0\u6716\0\u05d7\0\u05d7\0\u6757\0\u05d7\0\u6798\0\u03cf"+
    "\0\u03cf\0\u05d7\0\u67d9\0\u681a\0\u685b\0\u05d7\0\u689c\0\u68dd"+
    "\0\u691e\0\u695f\0\u69a0\0\u69e1\0\u6a22\0\u05d7\0\u05d7\0\u6a63"+
    "\0\u6aa4\0\u6ae5\0\u6b26\0\u05d7\0\u6b67\0\u05d7\0\u6ba8\0\u6be9"+
    "\0\u6c2a\0\u6c6b\0\u05d7\0\u05d7\0\u6cac\0\u05d7\0\u05d7\0\u6ced"+
    "\0\u6d2e\0\u6d6f\0\u05d7\0\u6db0\0\u6df1\0\u6e32\0\u6e73\0\u6eb4"+
    "\0\u6ef5\0\u6f36\0\u6f77\0\u6fb8\0\u05d7\0\u05d7\0\u05d7\0\u6ff9"+
    "\0\u03cf\0\u703a\0\u707b\0\u70bc\0\u70fd\0\u713e\0\u05d7\0\u717f"+
    "\0\u71c0\0\u7201\0\u7242\0\u7283\0\u72c4\0\u7305\0\u7346\0\u7387"+
    "\0\u73c8\0\u7409\0\u744a\0\u03cf\0\u748b";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[629];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\60\16\1\17\20\16\1\20\1\21\1\22\1\23\1\24"+
    "\1\25\1\26\1\27\1\30\3\31\1\32\1\33\1\20"+
    "\1\34\1\35\1\36\1\37\1\40\1\41\1\42\1\43"+
    "\1\44\1\45\1\46\1\47\1\50\1\30\1\51\1\30"+
    "\1\52\1\53\1\30\1\54\1\30\1\55\1\56\1\57"+
    "\1\60\1\61\1\62\1\63\1\30\1\64\1\30\1\65"+
    "\1\66\1\67\1\70\1\71\1\72\1\73\1\74\1\75"+
    "\1\76\1\77\1\100\1\101\1\102\1\103\1\104\1\47"+
    "\1\105\1\106\14\107\1\110\1\111\1\112\1\107\1\113"+
    "\60\107\14\114\1\115\1\114\1\116\1\117\1\120\60\114"+
    "\11\121\1\122\1\121\1\122\1\123\1\121\1\124\1\121"+
    "\1\125\60\121\3\126\1\127\2\126\3\127\11\126\22\127"+
    "\3\126\1\127\1\126\1\127\1\126\3\127\20\126\1\127"+
    "\2\126\101\130\3\131\1\132\2\131\3\132\11\131\22\132"+
    "\1\133\2\131\1\132\1\131\1\132\1\131\3\132\20\131"+
    "\1\132\2\131\3\134\1\135\2\134\3\135\11\134\22\135"+
    "\3\134\1\135\1\134\1\135\1\134\3\135\20\134\1\135"+
    "\2\134\1\20\1\136\1\137\1\30\1\140\1\141\3\30"+
    "\3\142\1\32\1\143\1\142\1\144\1\145\1\36\22\30"+
    "\1\146\1\147\1\150\1\30\1\151\1\30\1\63\3\30"+
    "\1\152\1\153\1\154\1\155\1\156\1\157\1\160\1\161"+
    "\1\162\1\76\1\77\1\163\1\101\1\164\1\103\1\165"+
    "\1\30\2\142\61\166\1\167\17\166\11\170\1\171\47\170"+
    "\1\172\17\170\11\173\1\174\1\173\1\175\31\173\1\176"+
    "\15\173\1\177\7\173\1\177\5\173\60\16\1\200\100\16"+
    "\1\0\2\16\1\201\7\16\1\202\2\16\1\203\2\16"+
    "\102\0\1\21\1\204\1\205\1\0\1\21\74\0\1\204"+
    "\3\0\1\204\50\0\1\206\23\0\1\30\1\0\1\30"+
    "\1\0\1\30\1\207\2\30\11\0\5\30\1\210\1\211"+
    "\7\30\1\212\2\30\1\213\3\0\1\214\1\0\1\30"+
    "\1\0\3\30\20\0\1\30\6\0\1\215\51\0\1\216"+
    "\23\0\1\21\1\204\1\205\1\0\1\21\1\217\73\0"+
    "\1\30\1\0\1\30\1\0\4\30\11\0\7\30\1\220"+
    "\12\30\3\0\1\30\1\0\1\30\1\0\3\30\20\0"+
    "\1\30\3\0\1\30\1\0\1\30\1\0\4\30\4\0"+
    "\1\33\4\0\11\30\1\221\10\30\3\0\1\30\1\0"+
    "\1\30\1\0\3\30\2\0\1\222\15\0\1\30\1\223"+
    "\2\0\1\30\1\0\1\30\1\0\4\30\11\0\22\30"+
    "\3\0\1\30\1\0\1\30\1\0\3\30\20\0\1\30"+
    "\13\0\3\31\70\0\1\224\2\0\3\224\11\0\22\224"+
    "\3\0\1\224\1\0\1\224\1\0\3\224\20\0\1\224"+
    "\2\0\14\225\1\226\1\227\1\230\1\225\1\231\60\225"+
    "\1\0\1\30\1\0\1\30\1\0\4\30\11\0\3\30"+
    "\1\232\1\30\1\233\2\30\1\234\10\30\1\235\3\0"+
    "\1\30\1\0\1\30\1\0\3\30\20\0\1\234\3\0"+
    "\1\30\1\0\1\30\1\0\4\30\11\0\11\30\1\236"+
    "\2\30\1\237\5\30\3\0\1\30\1\0\1\30\1\0"+
    "\3\30\20\0\1\30\3\0\1\30\1\0\1\240\1\0"+
    "\4\30\11\0\1\241\6\30\1\242\12\30\3\0\1\30"+
    "\1\0\1\30\1\0\3\30\20\0\1\30\3\0\1\30"+
    "\1\0\1\30\1\0\4\30\11\0\1\243\3\30\1\244"+
    "\2\30\1\245\12\30\3\0\1\30\1\0\1\30\1\0"+
    "\3\30\20\0\1\30\3\0\1\30\1\0\1\30\1\0"+
    "\4\30\11\0\5\30\1\246\2\30\1\247\11\30\3\0"+
    "\1\30\1\0\1\30\1\0\3\30\20\0\1\247\3\0"+
    "\1\30\1\0\1\250\1\0\4\30\11\0\22\30\3\0"+
    "\1\30\1\0\1\30\1\0\3\30\20\0\1\30\3\0"+
    "\1\30\1\0\1\30\1\0\4\30\11\0\7\30\1\251"+
    "\3\30\1\252\2\30\1\253\3\30\3\0\1\30\1\0"+
    "\1\30\1\0\3\30\20\0\1\30\3\0\1\30\1\0"+
    "\1\30\1\0\4\30\11\0\11\30\1\254\10\30\3\0"+
    "\1\30\1\0\1\30\1\0\3\30\20\0\1\30\3\0"+
    "\1\30\1\0\1\30\1\0\4\30\11\0\1\30\1\255"+
    "\13\30\1\256\4\30\3\0\1\30\1\0\1\30\1\0"+
    "\3\30\20\0\1\30\3\0\1\30\1\0\1\257\1\0"+
    "\4\30\11\0\22\30\3\0\1\30\1\0\1\30\1\0"+
    "\3\30\20\0\1\30\3\0\1\30\1\0\1\30\1\0"+
    "\2\30\1\260\1\30\11\0\5\30\1\261\2\30\1\262"+
    "\1\263\10\30\3\0\1\30\1\0\1\30\1\0\3\30"+
    "\20\0\1\262\3\0\1\30\1\0\1\30\1\0\4\30"+
    "\11\0\14\30\1\264\5\30\3\0\1\30\1\0\1\30"+
    "\1\0\3\30\20\0\1\30\3\0\1\30\1\0\1\30"+
    "\1\0\4\30\11\0\1\265\21\30\3\0\1\30\1\0"+
    "\1\30\1\0\3\30\20\0\1\30\3\0\1\30\1\0"+
    "\1\30\1\0\4\30\11\0\4\30\1\266\4\30\1\267"+
    "\10\30\3\0\1\30\1\0\1\30\1\0\3\30\20\0"+
    "\1\30\46\0\1\270\1\271\10\0\1\272\67\0\1\273"+
    "\10\0\1\274\70\0\1\275\33\0\1\30\1\0\1\30"+
    "\1\0\4\30\11\0\13\30\1\276\6\30\3\0\1\30"+
    "\1\0\1\30\1\0\3\30\20\0\1\30\11\0\1\277"+
    "\2\0\1\300\7\0\1\301\1\0\1\302\1\303\1\304"+
    "\2\0\1\305\1\306\1\307\1\0\1\310\40\0\1\306"+
    "\3\0\1\30\1\0\1\30\1\0\4\30\11\0\16\30"+
    "\1\311\3\30\3\0\1\30\1\0\1\30\1\0\3\30"+
    "\20\0\1\30\3\0\1\30\1\0\1\30\1\0\4\30"+
    "\11\0\22\30\3\0\1\30\1\0\1\30\1\0\1\30"+
    "\1\312\1\30\20\0\1\30\47\0\1\313\10\0\1\314"+
    "\100\0\1\315\67\0\1\316\10\0\1\317\1\0\1\320"+
    "\1\0\1\321\74\0\1\322\100\0\1\323\2\0\1\324"+
    "\1\106\63\0\1\325\10\0\1\326\100\0\1\327\5\0"+
    "\1\330\72\0\1\331\6\0\1\332\71\0\1\333\67\0"+
    "\1\334\33\0\16\223\1\335\60\223\1\227\1\223\14\107"+
    "\1\336\1\0\1\337\1\107\1\340\63\107\1\341\2\107"+
    "\3\341\3\107\1\342\1\343\1\337\1\107\1\344\1\107"+
    "\22\341\3\107\1\341\1\107\1\341\1\107\3\341\20\107"+
    "\1\341\117\107\1\345\1\343\1\337\1\107\1\346\60\107"+
    "\14\114\1\347\1\114\1\350\1\0\1\351\63\114\1\341"+
    "\2\114\3\341\3\114\1\352\1\114\1\350\1\353\1\344"+
    "\1\114\22\341\3\114\1\341\1\114\1\341\1\114\3\341"+
    "\20\114\1\341\117\114\1\345\1\114\1\350\1\353\1\354"+
    "\60\114\11\121\1\122\1\121\1\122\1\355\1\121\1\356"+
    "\1\121\1\357\63\121\1\360\2\121\3\360\1\122\1\121"+
    "\1\122\1\355\1\121\1\356\1\121\1\357\1\121\22\360"+
    "\3\121\1\360\1\121\1\360\1\121\3\360\20\121\1\360"+
    "\5\121\1\341\2\121\3\341\1\122\1\121\1\122\1\361"+
    "\1\121\1\356\1\121\1\344\1\121\22\341\3\121\1\341"+
    "\1\121\1\341\1\121\3\341\20\121\1\341\13\121\1\122"+
    "\1\121\1\122\76\121\1\122\1\121\1\122\1\345\1\121"+
    "\1\356\1\121\1\362\60\121\1\0\1\363\1\0\1\363"+
    "\1\0\4\363\1\364\1\0\1\364\5\0\1\365\22\363"+
    "\3\0\1\363\1\0\1\363\1\0\3\363\20\0\1\363"+
    "\3\0\1\132\1\0\1\132\1\0\4\132\11\0\22\132"+
    "\3\0\1\132\1\0\1\132\1\0\3\132\20\0\1\132"+
    "\47\0\1\366\34\0\1\135\1\0\1\135\1\0\4\135"+
    "\11\0\22\135\3\0\1\135\1\0\1\135\1\0\3\135"+
    "\20\0\1\135\3\0\1\136\3\0\1\136\74\0\1\367"+
    "\3\0\1\367\1\370\72\0\61\166\1\0\17\166\62\0"+
    "\1\371\31\0\1\170\147\0\1\372\16\0\11\173\1\174"+
    "\1\173\1\175\31\173\1\175\15\173\1\175\7\173\1\175"+
    "\5\173\13\0\1\175\132\0\1\373\33\0\60\16\1\0"+
    "\2\16\1\0\7\16\1\0\2\16\1\0\2\16\56\0"+
    "\1\374\64\0\1\375\13\0\1\374\52\0\1\376\51\0"+
    "\1\204\1\0\1\205\1\0\1\204\74\0\1\377\2\0"+
    "\1\u0100\1\377\36\0\1\u0100\35\0\1\30\1\0\1\30"+
    "\1\0\4\30\11\0\1\u0101\1\u0102\20\30\3\0\1\30"+
    "\1\0\1\30\1\0\3\30\20\0\1\30\3\0\1\30"+
    "\1\0\1\30\1\0\4\30\11\0\2\30\1\u0103\17\30"+
    "\3\0\1\30\1\0\1\30\1\0\3\30\20\0\1\30"+
    "\3\0\1\30\1\0\1\30\1\0\4\30\11\0\14\30"+
    "\1\u0104\5\30\3\0\1\30\1\0\1\30\1\0\3\30"+
    "\20\0\1\30\3\0\1\30\1\0\1\30\1\0\4\30"+
    "\11\0\10\30\1\u0105\11\30\3\0\1\30\1\0\1\30"+
    "\1\0\3\30\20\0\1\u0105\3\0\1\30\1\0\1\30"+
    "\1\0\4\30\11\0\20\30\1\u0106\1\30\3\0\1\30"+
    "\1\0\1\30\1\0\3\30\20\0\1\30\3\0\1\30"+
    "\1\0\1\30\1\0\4\30\11\0\13\30\1\u0107\6\30"+
    "\3\0\1\30\1\0\1\30\1\0\3\30\20\0\1\30"+
    "\3\0\1\u0108\1\0\1\u0108\1\0\1\u0108\1\0\1\u0108"+
    "\14\0\2\u0108\2\0\1\u0108\4\0\1\u0108\44\0\1\30"+
    "\1\0\1\30\1\0\4\30\11\0\11\30\1\u0109\10\30"+
    "\3\0\1\30\1\0\1\30\1\0\3\30\20\0\1\30"+
    "\3\0\1\30\1\0\1\u010a\1\0\4\30\11\0\22\30"+
    "\3\0\1\30\1\0\1\30\1\0\3\30\20\0\1\30"+
    "\62\0\1\u010b\21\0\1\224\1\0\1\224\1\0\4\224"+
    "\11\0\22\224\3\0\1\224\1\0\1\224\1\0\3\224"+
    "\20\0\1\224\2\0\3\225\1\0\2\225\3\0\3\225"+
    "\1\226\1\227\1\230\1\225\1\0\1\225\22\0\3\225"+
    "\1\0\1\225\1\0\1\225\3\0\20\225\1\0\117\225"+
    "\1\0\1\227\1\230\1\225\1\231\60\225\1\0\1\30"+
    "\1\0\1\30\1\0\4\30\11\0\1\30\1\u010c\4\30"+
    "\1\u010d\1\30\1\u010e\11\30\3\0\1\30\1\0\1\30"+
    "\1\0\3\30\20\0\1\u010e\3\0\1\30\1\0\1\30"+
    "\1\0\4\30\11\0\10\30\1\u010f\11\30\3\0\1\30"+
    "\1\0\1\30\1\0\3\30\20\0\1\u010f\3\0\1\30"+
    "\1\0\1\30\1\0\4\30\11\0\20\30\1\u0110\1\30"+
    "\3\0\1\30\1\0\1\30\1\0\3\30\20\0\1\30"+
    "\3\0\1\30\1\0\1\30\1\0\4\30\11\0\12\30"+
    "\1\u0111\7\30\3\0\1\30\1\0\1\30\1\0\3\30"+
    "\20\0\1\30\3\0\1\30\1\0\1\30\1\0\4\30"+
    "\11\0\11\30\1\u0112\10\30\3\0\1\30\1\0\1\30"+
    "\1\0\3\30\20\0\1\30\3\0\1\30\1\0\1\30"+
    "\1\0\4\30\11\0\3\30\1\u0113\2\30\1\u0114\13\30"+
    "\3\0\1\30\1\0\1\30\1\0\3\30\20\0\1\30"+
    "\3\0\1\30\1\0\1\u0115\1\0\4\30\11\0\22\30"+
    "\3\0\1\30\1\0\1\30\1\0\3\30\20\0\1\30"+
    "\3\0\1\30\1\0\1\30\1\0\4\30\11\0\5\30"+
    "\1\u0116\14\30\3\0\1\30\1\0\1\30\1\0\3\30"+
    "\20\0\1\30\3\0\1\30\1\0\1\30\1\0\4\30"+
    "\11\0\5\30\1\u0117\14\30\3\0\1\30\1\0\1\30"+
    "\1\0\3\30\20\0\1\30\3\0\1\30\1\0\1\30"+
    "\1\0\4\30\11\0\11\30\1\u0118\10\30\3\0\1\30"+
    "\1\0\1\30\1\0\3\30\20\0\1\30\3\0\1\30"+
    "\1\0\1\30\1\0\4\30\11\0\10\30\1\u0119\11\30"+
    "\3\0\1\30\1\0\1\30\1\0\3\30\20\0\1\u0119"+
    "\3\0\1\30\1\0\1\u011a\1\0\4\30\11\0\22\30"+
    "\3\0\1\30\1\0\1\30\1\0\3\30\20\0\1\30"+
    "\3\0\1\30\1\0\1\30\1\0\4\30\11\0\15\30"+
    "\1\u011b\4\30\3\0\1\30\1\0\1\30\1\0\3\30"+
    "\20\0\1\30\3\0\1\30\1\0\1\30\1\0\4\30"+
    "\11\0\5\30\1\u011c\14\30\3\0\1\30\1\0\1\30"+
    "\1\0\3\30\20\0\1\30\3\0\1\30\1\0\1\30"+
    "\1\0\4\30\11\0\1\30\1\u011d\6\30\1\u011e\11\30"+
    "\3\0\1\30\1\0\1\30\1\0\3\30\20\0\1\u011e"+
    "\3\0\1\30\1\0\1\30\1\0\4\30\11\0\7\30"+
    "\1\u011f\3\30\1\u0120\6\30\3\0\1\30\1\0\1\30"+
    "\1\0\3\30\20\0\1\30\3\0\1\30\1\0\1\30"+
    "\1\0\4\30\11\0\13\30\1\u0121\6\30\3\0\1\30"+
    "\1\0\1\30\1\0\3\30\20\0\1\30\3\0\1\30"+
    "\1\0\1\30\1\0\4\30\11\0\1\u0122\21\30\3\0"+
    "\1\30\1\0\1\30\1\0\3\30\20\0\1\30\3\0"+
    "\1\30\1\0\1\30\1\0\4\30\11\0\1\30\1\u0123"+
    "\20\30\3\0\1\30\1\0\1\30\1\0\2\30\1\u0124"+
    "\20\0\1\30\3\0\1\30\1\0\1\30\1\0\4\30"+
    "\11\0\10\30\1\u0125\11\30\3\0\1\30\1\0\1\30"+
    "\1\0\3\30\20\0\1\u0125\3\0\1\30\1\0\1\30"+
    "\1\0\4\30\11\0\2\30\1\u0126\17\30\3\0\1\30"+
    "\1\0\1\30\1\0\3\30\20\0\1\30\3\0\1\30"+
    "\1\0\1\30\1\0\4\30\11\0\11\30\1\u0127\10\30"+
    "\3\0\1\30\1\0\1\30\1\0\3\30\20\0\1\30"+
    "\3\0\1\30\1\0\1\30\1\0\4\30\11\0\1\u0128"+
    "\21\30\3\0\1\30\1\0\1\30\1\0\3\30\20\0"+
    "\1\30\3\0\1\30\1\0\1\30\1\0\4\30\11\0"+
    "\10\30\1\u0129\11\30\3\0\1\30\1\0\1\30\1\0"+
    "\3\30\20\0\1\u0129\3\0\1\30\1\0\1\30\1\0"+
    "\2\30\1\u012a\1\30\11\0\22\30\3\0\1\30\1\0"+
    "\1\30\1\0\3\30\20\0\1\30\3\0\1\30\1\0"+
    "\1\30\1\0\4\30\11\0\1\u012b\6\30\1\u012c\12\30"+
    "\3\0\1\30\1\0\1\30\1\0\3\30\20\0\1\30"+
    "\60\0\1\u012d\23\0\1\30\1\0\1\30\1\0\4\30"+
    "\11\0\11\30\1\u012e\10\30\3\0\1\30\1\0\1\30"+
    "\1\0\3\30\20\0\1\30\24\0\1\u012f\6\0\1\u0130"+
    "\76\0\1\u0131\102\0\1\u0132\107\0\1\u0133\67\0\1\u0134"+
    "\60\0\1\u0135\114\0\1\u0136\60\0\1\u0137\130\0\1\u0138"+
    "\46\0\1\30\1\0\1\30\1\0\4\30\11\0\7\30"+
    "\1\u0139\12\30\3\0\1\30\1\0\1\30\1\0\3\30"+
    "\20\0\1\30\3\0\1\30\1\0\1\30\1\0\4\30"+
    "\11\0\3\30\1\u013a\2\30\1\u013b\5\30\1\u013c\1\30"+
    "\1\u013d\2\30\1\u013e\3\0\1\30\1\0\1\30\1\0"+
    "\3\30\20\0\1\30\60\0\1\u013f\100\0\1\u0140\100\0"+
    "\1\u0141\1\0\1\u0142\52\0\1\u0143\43\0\1\u0143\13\0"+
    "\3\u0144\45\0\1\u0145\12\0\1\u0146\15\0\1\u0147\1\0"+
    "\1\u0148\76\0\1\u0149\1\0\1\u014a\65\0\101\223\3\107"+
    "\1\0\2\107\3\0\3\107\1\342\1\343\1\337\1\107"+
    "\1\0\1\107\22\0\3\107\1\0\1\107\1\0\1\107"+
    "\3\0\20\107\1\0\16\107\1\0\1\343\1\337\1\107"+
    "\1\346\60\107\1\0\1\341\1\0\1\341\1\0\4\341"+
    "\11\0\22\341\1\u014b\2\0\1\341\1\0\1\341\1\0"+
    "\3\341\12\0\1\u014c\5\0\1\341\2\0\3\114\1\0"+
    "\2\114\3\0\3\114\1\352\1\114\1\350\1\353\1\0"+
    "\1\114\22\0\3\114\1\0\1\114\1\0\1\114\3\0"+
    "\20\114\1\0\16\114\1\0\1\114\1\350\1\353\1\354"+
    "\60\114\3\121\1\0\2\121\3\0\1\122\1\121\1\122"+
    "\1\361\1\121\1\356\1\121\1\0\1\121\22\0\3\121"+
    "\1\0\1\121\1\0\1\121\3\0\20\121\1\0\13\121"+
    "\1\122\1\121\1\122\1\0\1\121\1\356\1\121\1\362"+
    "\61\121\1\360\1\121\1\360\1\121\4\360\1\u014d\1\121"+
    "\1\u014d\1\355\1\121\1\356\1\121\1\357\1\u014e\22\360"+
    "\3\121\1\360\1\121\1\360\1\121\3\360\20\121\1\360"+
    "\2\121\11\0\1\364\1\0\1\364\66\0\1\367\3\0"+
    "\1\367\74\0\1\u014f\1\0\1\u014f\1\0\1\u014f\1\0"+
    "\1\u014f\14\0\2\u014f\2\0\1\u014f\4\0\1\u014f\101\0"+
    "\1\u0150\75\0\1\u0151\46\0\1\377\3\0\1\377\74\0"+
    "\1\30\1\0\1\30\1\0\4\30\11\0\1\30\1\u0115"+
    "\20\30\3\0\1\30\1\0\1\30\1\0\3\30\20\0"+
    "\1\30\3\0\1\30\1\0\1\u0152\1\0\4\30\11\0"+
    "\22\30\3\0\1\30\1\0\1\30\1\0\3\30\20\0"+
    "\1\30\3\0\1\30\1\0\1\30\1\0\4\30\11\0"+
    "\1\u0153\1\30\1\u0154\1\u0155\4\30\1\u0156\4\30\1\u0157"+
    "\4\30\3\0\1\30\1\0\1\30\1\0\3\30\20\0"+
    "\1\u0156\3\0\1\30\1\0\1\30\1\0\4\30\11\0"+
    "\7\30\1\u0158\12\30\3\0\1\30\1\0\1\30\1\0"+
    "\3\30\20\0\1\30\3\0\1\30\1\0\1\u0159\1\0"+
    "\4\30\11\0\22\30\3\0\1\30\1\0\1\30\1\0"+
    "\3\30\20\0\1\30\3\0\1\30\1\0\1\30\1\0"+
    "\4\30\11\0\1\30\1\u015a\20\30\3\0\1\30\1\0"+
    "\1\30\1\0\3\30\20\0\1\30\3\0\1\30\1\0"+
    "\1\30\1\0\4\30\11\0\16\30\1\u015b\3\30\3\0"+
    "\1\30\1\0\1\30\1\0\3\30\20\0\1\30\3\0"+
    "\1\30\1\0\1\30\1\0\4\30\11\0\13\30\1\u015c"+
    "\6\30\3\0\1\30\1\0\1\30\1\0\3\30\20\0"+
    "\1\30\62\0\1\u0142\21\0\1\30\1\0\1\u015d\1\0"+
    "\4\30\11\0\22\30\3\0\1\30\1\0\1\30\1\0"+
    "\3\30\20\0\1\30\3\0\1\30\1\0\1\30\1\0"+
    "\4\30\11\0\16\30\1\u015e\3\30\3\0\1\30\1\0"+
    "\1\30\1\0\3\30\20\0\1\30\3\0\1\30\1\0"+
    "\1\30\1\0\4\30\11\0\1\30\1\u015f\20\30\3\0"+
    "\1\30\1\0\1\30\1\0\3\30\20\0\1\30\3\0"+
    "\1\30\1\0\1\u0160\1\0\4\30\11\0\22\30\3\0"+
    "\1\30\1\0\1\30\1\0\3\30\20\0\1\30\3\0"+
    "\1\30\1\0\1\30\1\0\4\30\11\0\16\30\1\u0161"+
    "\3\30\3\0\1\30\1\0\1\30\1\0\3\30\20\0"+
    "\1\30\3\0\1\30\1\0\1\30\1\0\4\30\11\0"+
    "\7\30\1\u0162\12\30\3\0\1\30\1\0\1\30\1\0"+
    "\3\30\20\0\1\30\3\0\1\30\1\0\1\30\1\0"+
    "\4\30\11\0\1\u0163\12\30\1\u0164\6\30\3\0\1\30"+
    "\1\0\1\30\1\0\3\30\20\0\1\30\3\0\1\30"+
    "\1\0\1\30\1\0\4\30\11\0\16\30\1\u0165\3\30"+
    "\3\0\1\30\1\0\1\30\1\0\3\30\20\0\1\30"+
    "\3\0\1\30\1\0\1\30\1\0\4\30\11\0\13\30"+
    "\1\u0166\6\30\3\0\1\30\1\0\1\30\1\0\3\30"+
    "\20\0\1\30\3\0\1\30\1\0\1\30\1\0\4\30"+
    "\11\0\6\30\1\u0167\13\30\3\0\1\30\1\0\1\30"+
    "\1\0\3\30\20\0\1\30\3\0\1\30\1\0\1\u0168"+
    "\1\0\4\30\11\0\22\30\3\0\1\30\1\0\1\30"+
    "\1\0\3\30\20\0\1\30\3\0\1\30\1\0\1\u0169"+
    "\1\0\4\30\11\0\22\30\3\0\1\30\1\0\1\30"+
    "\1\0\3\30\20\0\1\30\3\0\1\30\1\0\1\30"+
    "\1\0\4\30\11\0\1\30\1\u016a\6\30\1\u016b\11\30"+
    "\3\0\1\30\1\0\1\30\1\0\3\30\20\0\1\u016b"+
    "\3\0\1\30\1\0\1\30\1\0\4\30\11\0\6\30"+
    "\1\u016c\13\30\3\0\1\30\1\0\1\30\1\0\3\30"+
    "\20\0\1\30\3\0\1\30\1\0\1\u016d\1\0\4\30"+
    "\11\0\22\30\3\0\1\30\1\0\1\30\1\0\3\30"+
    "\20\0\1\30\3\0\1\30\1\0\1\30\1\0\4\30"+
    "\11\0\5\30\1\u016e\14\30\3\0\1\30\1\0\1\30"+
    "\1\0\3\30\20\0\1\30\3\0\1\30\1\0\1\30"+
    "\1\0\4\30\11\0\10\30\1\u016f\11\30\3\0\1\30"+
    "\1\0\1\30\1\0\3\30\20\0\1\u016f\3\0\1\30"+
    "\1\0\1\30\1\0\4\30\11\0\1\30\1\u0170\20\30"+
    "\3\0\1\30\1\0\1\30\1\0\3\30\20\0\1\30"+
    "\3\0\1\30\1\0\1\30\1\0\4\30\11\0\1\30"+
    "\1\u0171\20\30\3\0\1\30\1\0\1\30\1\0\3\30"+
    "\20\0\1\30\3\0\1\30\1\0\1\30\1\0\4\30"+
    "\11\0\4\30\1\u0172\15\30\3\0\1\30\1\0\1\30"+
    "\1\0\3\30\20\0\1\30\3\0\1\30\1\0\1\30"+
    "\1\0\4\30\11\0\4\30\1\u0173\15\30\3\0\1\30"+
    "\1\0\1\30\1\0\3\30\20\0\1\30\3\0\1\30"+
    "\1\0\1\30\1\0\4\30\11\0\1\30\1\u0174\20\30"+
    "\3\0\1\30\1\0\1\30\1\0\3\30\20\0\1\30"+
    "\3\0\1\30\1\0\1\30\1\0\4\30\11\0\13\30"+
    "\1\u0175\6\30\3\0\1\30\1\0\1\30\1\0\3\30"+
    "\20\0\1\30\3\0\1\30\1\0\1\30\1\0\4\30"+
    "\11\0\16\30\1\u0176\3\30\3\0\1\30\1\0\1\30"+
    "\1\0\3\30\20\0\1\30\3\0\1\30\1\0\1\30"+
    "\1\0\4\30\11\0\1\30\1\u0177\20\30\3\0\1\30"+
    "\1\0\1\30\1\0\3\30\20\0\1\30\3\0\1\30"+
    "\1\0\1\30\1\0\4\30\11\0\16\30\1\u0178\3\30"+
    "\3\0\1\30\1\0\1\30\1\0\3\30\20\0\1\30"+
    "\3\0\1\30\1\0\1\30\1\0\4\30\11\0\5\30"+
    "\1\u0179\14\30\3\0\1\u017a\1\0\1\30\1\0\3\30"+
    "\20\0\1\30\3\0\1\30\1\0\1\30\1\0\4\30"+
    "\11\0\1\30\1\u017b\20\30\3\0\1\30\1\0\1\30"+
    "\1\0\3\30\20\0\1\30\31\0\1\u017c\102\0\1\u017d"+
    "\72\0\1\u017e\103\0\1\u017f\103\0\1\u0180\101\0\1\u0181"+
    "\43\0\1\u0181\55\0\1\u0182\60\0\1\u0183\102\0\1\u0184"+
    "\76\0\1\u0185\46\0\1\30\1\0\1\30\1\0\2\30"+
    "\1\u0186\1\30\11\0\22\30\3\0\1\30\1\0\1\30"+
    "\1\0\3\30\20\0\1\30\3\0\1\30\1\0\1\30"+
    "\1\0\4\30\11\0\1\u0187\3\30\1\u0188\15\30\3\0"+
    "\1\30\1\0\1\30\1\0\3\30\20\0\1\30\3\0"+
    "\1\30\1\0\1\30\1\0\4\30\11\0\16\30\1\u0189"+
    "\3\30\3\0\1\30\1\0\1\30\1\0\3\30\20\0"+
    "\1\30\3\0\1\30\1\0\1\30\1\0\4\30\11\0"+
    "\13\30\1\u018a\6\30\3\0\1\30\1\0\1\30\1\0"+
    "\3\30\20\0\1\30\3\0\1\30\1\0\1\30\1\0"+
    "\4\30\11\0\1\u018b\21\30\3\0\1\30\1\0\1\30"+
    "\1\0\3\30\20\0\1\30\3\0\1\30\1\0\1\u018c"+
    "\1\0\4\30\11\0\22\30\3\0\1\30\1\0\1\30"+
    "\1\0\3\30\20\0\1\30\5\0\1\u018d\2\0\3\u018d"+
    "\1\0\1\u0142\7\0\22\u018d\3\0\1\u018d\1\0\1\u018d"+
    "\1\0\3\u018d\20\0\1\u018d\32\0\1\u018e\61\0\3\u0144"+
    "\60\0\1\u0146\66\0\1\u018f\65\0\1\u0190\44\0\1\u0148"+
    "\100\0\1\u014a\132\0\1\u0191\33\0\11\121\1\u014d\1\121"+
    "\1\u014d\1\355\1\121\1\356\1\121\1\357\60\121\42\0"+
    "\1\u0192\60\0\1\u0193\57\0\1\30\1\0\1\30\1\0"+
    "\4\30\11\0\5\30\1\u0194\14\30\3\0\1\30\1\0"+
    "\1\30\1\0\3\30\20\0\1\30\3\0\1\30\1\0"+
    "\1\30\1\0\4\30\11\0\3\30\1\u0195\16\30\3\0"+
    "\1\30\1\0\1\30\1\0\3\30\20\0\1\30\3\0"+
    "\1\30\1\0\1\u0196\1\0\4\30\11\0\22\30\3\0"+
    "\1\30\1\0\1\30\1\0\3\30\20\0\1\30\3\0"+
    "\1\30\1\0\1\30\1\0\4\30\11\0\7\30\1\u0197"+
    "\12\30\3\0\1\30\1\0\1\30\1\0\3\30\20\0"+
    "\1\30\3\0\1\30\1\0\1\30\1\0\4\30\11\0"+
    "\15\30\1\u0198\4\30\3\0\1\30\1\0\1\30\1\0"+
    "\3\30\20\0\1\30\3\0\1\30\1\0\1\30\1\0"+
    "\4\30\11\0\14\30\1\u0199\5\30\3\0\1\30\1\0"+
    "\1\30\1\0\3\30\20\0\1\30\3\0\1\30\1\0"+
    "\1\30\1\0\4\30\11\0\1\u019a\21\30\3\0\1\30"+
    "\1\0\1\30\1\0\3\30\20\0\1\30\3\0\1\30"+
    "\1\0\1\30\1\0\4\30\11\0\12\30\1\u019b\7\30"+
    "\3\0\1\30\1\0\1\30\1\0\3\30\20\0\1\30"+
    "\3\0\1\30\1\0\1\30\1\0\4\30\11\0\17\30"+
    "\1\u019c\2\30\3\0\1\30\1\0\1\30\1\0\3\30"+
    "\20\0\1\30\3\0\1\30\1\0\1\30\1\0\4\30"+
    "\11\0\11\30\1\u019d\10\30\3\0\1\30\1\0\1\30"+
    "\1\0\3\30\20\0\1\30\3\0\1\30\1\0\1\30"+
    "\1\0\4\30\11\0\4\30\1\u019e\15\30\3\0\1\30"+
    "\1\0\1\30\1\0\3\30\20\0\1\30\3\0\1\30"+
    "\1\0\1\30\1\0\4\30\11\0\13\30\1\u019f\6\30"+
    "\3\0\1\30\1\0\1\30\1\0\3\30\20\0\1\30"+
    "\3\0\1\30\1\0\1\30\1\0\4\30\11\0\1\30"+
    "\1\u01a0\20\30\3\0\1\30\1\0\1\30\1\0\3\30"+
    "\20\0\1\30\3\0\1\30\1\0\1\u01a1\1\0\4\30"+
    "\11\0\22\30\3\0\1\30\1\0\1\30\1\0\3\30"+
    "\20\0\1\30\3\0\1\30\1\0\1\30\1\0\4\30"+
    "\11\0\15\30\1\u01a2\4\30\3\0\1\30\1\0\1\30"+
    "\1\0\3\30\20\0\1\30\3\0\1\30\1\0\1\30"+
    "\1\0\4\30\11\0\5\30\1\u01a3\14\30\3\0\1\30"+
    "\1\0\1\30\1\0\3\30\20\0\1\30\3\0\1\30"+
    "\1\0\1\30\1\0\4\30\11\0\4\30\1\u01a4\15\30"+
    "\3\0\1\30\1\0\1\30\1\0\3\30\20\0\1\30"+
    "\3\0\1\30\1\0\1\30\1\0\4\30\11\0\13\30"+
    "\1\u01a5\6\30\3\0\1\30\1\0\1\30\1\0\3\30"+
    "\20\0\1\30\3\0\1\30\1\0\1\30\1\0\4\30"+
    "\11\0\16\30\1\u01a6\3\30\3\0\1\30\1\0\1\30"+
    "\1\0\3\30\20\0\1\30\3\0\1\30\1\0\1\30"+
    "\1\0\4\30\11\0\1\30\1\u01a7\20\30\3\0\1\30"+
    "\1\0\1\30\1\0\3\30\20\0\1\30\3\0\1\30"+
    "\1\0\1\30\1\0\4\30\11\0\13\30\1\u01a8\6\30"+
    "\3\0\1\30\1\0\1\30\1\0\3\30\20\0\1\30"+
    "\3\0\1\30\1\0\1\30\1\0\4\30\11\0\1\30"+
    "\1\u01a9\20\30\3\0\1\30\1\0\1\30\1\0\3\30"+
    "\20\0\1\30\3\0\1\30\1\0\1\30\1\0\4\30"+
    "\11\0\1\u01aa\21\30\3\0\1\30\1\0\1\30\1\0"+
    "\3\30\20\0\1\30\3\0\1\30\1\0\1\30\1\0"+
    "\4\30\11\0\1\30\1\u01ab\20\30\3\0\1\30\1\0"+
    "\1\30\1\0\3\30\20\0\1\30\3\0\1\30\1\0"+
    "\1\30\1\0\4\30\11\0\14\30\1\u01ac\5\30\3\0"+
    "\1\30\1\0\1\30\1\0\3\30\20\0\1\30\3\0"+
    "\1\30\1\0\1\u01ad\1\0\4\30\11\0\22\30\3\0"+
    "\1\30\1\0\1\30\1\0\3\30\20\0\1\30\3\0"+
    "\1\30\1\0\1\30\1\0\4\30\11\0\10\30\1\u01ae"+
    "\11\30\3\0\1\30\1\0\1\30\1\0\3\30\20\0"+
    "\1\u01ae\3\0\1\30\1\0\1\30\1\0\4\30\11\0"+
    "\1\u01af\21\30\3\0\1\30\1\0\1\30\1\0\3\30"+
    "\20\0\1\30\3\0\1\30\1\0\1\30\1\0\4\30"+
    "\11\0\6\30\1\u01b0\13\30\3\0\1\30\1\0\1\30"+
    "\1\0\3\30\20\0\1\30\3\0\1\30\1\0\1\30"+
    "\1\0\4\30\11\0\11\30\1\u01b1\10\30\3\0\1\30"+
    "\1\0\1\30\1\0\3\30\20\0\1\30\3\0\1\30"+
    "\1\0\1\30\1\0\4\30\11\0\1\u01b2\21\30\3\0"+
    "\1\30\1\0\1\30\1\0\3\30\20\0\1\30\3\0"+
    "\1\30\1\0\1\30\1\0\4\30\11\0\11\30\1\u01b3"+
    "\10\30\3\0\1\30\1\0\1\30\1\0\3\30\20\0"+
    "\1\30\3\0\1\30\1\0\1\30\1\0\4\30\11\0"+
    "\12\30\1\u01b4\7\30\3\0\1\30\1\0\1\30\1\0"+
    "\3\30\20\0\1\30\3\0\1\30\1\0\1\u01b5\1\0"+
    "\4\30\11\0\22\30\3\0\1\30\1\0\1\30\1\0"+
    "\3\30\20\0\1\30\3\0\1\30\1\0\1\30\1\0"+
    "\4\30\11\0\1\u01b6\21\30\3\0\1\30\1\0\1\30"+
    "\1\0\3\30\20\0\1\30\3\0\1\30\1\0\1\30"+
    "\1\0\4\30\11\0\1\30\1\u01b7\20\30\3\0\1\30"+
    "\1\0\1\30\1\0\3\30\20\0\1\30\3\0\1\30"+
    "\1\0\1\30\1\0\4\30\11\0\13\30\1\u01b8\6\30"+
    "\3\0\1\30\1\0\1\30\1\0\3\30\20\0\1\30"+
    "\3\0\1\30\1\0\1\u01b9\1\0\4\30\11\0\22\30"+
    "\3\0\1\30\1\0\1\30\1\0\3\30\20\0\1\30"+
    "\37\0\1\u01ba\103\0\1\u01bb\43\0\1\u01bc\6\0\1\u01bd"+
    "\37\0\1\u01be\35\0\1\u01bf\126\0\1\u01c0\46\0\1\u01c1"+
    "\100\0\1\u01c2\117\0\1\u01c3\116\0\1\u01c4\75\0\1\u01c5"+
    "\44\0\1\30\1\0\1\30\1\0\4\30\11\0\13\30"+
    "\1\u01c6\6\30\3\0\1\30\1\0\1\30\1\0\3\30"+
    "\20\0\1\30\3\0\1\30\1\0\1\30\1\0\4\30"+
    "\11\0\16\30\1\u01c7\3\30\3\0\1\30\1\0\1\30"+
    "\1\0\3\30\20\0\1\30\3\0\1\30\1\0\1\30"+
    "\1\0\4\30\11\0\5\30\1\u01c8\14\30\3\0\1\30"+
    "\1\0\1\30\1\0\3\30\20\0\1\30\3\0\1\30"+
    "\1\0\1\30\1\0\4\30\11\0\13\30\1\u01c9\6\30"+
    "\3\0\1\30\1\0\1\30\1\0\3\30\20\0\1\30"+
    "\3\0\1\30\1\0\1\30\1\0\4\30\11\0\16\30"+
    "\1\u01ca\3\30\3\0\1\30\1\0\1\30\1\0\3\30"+
    "\20\0\1\30\3\0\1\30\1\0\1\30\1\0\4\30"+
    "\11\0\5\30\1\u01cb\14\30\3\0\1\30\1\0\1\30"+
    "\1\0\3\30\20\0\1\30\3\0\1\30\1\0\1\30"+
    "\1\0\4\30\11\0\1\30\1\u01cc\20\30\3\0\1\30"+
    "\1\0\1\30\1\0\3\30\20\0\1\30\3\0\1\u018d"+
    "\1\0\1\u018d\1\0\4\u018d\1\u01cd\1\0\1\u01ce\6\0"+
    "\22\u018d\3\0\1\u018d\1\0\1\u018d\1\0\3\u018d\20\0"+
    "\1\u018d\35\0\1\u01cf\102\0\1\u01d0\46\0\1\u01d1\2\0"+
    "\3\u01d1\11\0\22\u01d1\3\0\1\u01d1\1\0\1\u01d1\1\0"+
    "\3\u01d1\20\0\1\u01d1\13\0\1\u01d2\2\u01d3\127\0\1\u01d4"+
    "\37\0\1\30\1\0\1\30\1\0\4\30\11\0\2\30"+
    "\1\u01d5\17\30\3\0\1\30\1\0\1\30\1\0\3\30"+
    "\20\0\1\30\3\0\1\30\1\0\1\30\1\0\4\30"+
    "\11\0\6\30\1\u01d6\13\30\3\0\1\30\1\0\1\30"+
    "\1\0\3\30\20\0\1\30\3\0\1\30\1\0\1\30"+
    "\1\0\4\30\11\0\11\30\1\u01d7\10\30\3\0\1\30"+
    "\1\0\1\30\1\0\3\30\20\0\1\30\3\0\1\30"+
    "\1\0\1\30\1\0\4\30\11\0\1\u01d8\21\30\3\0"+
    "\1\30\1\0\1\30\1\0\3\30\20\0\1\30\3\0"+
    "\1\30\1\0\1\30\1\0\4\30\11\0\1\u01d9\21\30"+
    "\3\0\1\30\1\0\1\30\1\0\3\30\20\0\1\30"+
    "\3\0\1\30\1\0\1\30\1\0\4\30\11\0\3\30"+
    "\1\u01da\16\30\3\0\1\30\1\0\1\30\1\0\3\30"+
    "\20\0\1\30\3\0\1\30\1\0\1\30\1\0\4\30"+
    "\11\0\3\30\1\u01db\16\30\3\0\1\30\1\0\1\30"+
    "\1\0\3\30\20\0\1\30\3\0\1\30\1\0\1\30"+
    "\1\0\4\30\11\0\2\30\1\u01dc\17\30\3\0\1\30"+
    "\1\0\1\30\1\0\3\30\20\0\1\30\3\0\1\30"+
    "\1\0\1\30\1\0\4\30\11\0\5\30\1\u01dd\14\30"+
    "\3\0\1\30\1\0\1\30\1\0\3\30\20\0\1\30"+
    "\3\0\1\30\1\0\1\30\1\0\4\30\11\0\21\30"+
    "\1\u01de\3\0\1\30\1\0\1\30\1\0\3\30\20\0"+
    "\1\30\3\0\1\30\1\0\1\u01df\1\0\4\30\11\0"+
    "\22\30\3\0\1\30\1\0\1\30\1\0\3\30\20\0"+
    "\1\30\3\0\1\30\1\0\1\30\1\0\4\30\11\0"+
    "\16\30\1\u01e0\3\30\3\0\1\30\1\0\1\30\1\0"+
    "\3\30\20\0\1\30\3\0\1\30\1\0\1\30\1\0"+
    "\4\30\11\0\11\30\1\u01e1\10\30\3\0\1\30\1\0"+
    "\1\30\1\0\3\30\20\0\1\30\3\0\1\30\1\0"+
    "\1\30\1\0\4\30\11\0\1\u01e2\21\30\3\0\1\30"+
    "\1\0\1\30\1\0\3\30\20\0\1\30\3\0\1\30"+
    "\1\0\1\30\1\0\4\30\11\0\6\30\1\u01e3\13\30"+
    "\3\0\1\30\1\0\1\30\1\0\3\30\20\0\1\30"+
    "\3\0\1\30\1\0\1\30\1\0\4\30\11\0\5\30"+
    "\1\u01e4\14\30\3\0\1\30\1\0\1\30\1\0\3\30"+
    "\20\0\1\30\3\0\1\30\1\0\1\30\1\0\4\30"+
    "\11\0\6\30\1\u01e5\13\30\3\0\1\30\1\0\1\30"+
    "\1\0\3\30\20\0\1\30\3\0\1\30\1\0\1\30"+
    "\1\0\4\30\11\0\14\30\1\u01e6\5\30\3\0\1\30"+
    "\1\0\1\30\1\0\3\30\20\0\1\30\3\0\1\30"+
    "\1\0\1\30\1\0\4\30\11\0\5\30\1\u01e7\14\30"+
    "\3\0\1\30\1\0\1\30\1\0\3\30\20\0\1\30"+
    "\3\0\1\30\1\0\1\30\1\0\4\30\11\0\11\30"+
    "\1\u01e8\10\30\3\0\1\30\1\0\1\30\1\0\3\30"+
    "\20\0\1\30\3\0\1\30\1\0\1\30\1\0\4\30"+
    "\11\0\13\30\1\u01e9\6\30\3\0\1\30\1\0\1\30"+
    "\1\0\3\30\20\0\1\30\3\0\1\30\1\0\1\30"+
    "\1\0\4\30\11\0\6\30\1\u01ea\13\30\3\0\1\30"+
    "\1\0\1\30\1\0\3\30\20\0\1\30\3\0\1\30"+
    "\1\0\1\30\1\0\4\30\11\0\1\30\1\u01eb\20\30"+
    "\3\0\1\30\1\0\1\30\1\0\3\30\20\0\1\30"+
    "\3\0\1\30\1\0\1\30\1\0\4\30\11\0\6\30"+
    "\1\u01ec\13\30\3\0\1\30\1\0\1\30\1\0\3\30"+
    "\20\0\1\30\35\0\1\u01ed\50\0\1\u01ee\6\0\1\u01ef"+
    "\37\0\1\u01f0\77\0\1\u01f1\41\0\1\u01bd\37\0\1\u01be"+
    "\66\0\1\u01f2\63\0\1\u01c4\100\0\1\u01f3\105\0\1\u01f4"+
    "\77\0\1\u01f5\63\0\1\u01c4\37\0\1\u01f6\62\0\1\u01f7"+
    "\45\0\1\30\1\0\1\30\1\0\4\30\11\0\16\30"+
    "\1\u01f8\3\30\3\0\1\30\1\0\1\30\1\0\3\30"+
    "\20\0\1\30\3\0\1\30\1\0\1\u01f9\1\0\4\30"+
    "\11\0\22\30\3\0\1\30\1\0\1\30\1\0\3\30"+
    "\20\0\1\30\3\0\1\30\1\0\1\30\1\0\4\30"+
    "\11\0\6\30\1\u01fa\13\30\3\0\1\30\1\0\1\30"+
    "\1\0\3\30\20\0\1\30\3\0\1\30\1\0\1\30"+
    "\1\0\4\30\11\0\10\30\1\u01fb\11\30\3\0\1\30"+
    "\1\0\1\30\1\0\3\30\20\0\1\u01fb\3\0\1\30"+
    "\1\0\1\30\1\0\4\30\11\0\1\30\1\u01fc\20\30"+
    "\3\0\1\30\1\0\1\30\1\0\3\30\20\0\1\30"+
    "\3\0\1\30\1\0\1\u01fd\1\0\4\30\11\0\22\30"+
    "\3\0\1\30\1\0\1\30\1\0\3\30\20\0\1\30"+
    "\3\0\1\30\1\0\1\30\1\0\4\30\11\0\14\30"+
    "\1\u01fe\5\30\3\0\1\30\1\0\1\30\1\0\3\30"+
    "\20\0\1\30\15\0\1\u01ce\107\0\1\u01ff\111\0\1\u0200"+
    "\60\0\1\u01d3\110\0\1\u0201\56\0\1\30\1\0\1\30"+
    "\1\0\4\30\11\0\10\30\1\u0202\11\30\3\0\1\30"+
    "\1\0\1\30\1\0\3\30\20\0\1\u0202\3\0\1\30"+
    "\1\0\1\30\1\0\4\30\11\0\16\30\1\u0203\3\30"+
    "\3\0\1\30\1\0\1\30\1\0\3\30\20\0\1\30"+
    "\3\0\1\30\1\0\1\u0204\1\0\4\30\11\0\22\30"+
    "\3\0\1\30\1\0\1\30\1\0\3\30\20\0\1\30"+
    "\3\0\1\30\1\0\1\30\1\0\4\30\11\0\1\30"+
    "\1\u0205\20\30\3\0\1\30\1\0\1\30\1\0\3\30"+
    "\20\0\1\30\3\0\1\30\1\0\1\30\1\0\4\30"+
    "\11\0\16\30\1\u0206\3\30\3\0\1\30\1\0\1\30"+
    "\1\0\3\30\20\0\1\30\3\0\1\30\1\0\1\30"+
    "\1\0\4\30\11\0\13\30\1\u0207\6\30\3\0\1\30"+
    "\1\0\1\30\1\0\3\30\20\0\1\30\3\0\1\30"+
    "\1\0\1\u0208\1\0\4\30\11\0\22\30\3\0\1\30"+
    "\1\0\1\30\1\0\3\30\20\0\1\30\3\0\1\30"+
    "\1\0\1\30\1\0\4\30\11\0\6\30\1\u0209\13\30"+
    "\3\0\1\30\1\0\1\30\1\0\3\30\20\0\1\30"+
    "\3\0\1\30\1\0\1\u020a\1\0\4\30\11\0\22\30"+
    "\3\0\1\30\1\0\1\30\1\0\3\30\20\0\1\30"+
    "\3\0\1\30\1\0\1\30\1\0\4\30\11\0\1\30"+
    "\1\u020b\20\30\3\0\1\30\1\0\1\30\1\0\3\30"+
    "\20\0\1\30\3\0\1\30\1\0\1\u020c\1\0\4\30"+
    "\11\0\22\30\3\0\1\30\1\0\1\30\1\0\3\30"+
    "\20\0\1\30\3\0\1\30\1\0\1\30\1\0\4\30"+
    "\11\0\7\30\1\u020d\12\30\3\0\1\30\1\0\1\30"+
    "\1\0\3\30\20\0\1\30\3\0\1\30\1\0\1\30"+
    "\1\0\4\30\11\0\14\30\1\u020e\5\30\3\0\1\30"+
    "\1\0\1\30\1\0\3\30\20\0\1\30\3\0\1\30"+
    "\1\0\1\30\1\0\4\30\11\0\4\30\1\u020f\15\30"+
    "\3\0\1\30\1\0\1\30\1\0\3\30\20\0\1\30"+
    "\3\0\1\30\1\0\1\u0210\1\0\4\30\11\0\22\30"+
    "\3\0\1\30\1\0\1\30\1\0\3\30\20\0\1\30"+
    "\3\0\1\30\1\0\1\30\1\0\4\30\11\0\6\30"+
    "\1\u0211\13\30\3\0\1\30\1\0\1\30\1\0\3\30"+
    "\20\0\1\30\3\0\1\30\1\0\1\u0212\1\0\4\30"+
    "\11\0\22\30\3\0\1\30\1\0\1\30\1\0\3\30"+
    "\20\0\1\30\3\0\1\30\1\0\1\30\1\0\4\30"+
    "\11\0\1\30\1\u0213\20\30\3\0\1\30\1\0\1\30"+
    "\1\0\3\30\20\0\1\30\36\0\1\u0214\101\0\1\u0215"+
    "\55\0\1\u01ef\37\0\1\u01f0\31\0\1\u0216\100\0\1\u01c4"+
    "\107\0\1\u01f3\37\0\1\u0217\51\0\1\u0218\126\0\1\u0214"+
    "\41\0\1\u01f7\37\0\1\u0219\27\0\1\30\1\0\1\30"+
    "\1\0\4\30\11\0\22\30\3\0\1\30\1\0\1\30"+
    "\1\0\1\30\1\u021a\1\30\20\0\1\30\3\0\1\30"+
    "\1\0\1\30\1\0\4\30\11\0\1\30\1\u021b\20\30"+
    "\3\0\1\30\1\0\1\30\1\0\3\30\20\0\1\30"+
    "\3\0\1\30\1\0\1\30\1\0\4\30\11\0\10\30"+
    "\1\u021c\11\30\3\0\1\30\1\0\1\30\1\0\3\30"+
    "\20\0\1\u021c\3\0\1\30\1\0\1\30\1\0\4\30"+
    "\11\0\22\30\3\0\1\30\1\0\1\30\1\0\1\30"+
    "\1\u021d\1\30\20\0\1\30\3\0\1\30\1\0\1\30"+
    "\1\0\4\30\11\0\22\30\3\0\1\30\1\0\1\30"+
    "\1\0\1\30\1\u021e\1\30\20\0\1\30\3\0\1\30"+
    "\1\0\1\30\1\0\4\30\11\0\7\30\1\u021f\12\30"+
    "\3\0\1\30\1\0\1\30\1\0\3\30\20\0\1\30"+
    "\44\0\1\u0220\47\0\3\u0221\76\0\3\u0222\66\0\1\30"+
    "\1\0\1\30\1\0\4\30\11\0\13\30\1\u0223\6\30"+
    "\3\0\1\30\1\0\1\30\1\0\3\30\20\0\1\30"+
    "\3\0\1\30\1\0\1\30\1\0\4\30\11\0\13\30"+
    "\1\u0224\6\30\3\0\1\30\1\0\1\30\1\0\3\30"+
    "\20\0\1\30\3\0\1\30\1\0\1\30\1\0\4\30"+
    "\11\0\6\30\1\u0225\13\30\3\0\1\30\1\0\1\30"+
    "\1\0\3\30\20\0\1\30\3\0\1\30\1\0\1\u0226"+
    "\1\0\4\30\11\0\22\30\3\0\1\30\1\0\1\30"+
    "\1\0\3\30\20\0\1\30\3\0\1\30\1\0\1\30"+
    "\1\0\4\30\11\0\6\30\1\u0227\13\30\3\0\1\30"+
    "\1\0\1\30\1\0\3\30\20\0\1\30\3\0\1\30"+
    "\1\0\1\30\1\0\4\30\11\0\22\30\3\0\1\30"+
    "\1\0\1\30\1\0\1\30\1\u0228\1\30\20\0\1\30"+
    "\3\0\1\30\1\0\1\u0229\1\0\4\30\11\0\22\30"+
    "\3\0\1\30\1\0\1\30\1\0\3\30\20\0\1\30"+
    "\3\0\1\30\1\0\1\30\1\0\4\30\11\0\5\30"+
    "\1\u022a\14\30\3\0\1\30\1\0\1\30\1\0\3\30"+
    "\20\0\1\30\3\0\1\30\1\0\1\30\1\0\4\30"+
    "\11\0\5\30\1\u022b\14\30\3\0\1\30\1\0\1\30"+
    "\1\0\3\30\20\0\1\30\3\0\1\30\1\0\1\u022c"+
    "\1\0\4\30\11\0\22\30\3\0\1\30\1\0\1\30"+
    "\1\0\3\30\20\0\1\30\3\0\1\30\1\0\1\30"+
    "\1\0\4\30\11\0\22\30\3\0\1\30\1\0\1\30"+
    "\1\0\1\30\1\u022d\1\30\20\0\1\30\3\0\1\30"+
    "\1\0\1\30\1\0\4\30\11\0\1\30\1\u022e\20\30"+
    "\3\0\1\30\1\0\1\30\1\0\3\30\20\0\1\30"+
    "\3\0\1\30\1\0\1\u022f\1\0\4\30\11\0\22\30"+
    "\3\0\1\30\1\0\1\30\1\0\3\30\20\0\1\30"+
    "\14\0\1\u0214\37\0\1\u0230\55\0\1\u01ef\104\0\1\u01bd"+
    "\57\0\1\u0218\37\0\1\u0231\27\0\1\30\1\0\1\30"+
    "\1\0\4\30\11\0\22\30\3\0\1\30\1\0\1\30"+
    "\1\0\1\30\1\u0232\1\30\20\0\1\30\3\0\1\30"+
    "\1\0\1\30\1\0\4\30\11\0\1\u0233\21\30\3\0"+
    "\1\30\1\0\1\30\1\0\3\30\20\0\1\30\3\0"+
    "\1\30\1\0\1\30\1\0\4\30\11\0\22\30\3\0"+
    "\1\30\1\0\1\30\1\0\1\30\1\u0234\1\30\20\0"+
    "\1\30\3\0\1\30\1\0\1\30\1\0\4\30\11\0"+
    "\6\30\1\u0235\13\30\3\0\1\30\1\0\1\30\1\0"+
    "\3\30\20\0\1\30\3\0\1\30\1\0\1\30\1\0"+
    "\4\30\11\0\22\30\3\0\1\30\1\0\1\30\1\0"+
    "\1\30\1\u0236\1\30\20\0\1\30\3\0\1\30\1\0"+
    "\1\30\1\0\4\30\11\0\2\30\1\u0237\17\30\3\0"+
    "\1\30\1\0\1\30\1\0\3\30\20\0\1\30\25\0"+
    "\1\u0238\60\0\1\u0239\2\0\3\u0239\3\u0221\1\u023a\5\0"+
    "\22\u0239\3\0\1\u0239\1\0\1\u0239\1\0\3\u0239\20\0"+
    "\1\u0239\13\0\3\u0222\24\0\1\u023b\41\0\1\30\1\0"+
    "\1\30\1\0\4\30\11\0\11\30\1\u023c\10\30\3\0"+
    "\1\30\1\0\1\30\1\0\3\30\20\0\1\30\3\0"+
    "\1\30\1\0\1\30\1\0\4\30\11\0\6\30\1\u023d"+
    "\13\30\3\0\1\30\1\0\1\30\1\0\3\30\20\0"+
    "\1\30\3\0\1\30\1\0\1\30\1\0\4\30\11\0"+
    "\14\30\1\u023e\5\30\3\0\1\30\1\0\1\30\1\0"+
    "\3\30\20\0\1\30\3\0\1\30\1\0\1\u023f\1\0"+
    "\4\30\11\0\22\30\3\0\1\30\1\0\1\30\1\0"+
    "\3\30\20\0\1\30\3\0\1\30\1\0\1\30\1\0"+
    "\4\30\11\0\7\30\1\u0240\12\30\3\0\1\30\1\0"+
    "\1\30\1\0\3\30\20\0\1\30\3\0\1\30\1\0"+
    "\1\30\1\0\4\30\11\0\7\30\1\u0241\12\30\3\0"+
    "\1\30\1\0\1\30\1\0\3\30\20\0\1\30\3\0"+
    "\1\30\1\0\1\30\1\0\4\30\11\0\1\30\1\u0242"+
    "\20\30\3\0\1\30\1\0\1\30\1\0\3\30\20\0"+
    "\1\30\3\0\1\30\1\0\1\30\1\0\4\30\11\0"+
    "\7\30\1\u0243\12\30\3\0\1\30\1\0\1\30\1\0"+
    "\3\30\20\0\1\30\3\0\1\30\1\0\1\30\1\0"+
    "\4\30\11\0\2\30\1\u0244\17\30\3\0\1\30\1\0"+
    "\1\30\1\0\3\30\20\0\1\30\3\0\1\30\1\0"+
    "\1\30\1\0\4\30\11\0\7\30\1\u0245\12\30\3\0"+
    "\1\30\1\0\1\30\1\0\3\30\20\0\1\30\3\0"+
    "\1\30\1\0\1\30\1\0\4\30\11\0\22\30\3\0"+
    "\1\30\1\0\1\30\1\0\1\30\1\u0246\1\30\20\0"+
    "\1\30\3\0\1\30\1\0\1\30\1\0\4\30\11\0"+
    "\7\30\1\u0247\12\30\3\0\1\30\1\0\1\30\1\0"+
    "\3\30\20\0\1\30\3\0\1\30\1\0\1\30\1\0"+
    "\4\30\11\0\22\30\3\0\1\30\1\0\1\30\1\0"+
    "\1\30\1\u0248\1\30\20\0\1\30\13\0\3\u0238\31\0"+
    "\1\334\34\0\1\u0239\1\0\1\u0239\1\0\4\u0239\3\u0249"+
    "\6\0\22\u0239\3\0\1\u0239\1\0\1\u0239\1\0\3\u0239"+
    "\20\0\1\u0239\5\0\1\u0239\2\0\3\u0239\11\0\22\u0239"+
    "\3\0\1\u0239\1\0\1\u0239\1\0\3\u0239\20\0\1\u0239"+
    "\37\0\1\u024a\44\0\1\30\1\0\1\u024b\1\0\4\30"+
    "\11\0\22\30\3\0\1\30\1\0\1\30\1\0\3\30"+
    "\20\0\1\30\3\0\1\30\1\0\1\30\1\0\4\30"+
    "\11\0\14\30\1\u024c\5\30\3\0\1\30\1\0\1\30"+
    "\1\0\3\30\20\0\1\30\3\0\1\30\1\0\1\30"+
    "\1\0\4\30\11\0\5\30\1\u024d\14\30\3\0\1\30"+
    "\1\0\1\30\1\0\3\30\20\0\1\30\3\0\1\30"+
    "\1\0\1\30\1\0\4\30\11\0\3\30\1\u024e\16\30"+
    "\3\0\1\30\1\0\1\30\1\0\3\30\20\0\1\30"+
    "\3\0\1\30\1\0\1\30\1\0\4\30\11\0\10\30"+
    "\1\u024f\11\30\3\0\1\30\1\0\1\30\1\0\3\30"+
    "\20\0\1\u024f\3\0\1\30\1\0\1\30\1\0\4\30"+
    "\11\0\5\30\1\u0250\14\30\3\0\1\30\1\0\1\30"+
    "\1\0\3\30\20\0\1\30\3\0\1\30\1\0\1\30"+
    "\1\0\4\30\11\0\5\30\1\u0251\14\30\3\0\1\30"+
    "\1\0\1\30\1\0\3\30\20\0\1\30\3\0\1\30"+
    "\1\0\1\30\1\0\4\30\11\0\21\30\1\u0252\3\0"+
    "\1\30\1\0\1\30\1\0\3\30\20\0\1\30\3\0"+
    "\1\30\1\0\1\30\1\0\4\30\11\0\22\30\3\0"+
    "\1\30\1\0\1\30\1\0\1\30\1\u0253\1\30\20\0"+
    "\1\30\5\0\1\u0254\2\0\3\u0254\3\u0249\6\0\22\u0254"+
    "\3\0\1\u0254\1\0\1\u0254\1\0\3\u0254\20\0\1\u0254"+
    "\31\0\1\u0255\52\0\1\30\1\0\1\30\1\0\4\30"+
    "\11\0\6\30\1\u0256\13\30\3\0\1\30\1\0\1\30"+
    "\1\0\3\30\20\0\1\30\3\0\1\30\1\0\1\30"+
    "\1\0\4\30\11\0\6\30\1\u0257\13\30\3\0\1\30"+
    "\1\0\1\30\1\0\3\30\20\0\1\30\3\0\1\30"+
    "\1\0\1\30\1\0\4\30\11\0\22\30\3\0\1\30"+
    "\1\0\1\30\1\0\1\30\1\u0258\1\30\20\0\1\30"+
    "\3\0\1\30\1\0\1\30\1\0\4\30\11\0\20\30"+
    "\1\u0259\1\30\3\0\1\30\1\0\1\30\1\0\3\30"+
    "\20\0\1\30\3\0\1\u0254\1\0\1\u0254\1\0\4\u0254"+
    "\3\u025a\6\0\22\u0254\3\0\1\u0254\1\0\1\u0254\1\0"+
    "\3\u0254\3\0\1\u025b\14\0\1\u0254\53\0\1\u025c\30\0"+
    "\1\30\1\0\1\u025d\1\0\4\30\11\0\22\30\3\0"+
    "\1\30\1\0\1\30\1\0\3\30\20\0\1\30\3\0"+
    "\1\30\1\0\1\u025e\1\0\4\30\11\0\22\30\3\0"+
    "\1\30\1\0\1\30\1\0\3\30\20\0\1\30\3\0"+
    "\1\30\1\0\1\30\1\0\4\30\11\0\22\30\3\0"+
    "\1\30\1\0\1\30\1\0\1\30\1\u025f\1\30\20\0"+
    "\1\30\3\0\1\30\1\0\1\30\1\0\4\30\11\0"+
    "\1\u0260\21\30\3\0\1\30\1\0\1\30\1\0\3\30"+
    "\20\0\1\30\13\0\3\u025a\45\0\1\u025b\101\0\1\u0261"+
    "\44\0\1\u0262\53\0\1\30\1\0\1\30\1\0\4\30"+
    "\11\0\16\30\1\u0263\3\30\3\0\1\30\1\0\1\30"+
    "\1\0\3\30\20\0\1\30\37\0\1\u0264\44\0\1\30"+
    "\1\0\1\u0265\1\0\4\30\11\0\22\30\3\0\1\30"+
    "\1\0\1\30\1\0\3\30\20\0\1\30\53\0\1\u0266"+
    "\30\0\1\30\1\0\1\30\1\0\4\30\11\0\11\30"+
    "\1\u0267\10\30\3\0\1\30\1\0\1\30\1\0\3\30"+
    "\20\0\1\30\5\0\1\u0268\106\0\3\u0268\42\0\1\u0269"+
    "\33\0\3\u0269\1\0\1\u026a\24\0\1\u026b\34\0\1\u026c"+
    "\43\0\1\u026d\74\0\1\u026e\104\0\1\u026f\74\0\1\u0270"+
    "\104\0\1\u0271\74\0\1\u0272\104\0\1\u0273\47\0\3\u0271"+
    "\31\0\1\u0274\75\0\1\u0275\53\0\1\u0271\162\0\1\u0271"+
    "\1\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[29900];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\4\0\1\1\10\0\2\1\1\11\13\1\3\11\24\1"+
    "\1\11\12\1\4\11\1\1\2\11\1\1\1\11\2\1"+
    "\1\11\5\1\1\11\6\1\1\11\1\1\2\11\2\1"+
    "\1\11\2\1\2\11\1\1\24\11\2\1\1\11\4\1"+
    "\2\11\1\1\1\0\4\1\1\0\1\11\6\1\2\11"+
    "\1\0\2\1\2\0\1\1\2\0\1\11\2\0\36\1"+
    "\3\11\1\1\2\11\1\1\12\0\2\1\1\11\2\1"+
    "\2\11\1\1\1\0\2\11\2\1\6\11\1\1\4\0"+
    "\2\1\3\11\1\1\3\0\1\1\1\11\1\1\3\0"+
    "\3\1\1\0\1\11\1\0\1\11\1\1\1\0\4\11"+
    "\2\0\1\1\1\0\12\1\1\0\41\1\1\11\1\1"+
    "\12\0\6\1\3\11\3\0\1\1\1\0\1\1\1\11"+
    "\1\1\1\11\1\0\2\11\2\1\2\0\52\1\12\0"+
    "\7\1\2\0\1\11\4\0\46\1\4\0\1\11\7\0"+
    "\10\1\1\11\2\0\1\11\1\1\1\11\1\0\30\1"+
    "\3\0\1\11\5\0\1\11\1\0\7\1\3\0\22\1"+
    "\3\0\1\11\1\0\1\11\6\1\3\0\15\1\2\11"+
    "\6\1\4\0\15\1\2\0\11\1\2\0\4\1\3\0"+
    "\4\1\1\11\1\0\1\1\1\0\1\1\1\0\1\1"+
    "\14\0\1\11\1\0";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[629];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the textposition at the last state to be included in yytext */
  private int zzPushbackPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;

  /* user code: */
	private final LinkedList commentList = new LinkedList();
	private String heredoc = null;
    private boolean asp_tags = false;
    private boolean short_tags_allowed = true;
    private StateStack stack = new StateStack();
    private char yy_old_buffer[] = new char[ZZ_BUFFERSIZE];
    private int yy_old_pushbackPos;
    protected int commentStartPosition;

	private AST ast;

    public void setAST(AST ast) {
    	this.ast = ast;
    }
    
	public PHPVersion getPHPVersion() {
		return PHPVersion.PHP5;
	}
    
	public void setInScriptingState() {
		yybegin(ST_IN_SCRIPTING);
	}

	public void resetCommentList() {
		commentList.clear();
	}
	
	public LinkedList getCommentList() {
		return commentList;
	}	
	
	protected void addComment(int type) {
		int leftPosition = getTokenStartPosition();
		Comment comment = new Comment(commentStartPosition, leftPosition + getTokenLength(), ast, type);
		commentList.add(comment);
	}	
	
	public void setUseAspTagsAsPhp(boolean useAspTagsAsPhp) {
		asp_tags = useAspTagsAsPhp;
	}
	
    private void pushState(int state) {
        stack.pushStack(zzLexicalState);
        yybegin(state);
    }

    private void popState() {
        yybegin(stack.popStack());
    }

    public int getCurrentLine() {
        return yyline;
    }

    protected int getTokenStartPosition() {
        return zzStartRead - zzPushbackPos;
    }

    protected int getTokenLength() {
        return zzMarkedPos - zzStartRead;
    }

    public int getLength() {
        return zzEndRead - zzPushbackPos;
    }
    
    private void handleCommentStart() {
		commentStartPosition = getTokenStartPosition();
	}
	
	private void handleLineCommentEnd() {
         addComment(Comment.TYPE_SINGLE_LINE);
    }
    
    private void handleMultilineCommentEnd() {
    	addComment(Comment.TYPE_MULTILINE);
    }

    private void handlePHPDocEnd() {
		addComment(Comment.TYPE_PHPDOC);
    }
    
    protected void handleVarComment() {
    	commentStartPosition = zzStartRead;
    	addComment(Comment.TYPE_MULTILINE);
    }
        
    private Symbol createFullSymbol(int symbolNumber) {
        Symbol symbol = createSymbol(symbolNumber);
        symbol.value = yytext();
        return symbol;
    }

    protected Symbol createSymbol(int symbolNumber) {
        int leftPosition = getTokenStartPosition();
        return new Symbol(symbolNumber, leftPosition, leftPosition + getTokenLength());
    }

    public int[] getParamenters(){
    	return new int[]{zzMarkedPos, zzPushbackPos, zzCurrentPos, zzStartRead, zzEndRead, yyline};
    }
    
	protected boolean parsePHPDoc(){	
		final IDocumentorLexer documentorLexer = getDocumentorLexer(zzReader);
		if(documentorLexer == null){
			return false;
		}
		yypushback(zzMarkedPos - zzStartRead);
		int[] parameters = getParamenters();
		documentorLexer.reset(zzReader, zzBuffer, parameters);
		Object phpDocBlock = documentorLexer.parse();
		commentList.add(phpDocBlock);
		reset(zzReader, documentorLexer.getBuffer(), documentorLexer.getParamenters());
		return true;
	}
	
	
	protected IDocumentorLexer getDocumentorLexer(java.io.Reader  reader) {
		return null;
	}
	
	public void reset(java.io.Reader  reader, char[] buffer, int[] parameters){
		this.zzReader = reader;
		this.zzBuffer = buffer;
		this.zzMarkedPos = parameters[0];
		this.zzPushbackPos = parameters[1];
		this.zzCurrentPos = parameters[2];
		this.zzStartRead = parameters[3];
		this.zzEndRead = parameters[4];
		this.yyline = parameters[5];  
		this.yychar = this.zzStartRead - this.zzPushbackPos;
	}



  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public PhpAstLexer(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public PhpAstLexer(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 190) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzPushbackPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzCurrentPos*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = zzReader.read(zzBuffer, zzEndRead,
                                            zzBuffer.length-zzEndRead);

    if (numRead < 0) {
      return true;
    }
    else {
      zzEndRead+= numRead;
      return false;
    }
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = zzPushbackPos = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Contains user EOF-code, which will be executed exactly once,
   * when the end of file is reached
   */
  private void zzDoEOF() throws java.io.IOException {
    if (!zzEOFDone) {
      zzEOFDone = true;
      yyclose();
    }
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public java_cup.runtime.Symbol next_token() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      boolean zzR = false;
      for (zzCurrentPosL = zzStartRead; zzCurrentPosL < zzMarkedPosL;
                                                             zzCurrentPosL++) {
        switch (zzBufferL[zzCurrentPosL]) {
        case '\u000B':
        case '\u000C':
        case '\u0085':
        case '\u2028':
        case '\u2029':
          yyline++;
          zzR = false;
          break;
        case '\r':
          yyline++;
          zzR = true;
          break;
        case '\n':
          if (zzR)
            zzR = false;
          else {
            yyline++;
          }
          break;
        default:
          zzR = false;
        }
      }

      if (zzR) {
        // peek one character ahead if it is \n (if we have counted one line too much)
        boolean zzPeek;
        if (zzMarkedPosL < zzEndReadL)
          zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        else if (zzAtEOF)
          zzPeek = false;
        else {
          boolean eof = zzRefill();
          zzEndReadL = zzEndRead;
          zzMarkedPosL = zzMarkedPos;
          zzBufferL = zzBuffer;
          if (eof) 
            zzPeek = false;
          else 
            zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        }
        if (zzPeek) yyline--;
      }
      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = zzLexicalState;


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 63: 
          { return createSymbol(ParserConstants.T_LOGICAL_OR);
          }
        case 178: break;
        case 41: 
          { popState();
    return createFullSymbol(ParserConstants.T_STRING);
          }
        case 179: break;
        case 152: 
          { return createSymbol(ParserConstants.T_REQUIRE);
          }
        case 180: break;
        case 55: 
          { return createFullSymbol(ParserConstants.T_DNUMBER);
          }
        case 181: break;
        case 165: 
          { return createSymbol(ParserConstants.T_INTERFACE);
          }
        case 182: break;
        case 88: 
          { pushState(ST_LOOKING_FOR_VARNAME);
    return createSymbol(ParserConstants.T_DOLLAR_OPEN_CURLY_BRACES);
          }
        case 183: break;
        case 47: 
          { return createSymbol(ParserConstants.T_BACKQUATE);
          }
        case 184: break;
        case 22: 
          { return createSymbol(ParserConstants.T_TIMES);
          }
        case 185: break;
        case 57: 
          { return createSymbol(ParserConstants.T_INC);
          }
        case 186: break;
        case 35: 
          { handleCommentStart();
	yybegin(ST_ONE_LINE_COMMENT);
//	yymore();
          }
        case 187: break;
        case 125: 
          { return createSymbol(ParserConstants.T_UNSET);
          }
        case 188: break;
        case 26: 
          { return createSymbol(ParserConstants.T_OR);
          }
        case 189: break;
        case 16: 
          { return createSymbol(ParserConstants.T_NEKUDOTAIM);
          }
        case 190: break;
        case 51: 
          { //	yymore();
          }
        case 191: break;
        case 59: 
          { return createFullSymbol(ParserConstants.T_VARIABLE);
          }
        case 192: break;
        case 38: 
          { yypushback(1);
	yybegin(ST_HEREDOC);
          }
        case 193: break;
        case 34: 
          { /* This is a temporary fix which is dependant on flex and it's implementation */
    if (!stack.isEmpty()) {
        popState();
    }
    return createSymbol(ParserConstants.T_CURLY_CLOSE);
          }
        case 194: break;
        case 40: 
          { yypushback(yylength());
    popState();
          }
        case 195: break;
        case 77: 
          { return createSymbol(ParserConstants.T_DIV_EQUAL);
          }
        case 196: break;
        case 92: 
          { return createSymbol(ParserConstants.T_OBJECT_OPERATOR);
          }
        case 197: break;
        case 12: 
          { pushState(ST_IN_SCRIPTING);
    return createSymbol(ParserConstants.T_CURLY_OPEN);
          }
        case 198: break;
        case 86: 
          { yybegin(YYINITIAL);
    return createSymbol(ParserConstants.T_SEMICOLON);  /* implicit ';' at php-end tag */
          }
        case 199: break;
        case 105: 
          { return createSymbol(ParserConstants.T_SR_EQUAL);
          }
        case 200: break;
        case 79: 
          { if (asp_tags) {
        yybegin(YYINITIAL);
        return createSymbol(ParserConstants.T_SEMICOLON);  /* implicit ';' at php-end tag */
    } else {
        return createSymbol(ParserConstants.T_INLINE_HTML);
    }
          }
        case 201: break;
        case 167: 
          { return createSymbol(ParserConstants.T_CLASS_C);
          }
        case 202: break;
        case 11: 
          { yybegin(ST_BACKQUOTE);
    return createSymbol(ParserConstants.T_BACKQUATE);
          }
        case 203: break;
        case 176: 
          { handleVarComment();
    return createFullSymbol(ParserConstants.T_VAR_COMMENT);
          }
        case 204: break;
        case 109: 
          { return createSymbol(ParserConstants.T_SL_EQUAL);
          }
        case 205: break;
        case 114: 
          { return createSymbol(ParserConstants.T_ELSE);
          }
        case 206: break;
        case 146: 
          { return createSymbol(ParserConstants.T_GLOBAL);
          }
        case 207: break;
        case 121: 
          { return createSymbol(ParserConstants.T_BREAK);
          }
        case 208: break;
        case 62: 
          { return createSymbol(ParserConstants.T_DO);
          }
        case 209: break;
        case 20: 
          { return createSymbol(ParserConstants.T_NOT);
          }
        case 210: break;
        case 117: 
          { return createSymbol(ParserConstants.T_LIST);
          }
        case 211: break;
        case 126: 
          { return createSymbol(ParserConstants.T_CONST);
          }
        case 212: break;
        case 175: 
          { return createSymbol(ParserConstants.T_FUNC_C);
          }
        case 213: break;
        case 32: 
          { return createSymbol(ParserConstants.T_QUESTION_MARK);
          }
        case 214: break;
        case 145: 
          { return createSymbol(ParserConstants.T_DOUBLE_CAST);
          }
        case 215: break;
        case 169: 
          { return createSymbol(ParserConstants.T_ENDFOREACH);
          }
        case 216: break;
        case 36: 
          { yybegin(ST_IN_SCRIPTING);
    return createSymbol(ParserConstants.T_QUATE);
          }
        case 217: break;
        case 140: 
          { return createSymbol(ParserConstants.T_STATIC);
          }
        case 218: break;
        case 113: 
          { return createSymbol(ParserConstants.T_ECHO);
          }
        case 219: break;
        case 52: 
          { String yytext = yytext();
	switch (yytext.charAt(yytext.length() - 1)) {
		case '?':
		case '%':
		case '>':
			yypushback(1);
			break;
		default:
			handleLineCommentEnd();
			yybegin(ST_IN_SCRIPTING);
	}
//	yymore();
          }
        case 220: break;
        case 45: 
          { yypushback(1);
	popState();
	return createSymbol(ParserConstants.T_ENCAPSED_AND_WHITESPACE);
          }
        case 221: break;
        case 142: 
          { return createSymbol(ParserConstants.T_RETURN);
          }
        case 222: break;
        case 89: 
          { pushState(ST_IN_SCRIPTING);
    yypushback(yylength()-1);
    return createSymbol(ParserConstants.T_CURLY_OPEN_WITH_DOLAR);
          }
        case 223: break;
        case 155: 
          { return createSymbol(ParserConstants.T_ARRAY_CAST);
          }
        case 224: break;
        case 31: 
          { return createSymbol(ParserConstants.T_TILDA);
          }
        case 225: break;
        case 53: 
          { if (asp_tags) {
        yybegin(ST_IN_SCRIPTING);
		//return T_OPEN_TAG;
    } else {
        return createSymbol(ParserConstants.T_INLINE_HTML);
    }
          }
        case 226: break;
        case 39: 
          { heredoc = null;
	yybegin(ST_IN_SCRIPTING);
	return createSymbol(ParserConstants.T_END_HEREDOC);
          }
        case 227: break;
        case 5: 
          { return createSymbol(ParserConstants.T_NEKUDA);
          }
        case 228: break;
        case 149: 
          { return createSymbol(ParserConstants.T_DEFAULT);
          }
        case 229: break;
        case 78: 
          { handleCommentStart();
    yybegin(ST_COMMENT);
          }
        case 230: break;
        case 136: 
          { yybegin(ST_IN_SCRIPTING);
	//return T_OPEN_TAG;
          }
        case 231: break;
        case 73: 
          { return createSymbol(ParserConstants.T_IS_NOT_EQUAL);
          }
        case 232: break;
        case 69: 
          { return createSymbol(ParserConstants.T_IS_GREATER_OR_EQUAL);
          }
        case 233: break;
        case 7: 
          { return createSymbol(ParserConstants.T_PLUS);
          }
        case 234: break;
        case 141: 
          { return createSymbol(ParserConstants.T_SWITCH);
          }
        case 235: break;
        case 25: 
          { return createSymbol(ParserConstants.T_REFERENCE);
          }
        case 236: break;
        case 172: 
          { return createSymbol(ParserConstants.T_METHOD_C);
          }
        case 237: break;
        case 82: 
          { return createSymbol(ParserConstants.T_BOOLEAN_AND);
          }
        case 238: break;
        case 13: 
          { return createSymbol(ParserConstants.T_SEMICOLON);
          }
        case 239: break;
        case 95: 
          { handlePHPDocEnd();
     yybegin(ST_IN_SCRIPTING);
          }
        case 240: break;
        case 14: 
          { return createSymbol(ParserConstants.T_MINUS);
          }
        case 241: break;
        case 171: 
          { return createSymbol(ParserConstants.T_IMPLEMENTS);
          }
        case 242: break;
        case 91: 
          { String text = yytext();
    int length = text.length() - 1;
    text = text.trim();
    
    yypushback(1);
    
    if (text.endsWith(";")) {
        text = text.substring(0, text.length() - 1);
        yypushback(1);
    }
    if (text.equals(heredoc)) {
        heredoc = null;
        yybegin(ST_IN_SCRIPTING);
        return createSymbol(ParserConstants.T_END_HEREDOC);
    } else {
    	   yybegin(ST_HEREDOC);
    }
          }
        case 243: break;
        case 112: 
          { String text = yytext();

    if (text.charAt(text.length() - 2)== ';') {
		text = text.substring(0, text.length() - 2);
        	yypushback(1);
    } else {
		text = text.substring(0, text.length() - 1);
    }
	
	int textLength = text.length();
	int heredocLength = heredoc.length();
	if (textLength > heredocLength && text.substring(textLength - heredocLength, textLength).equals(heredoc)) {
		yypushback(2);
        	yybegin(ST_END_HEREDOC);
        	// we need to remove the closing label from the symbol value.
        	Symbol sym = createFullSymbol(ParserConstants.T_ENCAPSED_AND_WHITESPACE);
        	String value = (String)sym.value;
        	sym.value = value.substring(0, value.length() - heredocLength + 1);
	   	return sym;
	}
	yypushback(1);
          }
        case 244: break;
        case 3: 
          { // do nothing
          }
        case 245: break;
        case 164: 
          { return createSymbol(ParserConstants.T_ENDSWITCH);
          }
        case 246: break;
        case 58: 
          { return createSymbol(ParserConstants.T_PLUS_EQUAL);
          }
        case 247: break;
        case 30: 
          { return createSymbol(ParserConstants.T_CLOSE_RECT);
          }
        case 248: break;
        case 98: 
          { return createSymbol(ParserConstants.T_LOGICAL_XOR);
          }
        case 249: break;
        case 94: 
          { handleMultilineCommentEnd();
    yybegin(ST_IN_SCRIPTING);
          }
        case 250: break;
        case 49: 
          { popState();
	return createSymbol(ParserConstants.T_CLOSE_RECT);
          }
        case 251: break;
        case 70: 
          { return createSymbol(ParserConstants.T_PAAMAYIM_NEKUDOTAYIM);
          }
        case 252: break;
        case 168: 
          { return createSymbol(ParserConstants.T_ENDDECLARE);
          }
        case 253: break;
        case 148: 
          { return createSymbol(ParserConstants.T_INCLUDE);
          }
        case 254: break;
        case 118: 
          { handleCommentStart();
          }
        case 255: break;
        case 60: 
          { return createFullSymbol(ParserConstants.T_CONSTANT_ENCAPSED_STRING);
          }
        case 256: break;
        case 72: 
          { return createSymbol(ParserConstants.T_IS_EQUAL);
          }
        case 257: break;
        case 130: 
          { return createSymbol(ParserConstants.T_ARRAY);
          }
        case 258: break;
        case 29: 
          { return createSymbol(ParserConstants.T_OPEN_RECT);
          }
        case 259: break;
        case 101: 
          { return createSymbol(ParserConstants.T_FOR);
          }
        case 260: break;
        case 161: 
          { return createSymbol(ParserConstants.T_OBJECT_CAST);
          }
        case 261: break;
        case 93: 
          { /* treat numbers (almost) as strings inside encapsulated strings */
    return createFullSymbol(ParserConstants.T_NUM_STRING);
          }
        case 262: break;
        case 153: 
          { return createSymbol(ParserConstants.T_PRIVATE);
          }
        case 263: break;
        case 159: 
          { return createSymbol(ParserConstants.T_ABSTRACT);
          }
        case 264: break;
        case 151: 
          { return createSymbol(ParserConstants.T_FOREACH);
          }
        case 265: break;
        case 123: 
          { return createSymbol(ParserConstants.T_THROW);
          }
        case 266: break;
        case 160: 
          { return createSymbol(ParserConstants.T_STRING_CAST);
          }
        case 267: break;
        case 81: 
          { return createSymbol(ParserConstants.T_AND_EQUAL);
          }
        case 268: break;
        case 131: 
          { return createSymbol(ParserConstants.T_WHILE);
          }
        case 269: break;
        case 103: 
          { return createSymbol(ParserConstants.T_NEW);
          }
        case 270: break;
        case 65: 
          { return createSymbol(ParserConstants.T_DEC);
          }
        case 271: break;
        case 54: 
          { if (short_tags_allowed || yylength()>2) { /* yyleng>2 means it's not <? but <script> */
        yybegin(ST_IN_SCRIPTING);
        //return T_OPEN_TAG;
    } else {
        return createSymbol(ParserConstants.T_INLINE_HTML);
    }
          }
        case 272: break;
        case 64: 
          { return createSymbol(ParserConstants.T_AS);
          }
        case 273: break;
        case 138: 
          { return createSymbol(ParserConstants.T_ELSEIF);
          }
        case 274: break;
        case 80: 
          { return createSymbol(ParserConstants.T_MOD_EQUAL);
          }
        case 275: break;
        case 44: 
          { return createFullSymbol(ParserConstants.T_NUM_STRING);
          }
        case 276: break;
        case 107: 
          { return createSymbol(ParserConstants.T_IS_IDENTICAL);
          }
        case 277: break;
        case 24: 
          { return createSymbol(ParserConstants.T_PRECENT);
          }
        case 278: break;
        case 71: 
          { return createSymbol(ParserConstants.T_DOUBLE_ARROW);
          }
        case 279: break;
        case 127: 
          { return createSymbol(ParserConstants.T_CATCH);
          }
        case 280: break;
        case 134: 
          { int removeChars = (yytext().charAt(0) == 'b')?4:3;
    heredoc = yytext().substring(removeChars).trim();    // for 'b<<<' or '<<<'
    yybegin(ST_START_HEREDOC);
    return createSymbol(ParserConstants.T_START_HEREDOC);
          }
        case 281: break;
        case 9: 
          { return createSymbol(ParserConstants.T_DOLLAR);
          }
        case 282: break;
        case 21: 
          { return createSymbol(ParserConstants.T_RGREATER);
          }
        case 283: break;
        case 4: 
          { return createFullSymbol(ParserConstants.T_LNUMBER);
          }
        case 284: break;
        case 137: 
          { return createSymbol(ParserConstants.T_ENDFOR);
          }
        case 285: break;
        case 27: 
          { return createSymbol(ParserConstants.T_KOVA);
          }
        case 286: break;
        case 56: 
          { return createSymbol(ParserConstants.T_CONCAT_EQUAL);
          }
        case 287: break;
        case 43: 
          { popState();
    pushState(ST_IN_SCRIPTING);
    return createFullSymbol(ParserConstants.T_STRING_VARNAME);
          }
        case 288: break;
        case 129: 
          { return createSymbol(ParserConstants.T_CLASS);
          }
        case 289: break;
        case 99: 
          { return createSymbol(ParserConstants.T_TRY);
          }
        case 290: break;
        case 122: 
          { return createSymbol(ParserConstants.T_ISSET);
          }
        case 291: break;
        case 10: 
          { yybegin(ST_DOUBLE_QUOTES);
    return createSymbol(ParserConstants.T_QUATE);
          }
        case 292: break;
        case 119: 
          { return createSymbol(ParserConstants.T_ENDIF);
          }
        case 293: break;
        case 42: 
          { yypushback(yylength());
    popState();
    pushState(ST_IN_SCRIPTING);
          }
        case 294: break;
        case 76: 
          { return createSymbol(ParserConstants.T_MUL_EQUAL);
          }
        case 295: break;
        case 96: 
          { if (asp_tags || yytext().charAt(0)!='%') { /* asp comment? */
	    handleLineCommentEnd();
        yypushback(yylength());
		yybegin(ST_IN_SCRIPTING);
		//return T_COMMENT;
	}
          }
        case 296: break;
        case 23: 
          { return createSymbol(ParserConstants.T_DIV);
          }
        case 297: break;
        case 128: 
          { return createSymbol(ParserConstants.T_CLONE);
          }
        case 298: break;
        case 139: 
          { /* not a keyword, hust for recognize constans.*/
    return createFullSymbol(ParserConstants.T_DEFINE);
          }
        case 299: break;
        case 174: 
          { return createSymbol(ParserConstants.T_REQUIRE_ONCE);
          }
        case 300: break;
        case 6: 
          { return createFullSymbol(ParserConstants.T_STRING);
          }
        case 301: break;
        case 37: 
          { yybegin(ST_IN_SCRIPTING);
    return createSymbol(ParserConstants.T_BACKQUATE);
          }
        case 302: break;
        case 102: 
          { return createSymbol(ParserConstants.T_USE);
          }
        case 303: break;
        case 18: 
          { return createSymbol(ParserConstants.T_CLOSE_PARENTHESE);
          }
        case 304: break;
        case 170: 
          { return createSymbol(ParserConstants.T_INSTANCEOF);
          }
        case 305: break;
        case 120: 
          { return createSymbol(ParserConstants.T_EMPTY);
          }
        case 306: break;
        case 90: 
          { yypushback(1);
	return createFullSymbol(ParserConstants.T_ENCAPSED_AND_WHITESPACE);
          }
        case 307: break;
        case 50: 
          { return createSymbol(ParserConstants.T_CURLY_CLOSE);
          }
        case 308: break;
        case 163: 
          { return createSymbol(ParserConstants.T_LINE);
          }
        case 309: break;
        case 2: 
          { return createSymbol(ParserConstants.T_INLINE_HTML);
          }
        case 310: break;
        case 110: 
          { if (!parsePHPDoc()) {
handleCommentStart();
yybegin(ST_DOCBLOCK);
}
          }
        case 311: break;
        case 83: 
          { return createSymbol(ParserConstants.T_OR_EQUAL);
          }
        case 312: break;
        case 116: 
          { return createSymbol(ParserConstants.T_CASE);
          }
        case 313: break;
        case 162: 
          { return createSymbol(ParserConstants.T_FILE);
          }
        case 314: break;
        case 147: 
          { return createSymbol(ParserConstants.T_EXTENDS);
          }
        case 315: break;
        case 67: 
          { return createSymbol(ParserConstants.T_MINUS_EQUAL);
          }
        case 316: break;
        case 1: 
          { return createFullSymbol(ParserConstants.T_ENCAPSED_AND_WHITESPACE);
          }
        case 317: break;
        case 124: 
          { return createSymbol(ParserConstants.T_FINAL);
          }
        case 318: break;
        case 150: 
          { return createSymbol(ParserConstants.T_DECLARE);
          }
        case 319: break;
        case 154: 
          { return createSymbol(ParserConstants.T_UNSET_CAST);
          }
        case 320: break;
        case 133: 
          { return createSymbol(ParserConstants.T_INT_CAST);
          }
        case 321: break;
        case 48: 
          { return createSymbol(ParserConstants.T_CURLY_OPEN);
          }
        case 322: break;
        case 17: 
          { return createSymbol(ParserConstants.T_OPEN_PARENTHESE);
          }
        case 323: break;
        case 144: 
          { return createSymbol(ParserConstants.T_BOOL_CAST);
          }
        case 324: break;
        case 104: 
          { return createSymbol(ParserConstants.T_LOGICAL_AND);
          }
        case 325: break;
        case 97: 
          { String text = yytext();
    if ((text.charAt(1)=='%' && asp_tags)
        || (text.charAt(1)=='?' && short_tags_allowed)) {
        yybegin(ST_IN_SCRIPTING);
        //return T_OPEN_TAG_WITH_ECHO;
    } else {
        return createSymbol(ParserConstants.T_INLINE_HTML);
    }
          }
        case 326: break;
        case 143: 
          { return createSymbol(ParserConstants.T_PUBLIC);
          }
        case 327: break;
        case 19: 
          { return createSymbol(ParserConstants.T_EQUAL);
          }
        case 328: break;
        case 61: 
          { return createSymbol(ParserConstants.T_IF);
          }
        case 329: break;
        case 28: 
          { return createSymbol(ParserConstants.T_COMMA);
          }
        case 330: break;
        case 108: 
          { return createSymbol(ParserConstants.T_IS_NOT_IDENTICAL);
          }
        case 331: break;
        case 74: 
          { return createSymbol(ParserConstants.T_IS_SMALLER_OR_EQUAL);
          }
        case 332: break;
        case 115: 
          { return createSymbol(ParserConstants.T_EVAL);
          }
        case 333: break;
        case 84: 
          { return createSymbol(ParserConstants.T_BOOLEAN_OR);
          }
        case 334: break;
        case 87: 
          { yypushback(1);
    return createFullSymbol(ParserConstants.T_ENCAPSED_AND_WHITESPACE);
          }
        case 335: break;
        case 68: 
          { return createSymbol(ParserConstants.T_SR);
          }
        case 336: break;
        case 157: 
          { return createSymbol(ParserConstants.T_FUNCTION);
          }
        case 337: break;
        case 166: 
          { return createSymbol(ParserConstants.T_PROTECTED);
          }
        case 338: break;
        case 156: 
          { return createSymbol(ParserConstants.T_ENDWHILE);
          }
        case 339: break;
        case 15: 
          { return createSymbol(ParserConstants.T_LGREATER);
          }
        case 340: break;
        case 106: 
          { return createSymbol(ParserConstants.T_VAR);
          }
        case 341: break;
        case 85: 
          { return createSymbol(ParserConstants.T_XOR_EQUAL);
          }
        case 342: break;
        case 111: 
          { yypushback(1);
	pushState(ST_VAR_OFFSET);
	return createFullSymbol(ParserConstants.T_VARIABLE);
          }
        case 343: break;
        case 46: 
          { return createSymbol(ParserConstants.T_QUATE);
          }
        case 344: break;
        case 158: 
          { return createSymbol(ParserConstants.T_CONTINUE);
          }
        case 345: break;
        case 66: 
          { pushState(ST_LOOKING_FOR_PROPERTY);
    return createSymbol(ParserConstants.T_OBJECT_OPERATOR);
          }
        case 346: break;
        case 100: 
          { return createFullSymbol(ParserConstants.T_EXIT);
          }
        case 347: break;
        case 132: 
          { return createSymbol(ParserConstants.T_PRINT);
          }
        case 348: break;
        case 177: 
          { return createSymbol(ParserConstants.T_HALT_COMPILER);
          }
        case 349: break;
        case 135: 
          { yypushback(3);
	pushState(ST_LOOKING_FOR_PROPERTY);
	return createFullSymbol(ParserConstants.T_VARIABLE);
          }
        case 350: break;
        case 75: 
          { return createSymbol(ParserConstants.T_SL);
          }
        case 351: break;
        case 173: 
          { return createSymbol(ParserConstants.T_INCLUDE_ONCE);
          }
        case 352: break;
        case 8: 
          { 
          }
        case 353: break;
        case 33: 
          { return createSymbol(ParserConstants.T_AT);
          }
        case 354: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            zzDoEOF();
              {     return createSymbol(sym.EOF);
 }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }

  /**
   * Runs the scanner on input files.
   *
   * This is a standalone scanner, it will print any unmatched
   * text to System.out unchanged.
   *
   * @param argv   the command line, contains the filenames to run
   *               the scanner on.
   */
  public static void main(String argv[]) {
    if (argv.length == 0) {
      System.out.println("Usage : java PhpAstLexer <inputfile>");
    }
    else {
      for (int i = 0; i < argv.length; i++) {
        PhpAstLexer scanner = null;
        try {
          scanner = new PhpAstLexer( new java.io.FileReader(argv[i]) );
          while ( !scanner.zzAtEOF ) scanner.next_token();
        }
        catch (java.io.FileNotFoundException e) {
          System.out.println("File not found : \""+argv[i]+"\"");
        }
        catch (java.io.IOException e) {
          System.out.println("IO error scanning file \""+argv[i]+"\"");
          System.out.println(e);
        }
        catch (Exception e) {
          System.out.println("Unexpected exception:");
          e.printStackTrace();
        }
      }
    }
  }


}
