/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.model;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.LineBreakpoint;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org.eclipse.php.internal.debug.core.zend.debugger.Breakpoint;

public class PHPLineBreakpoint
extends LineBreakpoint {
    protected Breakpoint fBreakpoint;
    protected boolean fConditionChanged = false;

    public PHPLineBreakpoint() {
    }

    public PHPLineBreakpoint(final IResource resource, final int lineNumber) throws CoreException {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IMarker marker = resource.createMarker("org.eclipse.php.debug.core.PHPConditionalBreakpointMarker");
                marker.setAttribute("org.eclipse.debug.core.enabled", (Object)Boolean.TRUE);
                marker.setAttribute("lineNumber", lineNumber);
                marker.setAttribute("org.eclipse.debug.core.id", (Object)PHPLineBreakpoint.this.getModelIdentifier());
                marker.setAttribute("message", (Object)NLS.bind((String)PHPDebugCoreMessages.LineBreakPointMessage_1, (Object[])new String[]{resource.getName(), Integer.toString(lineNumber)}));
                PHPLineBreakpoint.this.setMarker(marker);
                PHPLineBreakpoint.this.setEnabled(true);
                PHPLineBreakpoint.this.register(true);
            }
        };
        this.run(this.getMarkerRule(resource), runnable);
    }

    protected void register(boolean register) throws CoreException {
        if (register) {
            DebugPlugin.getDefault().getBreakpointManager().addBreakpoint((IBreakpoint)this);
        } else {
            this.setRegistered(false);
        }
    }

    public String getModelIdentifier() {
        return "org.eclipse.php.debug.core";
    }

    protected void createRuntimeBreakpoint(IMarker marker) throws CoreException {
        IResource resource = marker.getResource();
        String fileName = "";
        if (resource instanceof IWorkspaceRoot) {
            fileName = (String)marker.getAttribute("org.eclipse.php.debug.core.Storage_File");
        } else {
            IFile file = (IFile)resource;
            IPath path = file.getFullPath();
            fileName = path.lastSegment();
        }
        Integer lineNumber = (Integer)marker.getAttribute("lineNumber");
        this.fBreakpoint = new Breakpoint(fileName, lineNumber);
        this.fBreakpoint.setEnable(true);
    }

    public Breakpoint getRuntimeBreakpoint() {
        return this.fBreakpoint;
    }

    public void setMarker(IMarker marker) throws CoreException {
        super.setMarker(marker);
        this.createRuntimeBreakpoint(marker);
    }

    public void setEnabled(boolean enabled) throws CoreException {
        super.setEnabled(enabled);
    }

    public void setConditionChanged(boolean conditionChanged) {
        this.fConditionChanged = conditionChanged;
    }

    public boolean isConditionChanged() {
        return this.fConditionChanged;
    }
}

