/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.server.core;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.php.internal.server.core.Logger;
import org.eclipse.php.internal.server.core.Server;

public class ServerHelper {
    protected Map map = new HashMap();
    private transient List propertyListeners;
    private Server server;

    public ServerHelper(Server server) {
        this.server = server;
    }

    public void setAttribute(String attributeName, String value) {
        String current = this.getAttribute(attributeName, null);
        if (current != null && current.equals(value)) {
            return;
        }
        if (value == null) {
            this.map.remove(attributeName);
        } else {
            this.map.put(attributeName, value);
        }
        this.firePropertyChangeEvent(attributeName, current, value);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyListeners == null) {
            this.propertyListeners = new ArrayList(2);
        }
        this.propertyListeners.add(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyListeners != null) {
            this.propertyListeners.remove(listener);
        }
    }

    public void firePropertyChangeEvent(String propertyName, Object oldValue, Object newValue) {
        if (this.propertyListeners == null) {
            return;
        }
        PropertyChangeEvent event = new PropertyChangeEvent(this.server, propertyName, oldValue, newValue);
        try {
            Iterator iterator = this.propertyListeners.iterator();
            while (iterator.hasNext()) {
                try {
                    PropertyChangeListener listener = (PropertyChangeListener)iterator.next();
                    listener.propertyChange(event);
                }
                catch (Exception e) {
                    Logger.logException("Error firing property change event", e);
                }
            }
        }
        catch (Exception e) {
            Logger.logException("Error in property event", e);
        }
    }

    public String getAttribute(String attributeName, String defaultValue) {
        try {
            Object obj = this.map.get(attributeName);
            if (obj == null) {
                return defaultValue;
            }
            return (String)obj;
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public void removeAttribute(String attributeName) {
        this.map.remove(attributeName);
    }
}

