/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.dialogs.saveFiles.SaveAsDialog;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.internal.ui.editor.input.NonExistingPHPFileEditorInput;
import org.eclipse.php.internal.ui.util.EditorUtility;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.internal.editors.text.NLSUtility;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class UntitledPHPEditor
extends PHPStructuredEditor {
    public void doSave(IProgressMonitor progressMonitor) {
        this.performSaveAs(progressMonitor);
    }

    protected void performSaveAs(IProgressMonitor progressMonitor) {
        boolean success;
        block21: {
            Shell shell = this.getSite().getShell();
            IEditorInput input = this.getEditorInput();
            IDocumentProvider provider = this.getDocumentProvider();
            SaveAsDialog dialog = new SaveAsDialog(shell);
            dialog.setOriginalName(input.getName());
            dialog.create();
            if (dialog.open() == 1) {
                if (progressMonitor != null) {
                    progressMonitor.setCanceled(true);
                }
                return;
            }
            IPath newPath = dialog.getResult();
            if (newPath == null) {
                if (progressMonitor != null) {
                    progressMonitor.setCanceled(true);
                }
                return;
            }
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IFile file = workspace.getRoot().getFile(newPath);
            FileEditorInput newInput = new FileEditorInput(file);
            if (provider == null) {
                return;
            }
            success = false;
            try {
                try {
                    provider.aboutToChange((Object)newInput);
                    provider.saveDocument(progressMonitor, (Object)newInput, provider.getDocument((Object)input), true);
                    success = true;
                }
                catch (CoreException x) {
                    Logger.logException(x);
                    IStatus status = x.getStatus();
                    if (status == null || status.getSeverity() != 8) {
                        String title = PHPUIMessages.getString("UntitledPHPEditor_saveError");
                        String msg = NLSUtility.format((String)PHPUIMessages.getString("UntitledPHPEditor_documentCannotBeSaved"), (Object)x.getMessage());
                        MessageDialog.openError((Shell)shell, (String)title, (String)msg);
                    }
                    if (newPath != null) {
                        this.close(false);
                        try {
                            EditorUtility.openInEditor(newPath.toString(), 0);
                        }
                        catch (CoreException e) {
                            Logger.logException(e);
                        }
                    }
                    break block21;
                }
            }
            catch (Throwable throwable) {
                if (newPath != null) {
                    this.close(false);
                    try {
                        EditorUtility.openInEditor(newPath.toString(), 0);
                    }
                    catch (CoreException e) {
                        Logger.logException(e);
                    }
                }
                throw throwable;
            }
            if (newPath != null) {
                this.close(false);
                try {
                    EditorUtility.openInEditor(newPath.toString(), 0);
                }
                catch (CoreException e) {
                    Logger.logException(e);
                }
            }
        }
        this.deleteUntitledStorageFile();
        if (progressMonitor != null) {
            progressMonitor.setCanceled(!success);
        }
    }

    public void dispose() {
        this.deleteUntitledStorageFile();
        super.dispose();
    }

    private void deleteUntitledStorageFile() {
        IPath oldPath = ((NonExistingPHPFileEditorInput)this.getEditorInput()).getPath(this.getEditorInput());
        File oldFile = new File(oldPath.toOSString());
        if (oldFile.exists() && oldFile.canWrite() && !oldFile.delete()) {
            Logger.log(2, PHPUIMessages.getString("UntitledPHPEditor_deleteFailed"));
        }
    }
}

