/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.wizards;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.wizards.WizardPageFactory;

public class PHPWizardPagesRegistry {
    private static final String EXTENSION_POINT = "org.eclipse.php.ui.phpWizardPages";
    private static final String PAGE_ELEMENT = "page";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String TARGET_ID_ATTRIBUTE = "targetId";
    private Map pages = new HashMap();
    private static PHPWizardPagesRegistry instance = new PHPWizardPagesRegistry();

    private PHPWizardPagesRegistry() {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT);
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (PAGE_ELEMENT.equals(element.getName())) {
                String targetId = element.getAttribute(TARGET_ID_ATTRIBUTE);
                LinkedList<IConfigurationElement> elementsList = (LinkedList<IConfigurationElement>)this.pages.get(targetId);
                if (elementsList == null) {
                    elementsList = new LinkedList<IConfigurationElement>();
                }
                elementsList.add(element);
                this.pages.put(targetId, elementsList);
            }
            ++i;
        }
    }

    public static IWizardPage[] getPages(String id) {
        final List elementsList = (List)PHPWizardPagesRegistry.instance.pages.get(id);
        if (elementsList != null) {
            final LinkedList pagesList = new LinkedList();
            SafeRunner.run((ISafeRunnable)new SafeRunnable(String.valueOf(PHPUIMessages.getString("PHPWizardPagesRegistry.0")) + EXTENSION_POINT){

                public void run() throws Exception {
                    for (IConfigurationElement element : elementsList) {
                        pagesList.add(element.createExecutableExtension(PHPWizardPagesRegistry.CLASS_ATTRIBUTE));
                    }
                }
            });
            return pagesList.toArray(new IWizardPage[pagesList.size()]);
        }
        return null;
    }

    public static WizardPageFactory[] getPageFactories(String id) {
        final List elementsList = (List)PHPWizardPagesRegistry.instance.pages.get(id);
        if (elementsList != null) {
            final LinkedList pagesList = new LinkedList();
            SafeRunner.run((ISafeRunnable)new SafeRunnable(String.valueOf(PHPUIMessages.getString("PHPWizardPagesRegistry.0")) + EXTENSION_POINT){

                public void run() throws Exception {
                    for (IConfigurationElement element : elementsList) {
                        pagesList.add(element.createExecutableExtension(PHPWizardPagesRegistry.CLASS_ATTRIBUTE));
                    }
                }
            });
            return pagesList.toArray(new WizardPageFactory[pagesList.size()]);
        }
        return null;
    }
}

