/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.dialogs.openType.generic;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.dialogs.openType.generic.CompositeFactory;
import org.eclipse.php.internal.ui.dialogs.openType.generic.CompositeFactoryAsserter;
import org.eclipse.php.internal.ui.dialogs.openType.generic.HighLoadTableViewer;
import org.eclipse.php.internal.ui.dialogs.openType.generic.IBasicSelectorLabelProvider;
import org.eclipse.php.internal.ui.dialogs.openType.generic.filter.ElementSpecificFilter;
import org.eclipse.php.internal.ui.dialogs.openType.generic.filter.IFilter;
import org.eclipse.php.internal.ui.util.SearchPattern;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class BasicSelector
extends Composite {
    private Label instructionLabel;
    private Text filterText;
    private Label matchingLabel;
    private HighLoadTableViewer tableViewer;
    private Composite tableViewerComposite;
    private CompositeFactory contentAreaCompositeFactory;
    private ViewerElementFilter phpTypeViewerFilter;
    private IBasicSelectorLabelProvider basicSelectorLabelProvider;

    public BasicSelector(Composite parent, CompositeFactory contentAreaCompositeFactory) {
        super(parent, 0);
        this.contentAreaCompositeFactory = new CompositeFactoryAsserter(contentAreaCompositeFactory);
        this.initialize();
    }

    public void setInitFilterText(String initFilterText) {
        this.filterText.setText(initFilterText);
    }

    private void initialize() {
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 10;
        formLayout.marginHeight = 5;
        this.setLayout((Layout)formLayout);
        this.initControls();
        this.setSize(new Point(341, 400));
    }

    private void initControls() {
        this.createInstructionLabel();
        FormData formData = new FormData();
        this.instructionLabel.setLayoutData((Object)formData);
        formData.top = new FormAttachment(0);
        this.createFilterText();
        formData = new FormData();
        this.filterText.setLayoutData((Object)formData);
        formData.top = new FormAttachment((Control)this.instructionLabel, 5);
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        Text lastControl = this.filterText;
        if (this.contentAreaCompositeFactory != null) {
            Composite contentFilterComposite = this.contentAreaCompositeFactory.createComposite(this);
            lastControl = contentFilterComposite;
            formData = new FormData();
            contentFilterComposite.setLayoutData((Object)formData);
            formData.top = new FormAttachment((Control)this.filterText, 5);
            formData.left = new FormAttachment(0);
            formData.right = new FormAttachment(100);
        }
        this.createMatchingLabel();
        formData = new FormData();
        this.matchingLabel.setLayoutData((Object)formData);
        formData.top = new FormAttachment((Control)lastControl, 5);
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        this.createTableViewer();
        formData = new FormData();
        this.tableViewerComposite.setLayoutData((Object)formData);
        formData.top = new FormAttachment((Control)this.matchingLabel, 5);
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        formData.bottom = new FormAttachment(100);
    }

    private void createTableViewer() {
        this.tableViewerComposite = new Composite((Composite)this, 0);
        FillLayout fillLayout = new FillLayout();
        this.tableViewerComposite.setLayout((Layout)fillLayout);
        this.tableViewer = new HighLoadTableViewer(this.tableViewerComposite, 2820);
        this.phpTypeViewerFilter = new ViewerElementFilter();
        this.tableViewer.addFilter(this.phpTypeViewerFilter);
        this.tableViewer.getControl().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                StructuredSelection structuredSelection = (StructuredSelection)BasicSelector.this.tableViewer.getSelection();
                if (structuredSelection.getFirstElement() == BasicSelector.this.tableViewer.getElementAt(0) && 0x1000001 == e.keyCode) {
                    BasicSelector.this.filterText.setFocus();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.tableViewer.getControl().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if ((e.keyCode & 0x1000000) == 0) {
                    if (e.keyCode > 97 && e.keyCode < 122 || e.keyCode > 65 && e.keyCode < 90) {
                        BasicSelector.this.filterText.setFocus();
                        BasicSelector.this.filterText.setText(String.valueOf(BasicSelector.this.filterText.getText()) + e.character);
                        BasicSelector.this.filterText.setSelection(BasicSelector.this.filterText.getText().length());
                    } else if (e.keyCode == 8) {
                        BasicSelector.this.filterText.setFocus();
                        String text = BasicSelector.this.filterText.getText();
                        if (text.length() == 0) {
                            return;
                        }
                        BasicSelector.this.filterText.setText(text.substring(0, text.length() - 1));
                        BasicSelector.this.filterText.setSelection(text.length() - 1);
                    }
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
    }

    private void createMatchingLabel() {
        this.matchingLabel = new Label((Composite)this, 0);
        this.matchingLabel.setText(PHPUIMessages.getString("OpenType_matchingResources"));
    }

    private void createFilterText() {
        this.filterText = new Text((Composite)this, 2048);
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BasicSelector.this.phpTypeViewerFilter.setFilterText(BasicSelector.this.filterText.getText());
            }
        });
        this.filterText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (0x1000002 == e.keyCode && BasicSelector.this.tableViewer.getTableElements().length != 0) {
                    BasicSelector.this.tableViewer.getControl().setFocus();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
    }

    private void createInstructionLabel() {
        this.instructionLabel = new Label((Composite)this, 0);
        this.instructionLabel.setText(PHPUIMessages.getString("OpenType_instructionText"));
    }

    public void setElements(Object[] elements) {
        this.tableViewer.setElements(elements);
    }

    public void setLabelProvider(IBasicSelectorLabelProvider basicSelectorLabelProvider) {
        this.basicSelectorLabelProvider = basicSelectorLabelProvider;
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                return BasicSelector.this.basicSelectorLabelProvider.getElementImage(element);
            }

            public String getColumnText(Object element, int columnIndex) {
                return BasicSelector.this.basicSelectorLabelProvider.getElementDescription(element);
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
    }

    public void addFilter(IFilter filter) {
        this.tableViewer.addFilter(filter);
    }

    public Object getSelectedElement() {
        return ((StructuredSelection)this.tableViewer.getSelection()).getFirstElement();
    }

    public void addDoubleClickListener(IDoubleClickListener listener) {
        this.tableViewer.addDoubleClickListener(listener);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.tableViewer.addSelectionChangedListener(listener);
    }

    public void setDefaultElementSelection(boolean defaultElementSelection) {
        this.tableViewer.setDefaultElementSelection(defaultElementSelection);
    }

    public void close() {
        this.tableViewer.close();
    }

    private class ViewerElementFilter
    extends ElementSpecificFilter {
        private String textFilter = "";

        private ViewerElementFilter() {
        }

        public boolean select(Object element) {
            if (this.textFilter.equals("")) {
                return false;
            }
            String elementText = BasicSelector.this.basicSelectorLabelProvider.getElementName(element).toLowerCase();
            return SearchPattern.match(this.textFilter, elementText);
        }

        public void setFilterText(String textFilter) {
            this.textFilter = textFilter.toLowerCase();
            this.notifyFilterChanged();
        }
    }
}

