/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences.includepath;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.internal.ui.wizards.NewWizardMessages;
import org.eclipse.dltk.internal.ui.wizards.buildpath.AddSourceFolderWizard;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BPListElement;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BPListElementAttribute;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BPListElementSorter;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BuildPathWizard;
import org.eclipse.dltk.internal.ui.wizards.buildpath.CreateMultipleSourceFoldersDialog;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.ITreeListAdapter;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.TreeListDialogField;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.php.internal.core.buildpath.BuildPathUtils;
import org.eclipse.php.internal.core.includepath.IncludePath;
import org.eclipse.php.internal.core.includepath.IncludePathManager;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.preferences.includepath.IncludePathUtils;
import org.eclipse.php.internal.ui.preferences.includepath.PHPIPListLabelProvider;
import org.eclipse.php.internal.ui.preferences.includepath.PHPSourceContainerWorkbookPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.internal.IChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PHPIncludePathSourcePage
extends PHPSourceContainerWorkbookPage {
    protected int IDX_ADD = 0;
    protected int IDX_REMOVE = 1;
    protected int IDX_ADD_LINK = 2;
    protected int IDX_EDIT = 3;
    private List<BPListElement> fAddedElements = new ArrayList<BPListElement>(1);
    private boolean addToBuildPath = false;

    public boolean shouldAddToBuildPath() {
        return this.addToBuildPath;
    }

    public List<BPListElement> getAddedElements() {
        return this.fAddedElements;
    }

    public PHPIncludePathSourcePage(ListDialogField buildpathList) {
        super(buildpathList);
    }

    private boolean shouldDisplayElement(Object element) {
        BPListElementAttribute attribute;
        String key;
        return !(element instanceof BPListElementAttribute) || !(key = (attribute = (BPListElementAttribute)element).getKey()).equals("inclusion") && !key.equals("exclusion");
    }

    @Override
    protected boolean canRemove(List selElements) {
        if (selElements.size() == 0) {
            return false;
        }
        int i = 0;
        while (i < selElements.size()) {
            BPListElement curr;
            Object elem = selElements.get(i);
            if (elem instanceof BPListElement && BuildPathUtils.isInBuildpath((IPath)(curr = (BPListElement)elem).getPath(), (IScriptProject)this.fCurrJProject)) {
                return false;
            }
            ++i;
        }
        return super.canRemove(selElements);
    }

    @Override
    protected void initContainerElements() {
        PHPSourceContainerAdapter adapter = new PHPSourceContainerAdapter();
        String[] buttonLabels = new String[]{NewWizardMessages.SourceContainerWorkbookPage_folders_add_button, NewWizardMessages.SourceContainerWorkbookPage_folders_remove_button};
        this.fFoldersList = new TreeListDialogField((ITreeListAdapter)adapter, buttonLabels, (ILabelProvider)new PHPIPListLabelProvider());
        this.fFoldersList.setDialogFieldListener((IDialogFieldListener)adapter);
        this.fFoldersList.setLabelText(PHPUIMessages.getString("IncludePathSourcePage_Folders_Label"));
        this.fFoldersList.setViewerSorter((ViewerSorter)new BPListElementSorter());
    }

    @Override
    protected void updateFoldersList() {
        ArrayList<BPListElement> folders = new ArrayList<BPListElement>();
        IncludePath[] includePath = IncludePathManager.getInstance().getIncludePaths(this.fCurrJProject.getProject());
        List<IncludePath> includePathEntries = Arrays.asList(includePath);
        for (IncludePath entry : includePathEntries) {
            Object includePathEntry = entry.getEntry();
            IResource resource = null;
            if (includePathEntry instanceof IBuildpathEntry) continue;
            resource = (IResource)includePathEntry;
            folders.add(new BPListElement(this.fCurrJProject, 3, resource.getFullPath(), resource, false));
        }
        this.fFoldersList.setElements(folders);
    }

    @Override
    public Control getControl(Composite parent) {
        Control control = super.getControl(parent);
        this.addFilter();
        return control;
    }

    private void addFilter() {
        this.fFoldersList.getTreeViewer().addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return PHPIncludePathSourcePage.this.shouldDisplayElement(element);
            }
        });
    }

    @Override
    protected int getIDX_ADD() {
        return this.IDX_ADD;
    }

    @Override
    protected int getIDX_ADD_LINK() {
        return this.IDX_ADD_LINK;
    }

    @Override
    protected int getIDX_EDIT() {
        return this.IDX_EDIT;
    }

    @Override
    protected int getIDX_REMOVE() {
        return this.IDX_REMOVE;
    }

    @Override
    protected void sourcePageCustomButtonPressed(DialogField field, int index) {
        if (field == this.fFoldersList) {
            if (index == this.IDX_ADD) {
                IProject project = this.fCurrJProject.getProject();
                if (project.exists() && this.hasFolders((IContainer)project)) {
                    List existingElements = this.fFoldersList.getElements();
                    BPListElement[] existing = existingElements.toArray(new BPListElement[existingElements.size()]);
                    CreateMultipleSourceFoldersDialog dialog = new CreateMultipleSourceFoldersDialog(this.fCurrJProject, existing, this.getShell());
                    if (dialog.open() == 0) {
                        this.refresh(dialog.getInsertedElements(), dialog.getRemovedElements(), dialog.getModifiedElements());
                    }
                } else {
                    BPListElement newElement = new BPListElement(this.fCurrJProject, 3, false);
                    AddSourceFolderWizard wizard = PHPIncludePathSourcePage.newSourceFolderWizard(newElement, this.fFoldersList.getElements(), true);
                    PHPSourceContainerWorkbookPage.OpenBuildPathWizardAction action = new PHPSourceContainerWorkbookPage.OpenBuildPathWizardAction(this, (BuildPathWizard)wizard);
                    action.run();
                }
            } else {
                super.sourcePageCustomButtonPressed(field, index);
            }
        }
    }

    @Override
    protected void refresh(List insertedElements, List removedElements, List modifiedElements) {
        this.fAddedElements.clear();
        this.fFoldersList.addElements(insertedElements);
        for (Object element : insertedElements) {
            if (BuildPathUtils.isContainedInBuildpath((IPath)element.getPath(), (IScriptProject)this.fCurrJProject)) continue;
            this.fAddedElements.add((BPListElement)element);
        }
        if (this.fAddedElements.size() > 0) {
            this.addToBuildPath = IncludePathUtils.openConfirmationDialog(this.getShell(), PHPUIMessages.getString("IncludePath.AddEntryTitle"), PHPUIMessages.getString("IncludePath.AddEntryToBuildPathMessage"));
            for (IChangeListener listener : this.addedElementListeners) {
                listener.update(true);
            }
        }
        for (Object element : insertedElements) {
            this.fFoldersList.expandElement(element, 3);
        }
        this.fFoldersList.removeElements(removedElements);
        for (Object element : modifiedElements) {
            this.fFoldersList.refresh(element);
            this.fFoldersList.expandElement(element, 3);
        }
        this.fFoldersList.refresh();
        if (!insertedElements.isEmpty()) {
            this.fFoldersList.postSetSelection((ISelection)new StructuredSelection(insertedElements));
        }
    }

    protected class PHPSourceContainerAdapter
    extends PHPSourceContainerWorkbookPage.SourceContainerAdapter {
        protected PHPSourceContainerAdapter() {
            super(PHPIncludePathSourcePage.this);
        }

        public boolean hasChildren(TreeListDialogField field, Object element) {
            return false;
        }
    }
}

