/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.search;

import java.util.Arrays;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.search.Messages;
import org.eclipse.php.internal.ui.search.WorkingSetComparator;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.ui.IWorkingSet;

public class SearchUtil {
    public static boolean isSearchPlugInActivated() {
        return Platform.getBundle((String)"org.eclipse.search").getState() == 32;
    }

    public static void runQueryInBackground(Object query) {
        NewSearchUI.runQueryInBackground((ISearchQuery)((ISearchQuery)query));
    }

    public static IStatus runQueryInForeground(IRunnableContext context, Object query) {
        return NewSearchUI.runQueryInForeground((IRunnableContext)context, (ISearchQuery)((ISearchQuery)query));
    }

    public static String toString(IWorkingSet[] workingSets) {
        Arrays.sort(workingSets, new WorkingSetComparator());
        String result = "";
        if (workingSets != null && workingSets.length > 0) {
            boolean firstFound = false;
            int i = 0;
            while (i < workingSets.length) {
                String workingSetName = workingSets[i].getName();
                if (firstFound) {
                    result = Messages.format(PHPUIMessages.getString("SearchUtil_workingSetConcatenation"), new String[]{result, workingSetName});
                } else {
                    result = workingSetName;
                    firstFound = true;
                }
                ++i;
            }
        }
        return result;
    }
}

