/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.launching;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.debug.core.debugger.parameters.IDebugParametersInitializer;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.preferences.PreferencesSupport;
import org.eclipse.php.internal.debug.core.Logger;
import org.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.preferences.PHPDebugCorePreferenceNames;
import org.eclipse.php.internal.debug.core.preferences.PHPProjectPreferences;
import org.eclipse.php.internal.debug.core.zend.communication.DebugConnectionThread;
import org.eclipse.php.internal.debug.core.zend.model.PHPDebugTarget;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PHPLaunchUtilities {
    public static final String ID_PHPDebugOutput = "org.eclipse.debug.ui.PHPDebugOutput";
    public static final String ID_PHPBrowserOutput = "org.eclipse.debug.ui.PHPBrowserOutput";
    private static DebuggerDelayProgressMonitorDialog progressDialog;

    public static void showDebugView() {
        Preferences prefs = PHPProjectPreferences.getModelPreferences();
        if (!prefs.getBoolean(PHPDebugCorePreferenceNames.OPEN_DEBUG_VIEWS)) {
            return;
        }
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                if (page != null) {
                    try {
                        IViewPart debugOutputPart = page.findView(PHPLaunchUtilities.ID_PHPDebugOutput);
                        IViewPart browserOutputPart = page.findView(PHPLaunchUtilities.ID_PHPBrowserOutput);
                        boolean shouldShowDebug = false;
                        if (debugOutputPart == null || !page.isPartVisible((IWorkbenchPart)debugOutputPart)) {
                            shouldShowDebug = true;
                        }
                        if (browserOutputPart != null && page.isPartVisible((IWorkbenchPart)browserOutputPart)) {
                            shouldShowDebug = false;
                        }
                        if (shouldShowDebug) {
                            page.showView(PHPLaunchUtilities.ID_PHPDebugOutput);
                        }
                    }
                    catch (Exception e) {
                        Logger.logException("Error switching to the Debug Output view", e);
                    }
                }
            }
        });
    }

    public static boolean hasPHPDebugLaunch() {
        ILaunch[] launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        int i = 0;
        while (i < launches.length) {
            if (!launches[i].isTerminated() && "debug".equals(launches[i].getLaunchMode()) && launches[i].getDebugTarget() instanceof PHPDebugTarget) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean notifyPreviousLaunches(ILaunch newLaunch) throws CoreException {
        if (!"debug".equals(newLaunch.getLaunchMode())) {
            return true;
        }
        if (!PHPLaunchUtilities.hasPHPDebugLaunch()) {
            return true;
        }
        final IPreferenceStore store = PHPUiPlugin.getDefault().getPreferenceStore();
        String option = store.getString("allowMultipleLaunches");
        if ("always".equals(option)) {
            return true;
        }
        if ("never".equals(option)) {
            final Display disp = Display.getDefault();
            disp.syncExec(new Runnable(){

                public void run() {
                    MessageDialog.openInformation((Shell)disp.getActiveShell(), (String)PHPDebugCoreMessages.PHPLaunchUtilities_phpLaunchTitle, (String)PHPDebugCoreMessages.PHPLaunchUtilities_activeLaunchDetected);
                }
            });
            return false;
        }
        final DialogResultHolder resultHolder = new DialogResultHolder();
        final Display disp = Display.getDefault();
        disp.syncExec(new Runnable(){

            public void run() {
                MessageDialogWithToggle m = MessageDialogWithToggle.openYesNoQuestion((Shell)disp.getActiveShell(), (String)PHPDebugCoreMessages.PHPLaunchUtilities_confirmation, (String)PHPDebugCoreMessages.PHPLaunchUtilities_multipleLaunchesPrompt, (String)PHPDebugCoreMessages.PHPLaunchUtilities_rememberDecision, (boolean)false, (IPreferenceStore)store, (String)"allowMultipleLaunches");
                resultHolder.setReturnCode(m.getReturnCode());
            }
        });
        switch (resultHolder.getReturnCode()) {
            case 0: 
            case 2: {
                return true;
            }
            case 3: {
                return false;
            }
        }
        return true;
    }

    public static void switchToPHPPerspective() {
        Display display = PlatformUI.getWorkbench().getDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                String perspectiveID = "org.eclipse.php.perspective";
                IWorkbench workbench = PlatformUI.getWorkbench();
                IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                if (PHPLaunchUtilities.shouldSwitchToPHPPerspective(perspectiveID)) {
                    try {
                        workbench.showPerspective(perspectiveID, window);
                    }
                    catch (WorkbenchException e) {
                        PHPUiPlugin.log((Throwable)e);
                    }
                }
            }
        });
    }

    private static boolean shouldSwitchToPHPPerspective(String perspectiveID) {
        IPreferenceStore store = PHPUiPlugin.getDefault().getPreferenceStore();
        String option = store.getString("switchBackToPHPPerspective");
        if ("always".equals(option)) {
            return true;
        }
        if ("never".equals(option)) {
            return false;
        }
        IPerspectiveRegistry registry = PlatformUI.getWorkbench().getPerspectiveRegistry();
        IPerspectiveDescriptor perspective = registry.findPerspectiveWithId(perspectiveID);
        if (perspective == null) {
            return false;
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            IPerspectiveDescriptor current;
            IWorkbenchPage page = window.getActivePage();
            if (page != null && (current = page.getPerspective()) != null && current.getId().equals(perspectiveID)) {
                return false;
            }
            MessageDialogWithToggle m = MessageDialogWithToggle.openYesNoQuestion((Shell)window.getShell(), (String)PHPDebugCoreMessages.PHPLaunchUtilities_PHPPerspectiveSwitchTitle, (String)NLS.bind((String)PHPDebugCoreMessages.PHPLaunchUtilities_PHPPerspectiveSwitchMessage, (Object[])new String[]{perspective.getLabel()}), (String)PHPDebugCoreMessages.PHPLaunchUtilities_rememberDecision, (boolean)false, (IPreferenceStore)store, (String)"switchBackToPHPPerspective");
            int result = m.getReturnCode();
            switch (result) {
                case 0: 
                case 2: {
                    return true;
                }
                case 3: {
                    return false;
                }
            }
        }
        return false;
    }

    public static boolean checkDebugAllPages(ILaunchConfiguration newLaunchConfiguration, final ILaunch newLaunch) throws CoreException {
        if (PHPDebugPlugin.supportsMultipleDebugAllPages()) {
            return true;
        }
        newLaunch.setAttribute("debugPages", newLaunchConfiguration.getAttribute("debugPages", "debugAllPages"));
        PHPLaunchUtilities.checkAutoRemoveLaunches();
        ILaunch[] launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        boolean hasContiniousLaunch = false;
        int i = 0;
        while (!hasContiniousLaunch && i < launches.length) {
            ILaunch launch = launches[i];
            if (launch != newLaunch && "debug".equals(launch.getLaunchMode()) && (PHPLaunchUtilities.isDebugAllPages(launch) || PHPLaunchUtilities.isStartDebugFrom(launch))) {
                hasContiniousLaunch = true;
            }
            ++i;
        }
        boolean newLaunchIsDebug = "debug".equals(newLaunch.getLaunchMode());
        final boolean newIsDebugAllPages = newLaunchIsDebug && PHPLaunchUtilities.isDebugAllPages(newLaunch);
        boolean newIsStartDebugFrom = newLaunchIsDebug && PHPLaunchUtilities.isStartDebugFrom(newLaunch);
        final boolean fHasContiniousLaunch = hasContiniousLaunch;
        if ((fHasContiniousLaunch || newIsDebugAllPages || newIsStartDebugFrom) && launches.length > 1) {
            final DialogResultHolder resultHolder = new DialogResultHolder();
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    if (fHasContiniousLaunch) {
                        resultHolder.setResult(MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)PHPDebugCoreMessages.PHPLaunchUtilities_confirmation, (String)"A previous launch with 'Debug All Pages' or 'Start Debug From' attribute was identifed.\nLaunching a new session will terminate and remove the old launch, directing all future debug requests associated with it to the new launch.\nDo you wish to continue and launch a new session?"));
                    } else if (newIsDebugAllPages) {
                        resultHolder.setResult(MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)PHPDebugCoreMessages.PHPLaunchUtilities_confirmation, (String)"The requested launch has a 'Debug All Pages' attribute.\nLaunching this type of session will terminate and remove any other previous launches.\nDo you wish to continue and launch the new session?"));
                    } else {
                        resultHolder.setResult(MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)PHPDebugCoreMessages.PHPLaunchUtilities_confirmation, (String)"The requested launch has a 'Start Debug From' attribute.\nLaunching this type of session will terminate and remove any other previous launches.\nDo you wish to continue and launch the new session?"));
                    }
                    if (resultHolder.getResult()) {
                        PHPDebugPlugin.setDisableAutoRemoveLaunches(true);
                        PHPLaunchUtilities.removeAndTerminateOldLaunches(newLaunch);
                    } else {
                        DebugPlugin.getDefault().getLaunchManager().removeLaunch(newLaunch);
                    }
                }
            });
            return resultHolder.getResult();
        }
        if (newIsDebugAllPages || newIsStartDebugFrom) {
            PHPDebugPlugin.setDisableAutoRemoveLaunches(true);
        } else {
            PHPDebugPlugin.setDisableAutoRemoveLaunches(!PHPDebugPlugin.getDefault().getInitialAutoRemoveLaunches());
            DebugUIPlugin.getDefault().getLaunchConfigurationManager().launchAdded(newLaunch);
        }
        return true;
    }

    private static void checkAutoRemoveLaunches() {
        if (DebugPlugin.getDefault().getLaunchManager().getLaunches().length == 1) {
            PHPDebugPlugin.setDisableAutoRemoveLaunches(false);
        }
    }

    public static boolean isDebugAllPages(ILaunch launch) throws CoreException {
        String attribute = launch.getAttribute("debugPages");
        return attribute != null && attribute.equals("debugAllPages");
    }

    public static boolean isStartDebugFrom(ILaunch launch) throws CoreException {
        String attribute = launch.getAttribute("debugPages");
        return attribute != null && attribute.equals("debugFrom");
    }

    private static void removeAndTerminateOldLaunches(ILaunch newLaunch) {
        ILaunch[] launches;
        ILaunchManager lManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunch[] iLaunchArray = launches = lManager.getLaunches();
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch element = iLaunchArray[n2];
            ILaunch launch = element;
            if (launch != newLaunch) {
                if (!launch.isTerminated()) {
                    try {
                        launch.terminate();
                    }
                    catch (DebugException e) {
                        Logger.logException(e);
                    }
                }
                lManager.removeLaunch(launch);
            }
            ++n2;
        }
    }

    public static void showWaitForDebuggerMessage(final DebugConnectionThread debugConnectionThread) {
        if (progressDialog != null) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                progressDialog = new DebuggerDelayProgressMonitorDialog();
                if (progressDialog.open() == 1) {
                    debugConnectionThread.closeConnection();
                }
                progressDialog = null;
            }
        });
    }

    public static void hideWaitForDebuggerMessage() {
        if (progressDialog != null) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    if (progressDialog != null) {
                        progressDialog.close();
                    }
                }
            });
            progressDialog = null;
        }
    }

    public static void showLaunchErrorMessage() {
        PHPLaunchUtilities.showDebuggerErrorMessage(PHPDebugCoreMessages.Debugger_Launch_Error, PHPDebugCoreMessages.Debugger_Error_Message);
    }

    public static void showLaunchErrorMessage(String errorMessage) {
        PHPLaunchUtilities.showDebuggerErrorMessage(PHPDebugCoreMessages.Debugger_Launch_Error, errorMessage);
    }

    public static void showDebuggerErrorMessage(final String title, final String errorMessage) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)title, (String)errorMessage);
            }
        });
    }

    public static void openLaunchConfigurationDialog(final ILaunchConfiguration configuration, final String mode) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                ILaunchGroup group;
                ILaunchConfiguration conf = configuration;
                try {
                    ILaunchConfiguration underlyingConfig;
                    String underlyingHandle = configuration.getAttribute(DebugUIPlugin.ATTR_LAUNCHING_CONFIG_HANDLE, "");
                    if (underlyingHandle.length() > 0 && (underlyingConfig = DebugPlugin.getDefault().getLaunchManager().getLaunchConfiguration(underlyingHandle)) != null) {
                        conf = underlyingConfig;
                    }
                }
                catch (CoreException coreException) {}
                if ((group = DebugUITools.getLaunchGroup((ILaunchConfiguration)conf, (String)mode)) != null) {
                    DebugUITools.openLaunchConfigurationDialog((Shell)Display.getDefault().getActiveShell(), (ILaunchConfiguration)conf, (String)group.getIdentifier(), null);
                }
            }
        });
    }

    public static String[] getEnvironment(ILaunchConfiguration configuration, String[] additionalEnv) throws CoreException {
        if (additionalEnv == null) {
            additionalEnv = new String[]{};
        }
        Map<String, String> additionalEnvMap = PHPLaunchUtilities.asAttributesMap(additionalEnv);
        String[] totalEnv = null;
        String[] launchConfigurationEnvironment = DebugPlugin.getDefault().getLaunchManager().getEnvironment(configuration);
        if (launchConfigurationEnvironment != null) {
            Map<String, String> envMap = PHPLaunchUtilities.asAttributesMap(launchConfigurationEnvironment);
            envMap.putAll(additionalEnvMap);
            totalEnv = PHPLaunchUtilities.asAttributesArray(envMap);
        } else {
            Map nativeEnvironment = DebugPlugin.getDefault().getLaunchManager().getNativeEnvironmentCasePreserved();
            nativeEnvironment.putAll(additionalEnvMap);
            totalEnv = PHPLaunchUtilities.asAttributesArray(nativeEnvironment);
        }
        return totalEnv;
    }

    public static Map<String, String> asAttributesMap(String[] attributesArray) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (attributesArray == null) {
            return map;
        }
        String[] stringArray = attributesArray;
        int n = attributesArray.length;
        int n2 = 0;
        while (n2 < n) {
            String attribute = stringArray[n2];
            try {
                int index = attribute.indexOf(61);
                map.put(attribute.substring(0, index), attribute.substring(index + 1));
            }
            catch (Exception e) {
                Logger.logException("Error while parsing launch attribute '" + attribute + '\'', e);
            }
            ++n2;
        }
        return map;
    }

    public static String[] asAttributesArray(Map<String, String> attributesMap) {
        String[] attributes = new String[attributesMap.size()];
        int index = 0;
        for (Map.Entry<String, String> entry : attributesMap.entrySet()) {
            attributes[index++] = String.valueOf(entry.getKey()) + '=' + entry.getValue();
        }
        return attributes;
    }

    public static Map<String, String> getPHPCGILaunchEnvironment(String fileName, String query, String phpConfigDir, String phpExeDir, String[] scriptArguments) {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("REQUEST_METHOD", "GET");
        env.put("SCRIPT_FILENAME", fileName);
        env.put("SCRIPT_NAME", fileName);
        env.put("PATH_TRANSLATED", fileName);
        env.put("PATH_INFO", fileName);
        StringBuilder queryStringBuf = new StringBuilder(query);
        queryStringBuf.append("&debug_host=127.0.0.1");
        if (scriptArguments != null) {
            String[] stringArray = scriptArguments;
            int n = scriptArguments.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                queryStringBuf.append('&').append(arg);
                ++n2;
            }
        }
        env.put("QUERY_STRING", queryStringBuf.toString());
        env.put("REDIRECT_STATUS", "1");
        env.put("PHPRC", phpConfigDir);
        PHPLaunchUtilities.appendLibrarySearchPathEnv(env, new File(phpExeDir));
        return env;
    }

    public static void appendLibrarySearchPathEnv(Map<String, String> env, File phpExeDir) {
        String variable = PHPLaunchUtilities.getLibrarySearchEnvVariable();
        if (variable == null) {
            return;
        }
        String value = PHPLaunchUtilities.getLibrarySearchEnvValue(variable, phpExeDir, false);
        env.put(variable, value);
    }

    public static String getLibrarySearchPathEnv(File phpExeDir, boolean quoted) {
        String variable = PHPLaunchUtilities.getLibrarySearchEnvVariable();
        if (variable == null) {
            return null;
        }
        String value = PHPLaunchUtilities.getLibrarySearchEnvValue(variable, phpExeDir, quoted);
        return variable + '=' + value;
    }

    public static String getLibrarySearchPathEnv(File phpExeDir) {
        return PHPLaunchUtilities.getLibrarySearchPathEnv(phpExeDir, false);
    }

    private static String getLibrarySearchEnvValue(String variable, File phpExeDir, boolean quoted) {
        StringBuilder buf = new StringBuilder();
        File libDirectory = new File(phpExeDir.getParentFile(), "lib");
        if (libDirectory.exists()) {
            buf.append(PHPLaunchUtilities.createPath(libDirectory, quoted));
        } else {
            buf.append(PHPLaunchUtilities.createPath(phpExeDir, quoted));
        }
        try {
            String env = System.getenv(variable);
            if (env != null) {
                buf.append(File.pathSeparatorChar).append(env);
            }
        }
        catch (Throwable throwable) {}
        return buf.toString();
    }

    private static String createPath(File path, boolean quoted) {
        return quoted ? String.valueOf('\"') + path.getAbsolutePath() + '\"' : path.getAbsolutePath();
    }

    private static String getLibrarySearchEnvVariable() {
        String os = System.getProperty("os.name");
        if (os.startsWith("Win")) {
            return null;
        }
        if (os.startsWith("Mac")) {
            return "DYLD_LIBRARY_PATH";
        }
        return "LD_LIBRARY_PATH";
    }

    public static String[] getCommandLine(ILaunchConfiguration configuration, String phpExe, String phpConfigDir, String scriptPath, String[] args) throws CoreException {
        String aspTags = PHPLaunchUtilities.isUsingASPTags(PHPLaunchUtilities.getProject(configuration)) ? "on" : "off";
        LinkedList<String> cmdLineList = new LinkedList<String>();
        cmdLineList.addAll(Arrays.asList(phpExe, "-c", phpConfigDir, "-d", "asp_tags=" + aspTags, scriptPath));
        if (args != null) {
            cmdLineList.addAll(Arrays.asList(args));
        }
        return cmdLineList.toArray(new String[cmdLineList.size()]);
    }

    private static IProject getProject(ILaunchConfiguration configuration) {
        try {
            String fileNameString = configuration.getAttribute("ATTR_FILE", null);
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            Path filePath = new Path(fileNameString);
            IResource res = workspaceRoot.findMember((IPath)filePath);
            if (res != null) {
                return res.getProject();
            }
        }
        catch (CoreException ce) {
            Logger.logException(ce);
        }
        return null;
    }

    public static String[] getProgramArguments(ILaunchConfiguration configuration) throws CoreException {
        String arguments = configuration.getAttribute("exeDebugArguments", null);
        if (arguments == null || arguments.trim().equals("")) {
            return new String[0];
        }
        return VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(arguments).split(" ");
    }

    public static boolean isUsingASPTags(IProject project) {
        PreferencesSupport preferencesSupport = new PreferencesSupport(PHPCorePlugin.getPluginId(), PHPCorePlugin.getDefault().getPluginPreferences());
        String value = preferencesSupport.getPreferencesValue("use_asp_tags_as_php", null, project);
        if (value == null) {
            value = preferencesSupport.getWorkspacePreferencesValue("use_asp_tags_as_php");
        }
        return Boolean.valueOf(value);
    }

    public static String generateQuery(ILaunch launch, IDebugParametersInitializer debugParametersInitializer) {
        StringBuffer buf = new StringBuffer();
        Hashtable<String, String> parameters = debugParametersInitializer.getDebugParameters(launch);
        Enumeration<String> e = parameters.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            buf.append(key).append('=');
            try {
                buf.append(URLEncoder.encode(parameters.get(key), "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
            if (!e.hasMoreElements()) continue;
            buf.append('&');
        }
        return buf.toString();
    }

    private static class DebuggerDelayProgressMonitorDialog
    extends ProgressMonitorDialog {
        public DebuggerDelayProgressMonitorDialog() {
            super(null);
            this.setBlockOnOpen(true);
            this.setCancelable(true);
        }

        protected void createCancelButton(Composite parent) {
            this.cancel = this.createButton(parent, 1, PHPDebugCoreMessages.PHPLaunchUtilities_terminate, true);
            if (this.arrowCursor == null) {
                this.arrowCursor = new Cursor((Device)this.cancel.getDisplay(), 0);
            }
            this.cancel.setCursor(this.arrowCursor);
            this.setOperationCancelButtonEnabled(this.enableCancelButton);
        }

        protected Control createDialogArea(Composite parent) {
            Control c = super.createDialogArea(parent);
            this.getProgressMonitor().beginTask(PHPDebugCoreMessages.PHPLaunchUtilities_waitingForDebugger, -1);
            return c;
        }
    }

    private static class DialogResultHolder {
        private int returnCode;
        private boolean result;

        private DialogResultHolder() {
        }

        public boolean getResult() {
            return this.result;
        }

        public void setResult(boolean result) {
            this.result = result;
        }

        public int getReturnCode() {
            return this.returnCode;
        }

        public void setReturnCode(int returnCode) {
            this.returnCode = returnCode;
        }
    }
}

