/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.util.EditorUtility;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.sse.ui.StructuredTextEditor;

public class PHPOpenExternalFileAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow fWindow;
    private String fFilterPath;
    private StringBuffer notFound = new StringBuffer();

    public PHPOpenExternalFileAction() {
        this.setEnabled(true);
    }

    public void dispose() {
        this.fWindow = null;
        this.fFilterPath = null;
    }

    public void init(IWorkbenchWindow window) {
        this.fWindow = window;
        this.fFilterPath = System.getProperty("user.home");
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void run(List filePaths) {
        if (filePaths != null) {
            int numberOfFilesNotFound = 0;
            for (String currentFilePath : filePaths) {
                numberOfFilesNotFound = this.openFile(numberOfFilesNotFound, currentFilePath, -1);
            }
        }
    }

    public void run(String filePath, int lineNumber) {
        this.openFile(0, filePath, lineNumber);
    }

    private int openFile(int numberOfFilesNotFound, String currentFilePath, int lineNumber) {
        Path path = new Path(currentFilePath);
        this.fFilterPath = path.removeLastSegments(1).toOSString();
        IFileStore fileStore = EFS.getLocalFileSystem().getStore((IPath)new Path(this.fFilterPath));
        if (!(fileStore = fileStore.getChild(path.lastSegment())).fetchInfo().isDirectory() && fileStore.fetchInfo().exists()) {
            IWorkbenchPage page = this.fWindow.getActivePage();
            IEditorPart editorPart = null;
            try {
                IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
                if (lineNumber >= 0) {
                    editorPart = page.getActiveEditor();
                    this.gotoLine(editorPart, currentFilePath, lineNumber);
                }
            }
            catch (PartInitException e) {
                Logger.logException(PHPUIMessages.getString("PHPOpenExternalFileAction.0"), e);
            }
        } else {
            if (++numberOfFilesNotFound > 1) {
                this.notFound.append('\n');
            }
            this.notFound.append(currentFilePath);
        }
        return numberOfFilesNotFound;
    }

    private void gotoLine(IEditorPart editorPart, String filePath, int lineNumber) {
        int offset = 0;
        int length = 0;
        if (editorPart != null && lineNumber > 0 && editorPart instanceof StructuredTextEditor) {
            try {
                IRegion region = ((StructuredTextEditor)editorPart).getTextViewer().getDocument().getLineInformation(lineNumber - 1);
                offset = region.getOffset();
                length = region.getLength();
            }
            catch (BadLocationException badLocationException) {
                return;
            }
            if (editorPart != null) {
                EditorUtility.revealInEditor(editorPart, offset, length);
            }
        }
    }

    public String getFileNotFoundStr() {
        return this.notFound.toString();
    }

    private String getEditorId(IFileStore file) {
        IWorkbench workbench = this.fWindow.getWorkbench();
        IEditorRegistry editorRegistry = workbench.getEditorRegistry();
        IEditorDescriptor descriptor = editorRegistry.getDefaultEditor(file.getName(), this.getContentType(file));
        if (descriptor == null && editorRegistry.isSystemInPlaceEditorAvailable(file.getName())) {
            descriptor = editorRegistry.findEditor("org.eclipse.ui.systemInPlaceEditor");
        }
        if (descriptor == null && editorRegistry.isSystemExternalEditorAvailable(file.getName())) {
            descriptor = editorRegistry.findEditor("org.eclipse.ui.systemExternalEditor");
        }
        if (descriptor != null) {
            return descriptor.getId();
        }
        return "org.eclipse.ui.DefaultTextEditor";
    }

    private IContentType getContentType(IFileStore fileStore) {
        if (fileStore == null) {
            return null;
        }
        InputStream stream = null;
        try {
            stream = fileStore.openInputStream(0, null);
            IContentType iContentType = Platform.getContentTypeManager().findContentTypeFor(stream, fileStore.getName());
            return iContentType;
        }
        catch (IOException x) {
            EditorsPlugin.log((Throwable)x);
            return null;
        }
        catch (CoreException x) {
            if (!(x.getStatus().getException() instanceof FileNotFoundException)) {
                EditorsPlugin.log((Throwable)x);
            }
            return null;
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException x) {
                EditorsPlugin.log((Throwable)x);
            }
        }
    }

    private IEditorInput createEditorInput(IFileStore fileStore) {
        IFile workspaceFile = this.getWorkspaceFile(fileStore);
        if (workspaceFile != null) {
            return new FileEditorInput(workspaceFile);
        }
        return new FileStoreEditorInput(fileStore);
    }

    private IFile getWorkspaceFile(IFileStore fileStore) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IFile[] files = workspace.getRoot().findFilesForLocation((IPath)new Path(fileStore.toURI().getPath()));
        if ((files = this.filterNonExistentFiles(files)) == null || files.length == 0) {
            return null;
        }
        if (files.length == 1) {
            return files[0];
        }
        return this.selectWorkspaceFile(files);
    }

    private IFile[] filterNonExistentFiles(IFile[] files) {
        if (files == null) {
            return null;
        }
        int length = files.length;
        ArrayList<IFile> existentFiles = new ArrayList<IFile>(length);
        int i = 0;
        while (i < length) {
            if (files[i].exists()) {
                existentFiles.add(files[i]);
            }
            ++i;
        }
        return existentFiles.toArray(new IFile[existentFiles.size()]);
    }

    private IFile selectWorkspaceFile(IFile[] files) {
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.fWindow.getShell(), (ILabelProvider)new FileLabelProvider());
        dialog.setElements((Object[])files);
        if (dialog.open() == 0) {
            return (IFile)dialog.getFirstResult();
        }
        return null;
    }

    static class FileLabelProvider
    extends LabelProvider {
        FileLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IFile) {
                IPath path = ((IFile)element).getFullPath();
                return path != null ? path.toString() : "";
            }
            return super.getText(element);
        }
    }
}

