/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.projectoutlineview;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.internal.ui.navigator.ScriptExplorerLabelProvider;
import org.eclipse.dltk.internal.ui.scriptview.ScriptExplorerPart;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.ModelElementSorter;
import org.eclipse.dltk.ui.viewsupport.ProblemTreeViewer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.projectoutlineview.ProjectOutlineContentProvider;
import org.eclipse.php.internal.ui.projectoutlineview.ProjectOutlineLabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;

public class ProjectOutlinePart
extends ScriptExplorerPart
implements IPartListener {
    public ProjectOutlineContentProvider createContentProvider() {
        boolean showCUChildren = DLTKUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.dltk.ui.packages.cuchildren");
        return new ProjectOutlineContentProvider(showCUChildren){

            protected IPreferenceStore getPreferenceStore() {
                return DLTKUIPlugin.getDefault().getPreferenceStore();
            }
        };
    }

    public String getTitleToolTip() {
        return PHPUIMessages.getString("PHPProjectOutline.title.tooltip");
    }

    protected ScriptExplorerLabelProvider createLabelProvider() {
        IPreferenceStore store = DLTKUIPlugin.getDefault().getPreferenceStore();
        return new ProjectOutlineLabelProvider(this.getContentProvider(), store);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.getSite().getPage().addPartListener((IPartListener)this);
        this.selectProject(null);
    }

    protected void setComparator() {
        this.getTreeViewer().setComparator((ViewerComparator)new ModelElementSorter());
    }

    private void setInputAsEditor(IScriptProject scriptProject) {
        TreeViewer treeViewer = this.getTreeViewer();
        if (treeViewer.getInput() == null || !treeViewer.getInput().equals(scriptProject)) {
            treeViewer.setInput((Object)scriptProject);
        }
    }

    private void setInputAsEditor(IEditorPart editor) {
        this.setInputAsEditor((IScriptProject)this.getInput(editor));
    }

    public void dispose() {
        this.getSite().getPage().removePartListener((IPartListener)this);
        super.dispose();
    }

    private Object getInput(IEditorPart editor) {
        IEditorInput editorInput = editor.getEditorInput();
        IFile file = (IFile)editorInput.getAdapter(IFile.class);
        if (file != null) {
            IProject project = file.getProject();
            return DLTKCore.create((IProject)project);
        }
        return null;
    }

    public void partActivated(IWorkbenchPart part) {
        this.selectProject(part);
    }

    private void selectProject(IWorkbenchPart part) {
        IEditorPart editor = this.getSite().getPage().getActiveEditor();
        if (editor != null) {
            this.setInputAsEditor(editor);
        } else if (part instanceof ScriptExplorerPart) {
            this.setInputAsExplorerProject(part);
            return;
        }
    }

    private void setInputAsExplorerProject(IWorkbenchPart part) {
        IProject[] projects;
        TreeSelection input = (TreeSelection)((ScriptExplorerPart)part).getTreeViewer().getSelection();
        IScriptProject scriptProject = null;
        if (input.getFirstElement() instanceof IModelElement) {
            scriptProject = (IScriptProject)((IModelElement)input.getFirstElement()).getAncestor(2);
        }
        if (scriptProject == null && (projects = ResourcesPlugin.getWorkspace().getRoot().getProjects()) != null && projects.length != 0) {
            scriptProject = DLTKCore.create((IProject)projects[0]);
        }
        this.setInputAsEditor(scriptProject);
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
        this.selectProject(part);
    }

    protected ProblemTreeViewer createViewer(Composite composite) {
        return new ProjectOutlineProblemTreeViewer(composite, 770);
    }

    protected class ProjectOutlineProblemTreeViewer
    extends ScriptExplorerPart.PackageExplorerProblemTreeViewer {
        public ProjectOutlineProblemTreeViewer(Composite parent, int style) {
            super((ScriptExplorerPart)ProjectOutlinePart.this, parent, style);
        }

        protected boolean evaluateExpandableWithFilters(Object parent) {
            return false;
        }
    }
}

