/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.internal.ui.util.EditorUtility;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.sse.ui.internal.FileDropAction;

public class FileDropEditorOpenAction
extends FileDropAction {
    public boolean run(DropTargetEvent event, IEditorPart targetEditor) {
        if (!(targetEditor instanceof PHPStructuredEditor)) {
            return super.run(event, targetEditor);
        }
        final String[] fileNames = (String[])event.data;
        if (fileNames == null || fileNames.length == 0) {
            return false;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                int i = 0;
                while (i < fileNames.length) {
                    IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(fileNames[i]));
                    if (file != null) {
                        try {
                            EditorUtility.openInEditor(file, true);
                        }
                        catch (PartInitException e) {
                            Logger.logException(e);
                        }
                    } else if (new File(fileNames[i]).exists()) {
                        EditorUtility.openFileInEditor(fileNames[i], 0);
                    }
                    ++i;
                }
            }
        });
        return true;
    }
}

